@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The Defender for Databases GCP offering configurations
 * @property arcAutoProvisioning The ARC autoprovisioning configuration
 * @property defenderForDatabasesArcAutoProvisioning The native cloud connection configuration
 * @property description The offering description.
 * @property offeringType The type of the security offering.
 * Expected value is 'DefenderForDatabasesGcp'.
 */
public data class DefenderForDatabasesGcpOfferingResponse(
    public val arcAutoProvisioning: DefenderForDatabasesGcpOfferingResponseArcAutoProvisioning? =
        null,
    public val defenderForDatabasesArcAutoProvisioning:
    DefenderForDatabasesGcpOfferingResponseDefenderForDatabasesArcAutoProvisioning? = null,
    public val description: String,
    public val offeringType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.DefenderForDatabasesGcpOfferingResponse):
            DefenderForDatabasesGcpOfferingResponse = DefenderForDatabasesGcpOfferingResponse(
            arcAutoProvisioning = javaType.arcAutoProvisioning().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.DefenderForDatabasesGcpOfferingResponseArcAutoProvisioning.Companion.toKotlin(args0)
                })
            }).orElse(null),
            defenderForDatabasesArcAutoProvisioning = javaType.defenderForDatabasesArcAutoProvisioning().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.DefenderForDatabasesGcpOfferingResponseDefenderForDatabasesArcAutoProvisioning.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description(),
            offeringType = javaType.offeringType(),
        )
    }
}
