@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The Defender for Servers AWS offering
 * @property arcAutoProvisioning The ARC autoprovisioning configuration
 * @property defenderForServers The Defender for servers connection configuration
 * @property description The offering description.
 * @property mdeAutoProvisioning The Microsoft Defender for Endpoint autoprovisioning configuration
 * @property offeringType The type of the security offering.
 * Expected value is 'DefenderForServersAws'.
 * @property subPlan configuration for the servers offering subPlan
 * @property vaAutoProvisioning The Vulnerability Assessment autoprovisioning configuration
 * @property vmScanners The Microsoft Defender for Server VM scanning configuration
 */
public data class DefenderForServersAwsOfferingResponse(
    public val arcAutoProvisioning: DefenderForServersAwsOfferingResponseArcAutoProvisioning? = null,
    public val defenderForServers: DefenderForServersAwsOfferingResponseDefenderForServers? = null,
    public val description: String,
    public val mdeAutoProvisioning: DefenderForServersAwsOfferingResponseMdeAutoProvisioning? = null,
    public val offeringType: String,
    public val subPlan: DefenderForServersAwsOfferingResponseSubPlan? = null,
    public val vaAutoProvisioning: DefenderForServersAwsOfferingResponseVaAutoProvisioning? = null,
    public val vmScanners: DefenderForServersAwsOfferingResponseVmScanners? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.DefenderForServersAwsOfferingResponse):
            DefenderForServersAwsOfferingResponse = DefenderForServersAwsOfferingResponse(
            arcAutoProvisioning = javaType.arcAutoProvisioning().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.DefenderForServersAwsOfferingResponseArcAutoProvisioning.Companion.toKotlin(args0)
                })
            }).orElse(null),
            defenderForServers = javaType.defenderForServers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.DefenderForServersAwsOfferingResponseDefenderForServers.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description(),
            mdeAutoProvisioning = javaType.mdeAutoProvisioning().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.DefenderForServersAwsOfferingResponseMdeAutoProvisioning.Companion.toKotlin(args0)
                })
            }).orElse(null),
            offeringType = javaType.offeringType(),
            subPlan = javaType.subPlan().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.DefenderForServersAwsOfferingResponseSubPlan.Companion.toKotlin(args0)
                })
            }).orElse(null),
            vaAutoProvisioning = javaType.vaAutoProvisioning().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.DefenderForServersAwsOfferingResponseVaAutoProvisioning.Companion.toKotlin(args0)
                })
            }).orElse(null),
            vmScanners = javaType.vmScanners().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.DefenderForServersAwsOfferingResponseVmScanners.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
