@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The Defender for Servers GCP offering configurations
 * @property arcAutoProvisioning The ARC autoprovisioning configuration
 * @property defenderForServers The Defender for servers connection configuration
 * @property description The offering description.
 * @property mdeAutoProvisioning The Microsoft Defender for Endpoint autoprovisioning configuration
 * @property offeringType The type of the security offering.
 * Expected value is 'DefenderForServersGcp'.
 * @property subPlan configuration for the servers offering subPlan
 * @property vaAutoProvisioning The Vulnerability Assessment autoprovisioning configuration
 * @property vmScanners The Microsoft Defender for Server VM scanning configuration
 */
public data class DefenderForServersGcpOfferingResponse(
    public val arcAutoProvisioning: DefenderForServersGcpOfferingResponseArcAutoProvisioning? = null,
    public val defenderForServers: DefenderForServersGcpOfferingResponseDefenderForServers? = null,
    public val description: String,
    public val mdeAutoProvisioning: DefenderForServersGcpOfferingResponseMdeAutoProvisioning? = null,
    public val offeringType: String,
    public val subPlan: DefenderForServersGcpOfferingResponseSubPlan? = null,
    public val vaAutoProvisioning: DefenderForServersGcpOfferingResponseVaAutoProvisioning? = null,
    public val vmScanners: DefenderForServersGcpOfferingResponseVmScanners? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.DefenderForServersGcpOfferingResponse):
            DefenderForServersGcpOfferingResponse = DefenderForServersGcpOfferingResponse(
            arcAutoProvisioning = javaType.arcAutoProvisioning().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.DefenderForServersGcpOfferingResponseArcAutoProvisioning.Companion.toKotlin(args0)
                })
            }).orElse(null),
            defenderForServers = javaType.defenderForServers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.DefenderForServersGcpOfferingResponseDefenderForServers.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description(),
            mdeAutoProvisioning = javaType.mdeAutoProvisioning().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.DefenderForServersGcpOfferingResponseMdeAutoProvisioning.Companion.toKotlin(args0)
                })
            }).orElse(null),
            offeringType = javaType.offeringType(),
            subPlan = javaType.subPlan().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.DefenderForServersGcpOfferingResponseSubPlan.Companion.toKotlin(args0)
                })
            }).orElse(null),
            vaAutoProvisioning = javaType.vaAutoProvisioning().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.DefenderForServersGcpOfferingResponseVaAutoProvisioning.Companion.toKotlin(args0)
                })
            }).orElse(null),
            vmScanners = javaType.vmScanners().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.DefenderForServersGcpOfferingResponseVmScanners.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
