@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * configuration for Microsoft Defender for Server VM scanning
 * @property exclusionTags VM tags that indicate that VM should not be scanned
 * @property scanningMode The scanning mode for the VM scan.
 */
public data class DefenderForServersGcpOfferingResponseConfigurationConfigurationConfiguration(
    public val exclusionTags: Map<String, String>? = null,
    public val scanningMode: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.DefenderForServersGcpOfferingResponseConfigurationConfigurationConfiguration):
            DefenderForServersGcpOfferingResponseConfigurationConfigurationConfiguration =
            DefenderForServersGcpOfferingResponseConfigurationConfigurationConfiguration(
                exclusionTags = javaType.exclusionTags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                scanningMode = javaType.scanningMode().map({ args0 -> args0 }).orElse(null),
            )
    }
}
