@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * DevOps Configuration properties.
 * @property authorization Authorization payload.
 * @property autoDiscovery AutoDiscovery states.
 * @property provisioningState The provisioning state of the resource.
 * Pending - Provisioning pending.
 * Failed - Provisioning failed.
 * Succeeded - Successful provisioning.
 * Canceled - Provisioning canceled.
 * PendingDeletion - Deletion pending.
 * DeletionSuccess - Deletion successful.
 * DeletionFailure - Deletion failure.
 * @property provisioningStatusMessage Gets or sets resource status message.
 * @property provisioningStatusUpdateTimeUtc Gets or sets time when resource was last checked.
 * @property topLevelInventoryList List of top-level inventory to select when AutoDiscovery is disabled.
 * This field is ignored when AutoDiscovery is enabled.
 */
public data class DevOpsConfigurationPropertiesResponse(
    public val authorization: AuthorizationResponse? = null,
    public val autoDiscovery: String? = null,
    public val provisioningState: String? = null,
    public val provisioningStatusMessage: String,
    public val provisioningStatusUpdateTimeUtc: String,
    public val topLevelInventoryList: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.DevOpsConfigurationPropertiesResponse):
            DevOpsConfigurationPropertiesResponse = DevOpsConfigurationPropertiesResponse(
            authorization = javaType.authorization().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.AuthorizationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            autoDiscovery = javaType.autoDiscovery().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            provisioningStatusMessage = javaType.provisioningStatusMessage(),
            provisioningStatusUpdateTimeUtc = javaType.provisioningStatusUpdateTimeUtc(),
            topLevelInventoryList = javaType.topLevelInventoryList().map({ args0 -> args0 }),
        )
    }
}
