@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The security automation resource.
 * @property actions A collection of the actions which are triggered if all the configured rules evaluations, within at least one rule set, are true.
 * @property description The security automation description.
 * @property etag Entity tag is used for comparing two or more entities from the same requested resource.
 * @property id Resource Id
 * @property isEnabled Indicates whether the security automation is enabled.
 * @property kind Kind of the resource
 * @property location Location where the resource is stored
 * @property name Resource name
 * @property scopes A collection of scopes on which the security automations logic is applied. Supported scopes are the subscription itself or a resource group under that subscription. The automation will only apply on defined scopes.
 * @property sources A collection of the source event types which evaluate the security automation set of rules.
 * @property tags A list of key value pairs that describe the resource.
 * @property type Resource type
 */
public data class GetAutomationResult(
    public val actions: List<Any>? = null,
    public val description: String? = null,
    public val etag: String? = null,
    public val id: String,
    public val isEnabled: Boolean? = null,
    public val kind: String? = null,
    public val location: String? = null,
    public val name: String,
    public val scopes: List<AutomationScopeResponse>? = null,
    public val sources: List<AutomationSourceResponse>? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GetAutomationResult):
            GetAutomationResult = GetAutomationResult(
            actions = javaType.actions().map({ args0 -> args0 }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            isEnabled = javaType.isEnabled().map({ args0 -> args0 }).orElse(null),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            scopes = javaType.scopes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.AutomationScopeResponse.Companion.toKotlin(args0)
                })
            }),
            sources = javaType.sources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.AutomationSourceResponse.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
