@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Custom entity store assignment
 * @property entityStoreDatabaseLink The link to entity store database.
 * @property id Resource Id
 * @property name Resource name
 * @property principal The principal assigned with entity store. Format of principal is: [AAD type]=[PrincipalObjectId];[TenantId]
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type Resource type
 */
public data class GetCustomEntityStoreAssignmentResult(
    public val entityStoreDatabaseLink: String? = null,
    public val id: String,
    public val name: String,
    public val principal: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GetCustomEntityStoreAssignmentResult):
            GetCustomEntityStoreAssignmentResult = GetCustomEntityStoreAssignmentResult(
            entityStoreDatabaseLink = javaType.entityStoreDatabaseLink().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            principal = javaType.principal().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.security.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
