@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Microsoft Defender for Cloud is provided in two pricing tiers: free and standard. The standard tier offers advanced security capabilities, while the free tier offers basic security features.
 * @property deprecated Optional. True if the plan is deprecated. If there are replacing plans they will appear in `replacedBy` property
 * @property enablementTime Optional. If `pricingTier` is `Standard` then this property holds the date of the last time the `pricingTier` was set to `Standard`, when available (e.g 2023-03-01T12:42:42.1921106Z).
 * @property enforce If set to "False", it allows the descendants of this scope to override the pricing configuration set on this scope (allows setting inherited="False"). If set to "True", it prevents overrides and forces this pricing configuration on all the descendants of this scope. This field is only available for subscription-level pricing.
 * @property extensions Optional. List of extensions offered under a plan.
 * @property freeTrialRemainingTime The duration left for the subscriptions free trial period - in ISO 8601 format (e.g. P3Y6M4DT12H30M5S).
 * @property id Resource Id
 * @property inherited "inherited" = "True" indicates that the current scope inherits its pricing configuration from its parent. The ID of the parent scope that provides the inherited configuration is displayed in the "inheritedFrom" field. On the other hand, "inherited" = "False" indicates that the current scope has its own pricing configuration explicitly set, and does not inherit from its parent. This field is read only and available only for resource-level pricing.
 * @property inheritedFrom The id of the scope inherited from. "Null" if not inherited. This field is only available for resource-level pricing.
 * @property name Resource name
 * @property pricingTier Indicates whether the Defender plan is enabled on the selected scope. Microsoft Defender for Cloud is provided in two pricing tiers: free and standard. The standard tier offers advanced security capabilities, while the free tier offers basic security features.
 * @property replacedBy Optional. List of plans that replace this plan. This property exists only if this plan is deprecated.
 * @property resourcesCoverageStatus This field is available for subscription-level only, and reflects the coverage status of the resources under the subscription. Please note: The "pricingTier" field reflects the plan status of the subscription. However, since the plan status can also be defined at the resource level, there might be misalignment between the subscription's plan status and the resource status. This field helps indicate the coverage status of the resources.
 * @property subPlan The sub-plan selected for a Standard pricing configuration, when more than one sub-plan is available. Each sub-plan enables a set of security features. When not specified, full plan is applied. For VirtualMachines plan, available sub plans are 'P1' & 'P2', where for resource level only 'P1' sub plan is supported.
 * @property type Resource type
 */
public data class GetPricingResult(
    public val deprecated: Boolean,
    public val enablementTime: String,
    public val enforce: String? = null,
    public val extensions: List<ExtensionResponse>? = null,
    public val freeTrialRemainingTime: String,
    public val id: String,
    public val inherited: String,
    public val inheritedFrom: String,
    public val name: String,
    public val pricingTier: String,
    public val replacedBy: List<String>,
    public val resourcesCoverageStatus: String,
    public val subPlan: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GetPricingResult):
            GetPricingResult = GetPricingResult(
            deprecated = javaType.deprecated(),
            enablementTime = javaType.enablementTime(),
            enforce = javaType.enforce().map({ args0 -> args0 }).orElse(null),
            extensions = javaType.extensions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.ExtensionResponse.Companion.toKotlin(args0)
                })
            }),
            freeTrialRemainingTime = javaType.freeTrialRemainingTime(),
            id = javaType.id(),
            inherited = javaType.inherited(),
            inheritedFrom = javaType.inheritedFrom(),
            name = javaType.name(),
            pricingTier = javaType.pricingTier(),
            replacedBy = javaType.replacedBy().map({ args0 -> args0 }),
            resourcesCoverageStatus = javaType.resourcesCoverageStatus(),
            subPlan = javaType.subPlan().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
