@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Rule results.
 * @property id Resource Id
 * @property name Resource name
 * @property properties Rule results properties.
 * @property type Resource type
 */
public data class GetSqlVulnerabilityAssessmentBaselineRuleResult(
    public val id: String,
    public val name: String,
    public val properties: RuleResultsPropertiesResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GetSqlVulnerabilityAssessmentBaselineRuleResult):
            GetSqlVulnerabilityAssessmentBaselineRuleResult =
            GetSqlVulnerabilityAssessmentBaselineRuleResult(
                id = javaType.id(),
                name = javaType.name(),
                properties = javaType.properties().let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.RuleResultsPropertiesResponse.Companion.toKotlin(args0)
                }),
                type = javaType.type(),
            )
    }
}
