@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property allowedSourceAddressPrefix Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
 * @property allowedSourceAddressPrefixes Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
 * @property endTimeUtc The date & time at which the request ends in UTC
 * @property mappedPort The port which is mapped to this port's `number` in the Azure Firewall, if applicable
 * @property number
 * @property status The status of the port
 * @property statusReason A description of why the `status` has its value
 */
public data class JitNetworkAccessRequestPortResponse(
    public val allowedSourceAddressPrefix: String? = null,
    public val allowedSourceAddressPrefixes: List<String>? = null,
    public val endTimeUtc: String,
    public val mappedPort: Int? = null,
    public val number: Int,
    public val status: String,
    public val statusReason: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.JitNetworkAccessRequestPortResponse):
            JitNetworkAccessRequestPortResponse = JitNetworkAccessRequestPortResponse(
            allowedSourceAddressPrefix = javaType.allowedSourceAddressPrefix().map({ args0 ->
                args0
            }).orElse(null),
            allowedSourceAddressPrefixes = javaType.allowedSourceAddressPrefixes().map({ args0 -> args0 }),
            endTimeUtc = javaType.endTimeUtc(),
            mappedPort = javaType.mappedPort().map({ args0 -> args0 }).orElse(null),
            number = javaType.number(),
            status = javaType.status(),
            statusReason = javaType.statusReason(),
        )
    }
}
