@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes properties of an assessment metadata.
 * @property assessmentType BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom Azure Policy definition
 * @property categories
 * @property description Human readable description of the assessment
 * @property displayName User friendly display name of the assessment
 * @property implementationEffort The implementation effort required to remediate this assessment
 * @property partnerData Describes the partner that created the assessment
 * @property policyDefinitionId Azure resource ID of the policy definition that turns this assessment calculation on
 * @property preview True if this assessment is in preview release status
 * @property remediationDescription Human readable description of what you should do to mitigate this security issue
 * @property severity The severity level of the assessment
 * @property threats
 * @property userImpact The user impact of the assessment
 */
public data class SecurityAssessmentMetadataPropertiesResponse(
    public val assessmentType: String,
    public val categories: List<String>? = null,
    public val description: String? = null,
    public val displayName: String,
    public val implementationEffort: String? = null,
    public val partnerData: SecurityAssessmentMetadataPartnerDataResponse? = null,
    public val policyDefinitionId: String,
    public val preview: Boolean? = null,
    public val remediationDescription: String? = null,
    public val severity: String,
    public val threats: List<String>? = null,
    public val userImpact: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.SecurityAssessmentMetadataPropertiesResponse):
            SecurityAssessmentMetadataPropertiesResponse = SecurityAssessmentMetadataPropertiesResponse(
            assessmentType = javaType.assessmentType(),
            categories = javaType.categories().map({ args0 -> args0 }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName(),
            implementationEffort = javaType.implementationEffort().map({ args0 -> args0 }).orElse(null),
            partnerData = javaType.partnerData().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.SecurityAssessmentMetadataPartnerDataResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            policyDefinitionId = javaType.policyDefinitionId(),
            preview = javaType.preview().map({ args0 -> args0 }).orElse(null),
            remediationDescription = javaType.remediationDescription().map({ args0 -> args0 }).orElse(null),
            severity = javaType.severity(),
            threats = javaType.threats().map({ args0 -> args0 }),
            userImpact = javaType.userImpact().map({ args0 -> args0 }).orElse(null),
        )
    }
}
