@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * Properties of Sensitive Data Discovery.
 * @property isEnabled Indicates whether Sensitive Data Discovery should be enabled.
 * @property operationStatus Upon failure or partial success. Additional data describing Sensitive Data Discovery enable/disable operation.
 */
public data class SensitiveDataDiscoveryPropertiesResponse(
    public val isEnabled: Boolean? = null,
    public val operationStatus: OperationStatusResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.SensitiveDataDiscoveryPropertiesResponse):
            SensitiveDataDiscoveryPropertiesResponse = SensitiveDataDiscoveryPropertiesResponse(
            isEnabled = javaType.isEnabled().map({ args0 -> args0 }).orElse(null),
            operationStatus = javaType.operationStatus().let({ args0 ->
                com.pulumi.azurenative.security.kotlin.outputs.OperationStatusResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
