@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityandcompliance.kotlin

import com.pulumi.azurenative.securityandcompliance.SecurityandcomplianceFunctions.getPrivateEndpointConnectionsAdtAPIPlain
import com.pulumi.azurenative.securityandcompliance.SecurityandcomplianceFunctions.getPrivateEndpointConnectionsCompPlain
import com.pulumi.azurenative.securityandcompliance.SecurityandcomplianceFunctions.getPrivateEndpointConnectionsForEDMPlain
import com.pulumi.azurenative.securityandcompliance.SecurityandcomplianceFunctions.getPrivateEndpointConnectionsForMIPPolicySyncPlain
import com.pulumi.azurenative.securityandcompliance.SecurityandcomplianceFunctions.getPrivateEndpointConnectionsForSCCPowershellPlain
import com.pulumi.azurenative.securityandcompliance.SecurityandcomplianceFunctions.getPrivateEndpointConnectionsSecPlain
import com.pulumi.azurenative.securityandcompliance.SecurityandcomplianceFunctions.getPrivateLinkServicesForEDMUploadPlain
import com.pulumi.azurenative.securityandcompliance.SecurityandcomplianceFunctions.getPrivateLinkServicesForM365ComplianceCenterPlain
import com.pulumi.azurenative.securityandcompliance.SecurityandcomplianceFunctions.getPrivateLinkServicesForM365SecurityCenterPlain
import com.pulumi.azurenative.securityandcompliance.SecurityandcomplianceFunctions.getPrivateLinkServicesForMIPPolicySyncPlain
import com.pulumi.azurenative.securityandcompliance.SecurityandcomplianceFunctions.getPrivateLinkServicesForO365ManagementActivityAPIPlain
import com.pulumi.azurenative.securityandcompliance.SecurityandcomplianceFunctions.getPrivateLinkServicesForSCCPowershellPlain
import com.pulumi.azurenative.securityandcompliance.kotlin.inputs.GetPrivateEndpointConnectionsAdtAPIPlainArgs
import com.pulumi.azurenative.securityandcompliance.kotlin.inputs.GetPrivateEndpointConnectionsAdtAPIPlainArgsBuilder
import com.pulumi.azurenative.securityandcompliance.kotlin.inputs.GetPrivateEndpointConnectionsCompPlainArgs
import com.pulumi.azurenative.securityandcompliance.kotlin.inputs.GetPrivateEndpointConnectionsCompPlainArgsBuilder
import com.pulumi.azurenative.securityandcompliance.kotlin.inputs.GetPrivateEndpointConnectionsForEDMPlainArgs
import com.pulumi.azurenative.securityandcompliance.kotlin.inputs.GetPrivateEndpointConnectionsForEDMPlainArgsBuilder
import com.pulumi.azurenative.securityandcompliance.kotlin.inputs.GetPrivateEndpointConnectionsForMIPPolicySyncPlainArgs
import com.pulumi.azurenative.securityandcompliance.kotlin.inputs.GetPrivateEndpointConnectionsForMIPPolicySyncPlainArgsBuilder
import com.pulumi.azurenative.securityandcompliance.kotlin.inputs.GetPrivateEndpointConnectionsForSCCPowershellPlainArgs
import com.pulumi.azurenative.securityandcompliance.kotlin.inputs.GetPrivateEndpointConnectionsForSCCPowershellPlainArgsBuilder
import com.pulumi.azurenative.securityandcompliance.kotlin.inputs.GetPrivateEndpointConnectionsSecPlainArgs
import com.pulumi.azurenative.securityandcompliance.kotlin.inputs.GetPrivateEndpointConnectionsSecPlainArgsBuilder
import com.pulumi.azurenative.securityandcompliance.kotlin.inputs.GetPrivateLinkServicesForEDMUploadPlainArgs
import com.pulumi.azurenative.securityandcompliance.kotlin.inputs.GetPrivateLinkServicesForEDMUploadPlainArgsBuilder
import com.pulumi.azurenative.securityandcompliance.kotlin.inputs.GetPrivateLinkServicesForM365ComplianceCenterPlainArgs
import com.pulumi.azurenative.securityandcompliance.kotlin.inputs.GetPrivateLinkServicesForM365ComplianceCenterPlainArgsBuilder
import com.pulumi.azurenative.securityandcompliance.kotlin.inputs.GetPrivateLinkServicesForM365SecurityCenterPlainArgs
import com.pulumi.azurenative.securityandcompliance.kotlin.inputs.GetPrivateLinkServicesForM365SecurityCenterPlainArgsBuilder
import com.pulumi.azurenative.securityandcompliance.kotlin.inputs.GetPrivateLinkServicesForMIPPolicySyncPlainArgs
import com.pulumi.azurenative.securityandcompliance.kotlin.inputs.GetPrivateLinkServicesForMIPPolicySyncPlainArgsBuilder
import com.pulumi.azurenative.securityandcompliance.kotlin.inputs.GetPrivateLinkServicesForO365ManagementActivityAPIPlainArgs
import com.pulumi.azurenative.securityandcompliance.kotlin.inputs.GetPrivateLinkServicesForO365ManagementActivityAPIPlainArgsBuilder
import com.pulumi.azurenative.securityandcompliance.kotlin.inputs.GetPrivateLinkServicesForSCCPowershellPlainArgs
import com.pulumi.azurenative.securityandcompliance.kotlin.inputs.GetPrivateLinkServicesForSCCPowershellPlainArgsBuilder
import com.pulumi.azurenative.securityandcompliance.kotlin.outputs.GetPrivateEndpointConnectionsAdtAPIResult
import com.pulumi.azurenative.securityandcompliance.kotlin.outputs.GetPrivateEndpointConnectionsCompResult
import com.pulumi.azurenative.securityandcompliance.kotlin.outputs.GetPrivateEndpointConnectionsForEDMResult
import com.pulumi.azurenative.securityandcompliance.kotlin.outputs.GetPrivateEndpointConnectionsForMIPPolicySyncResult
import com.pulumi.azurenative.securityandcompliance.kotlin.outputs.GetPrivateEndpointConnectionsForSCCPowershellResult
import com.pulumi.azurenative.securityandcompliance.kotlin.outputs.GetPrivateEndpointConnectionsSecResult
import com.pulumi.azurenative.securityandcompliance.kotlin.outputs.GetPrivateLinkServicesForEDMUploadResult
import com.pulumi.azurenative.securityandcompliance.kotlin.outputs.GetPrivateLinkServicesForM365ComplianceCenterResult
import com.pulumi.azurenative.securityandcompliance.kotlin.outputs.GetPrivateLinkServicesForM365SecurityCenterResult
import com.pulumi.azurenative.securityandcompliance.kotlin.outputs.GetPrivateLinkServicesForMIPPolicySyncResult
import com.pulumi.azurenative.securityandcompliance.kotlin.outputs.GetPrivateLinkServicesForO365ManagementActivityAPIResult
import com.pulumi.azurenative.securityandcompliance.kotlin.outputs.GetPrivateLinkServicesForSCCPowershellResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.securityandcompliance.kotlin.outputs.GetPrivateEndpointConnectionsAdtAPIResult.Companion.toKotlin as getPrivateEndpointConnectionsAdtAPIResultToKotlin
import com.pulumi.azurenative.securityandcompliance.kotlin.outputs.GetPrivateEndpointConnectionsCompResult.Companion.toKotlin as getPrivateEndpointConnectionsCompResultToKotlin
import com.pulumi.azurenative.securityandcompliance.kotlin.outputs.GetPrivateEndpointConnectionsForEDMResult.Companion.toKotlin as getPrivateEndpointConnectionsForEDMResultToKotlin
import com.pulumi.azurenative.securityandcompliance.kotlin.outputs.GetPrivateEndpointConnectionsForMIPPolicySyncResult.Companion.toKotlin as getPrivateEndpointConnectionsForMIPPolicySyncResultToKotlin
import com.pulumi.azurenative.securityandcompliance.kotlin.outputs.GetPrivateEndpointConnectionsForSCCPowershellResult.Companion.toKotlin as getPrivateEndpointConnectionsForSCCPowershellResultToKotlin
import com.pulumi.azurenative.securityandcompliance.kotlin.outputs.GetPrivateEndpointConnectionsSecResult.Companion.toKotlin as getPrivateEndpointConnectionsSecResultToKotlin
import com.pulumi.azurenative.securityandcompliance.kotlin.outputs.GetPrivateLinkServicesForEDMUploadResult.Companion.toKotlin as getPrivateLinkServicesForEDMUploadResultToKotlin
import com.pulumi.azurenative.securityandcompliance.kotlin.outputs.GetPrivateLinkServicesForM365ComplianceCenterResult.Companion.toKotlin as getPrivateLinkServicesForM365ComplianceCenterResultToKotlin
import com.pulumi.azurenative.securityandcompliance.kotlin.outputs.GetPrivateLinkServicesForM365SecurityCenterResult.Companion.toKotlin as getPrivateLinkServicesForM365SecurityCenterResultToKotlin
import com.pulumi.azurenative.securityandcompliance.kotlin.outputs.GetPrivateLinkServicesForMIPPolicySyncResult.Companion.toKotlin as getPrivateLinkServicesForMIPPolicySyncResultToKotlin
import com.pulumi.azurenative.securityandcompliance.kotlin.outputs.GetPrivateLinkServicesForO365ManagementActivityAPIResult.Companion.toKotlin as getPrivateLinkServicesForO365ManagementActivityAPIResultToKotlin
import com.pulumi.azurenative.securityandcompliance.kotlin.outputs.GetPrivateLinkServicesForSCCPowershellResult.Companion.toKotlin as getPrivateLinkServicesForSCCPowershellResultToKotlin

public object SecurityandcomplianceFunctions {
    /**
     * Gets the specified private endpoint connection associated with the service.
     * Azure REST API version: 2021-03-08.
     * @param argument null
     * @return The Private Endpoint Connection resource.
     */
    public suspend
    fun getPrivateEndpointConnectionsAdtAPI(argument: GetPrivateEndpointConnectionsAdtAPIPlainArgs):
        GetPrivateEndpointConnectionsAdtAPIResult =
        getPrivateEndpointConnectionsAdtAPIResultToKotlin(getPrivateEndpointConnectionsAdtAPIPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnectionsAdtAPI].
     * @param privateEndpointConnectionName The name of the private endpoint connection associated with the Azure resource
     * @param resourceGroupName The name of the resource group that contains the service instance.
     * @param resourceName The name of the service instance.
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnectionsAdtAPI(
        privateEndpointConnectionName: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetPrivateEndpointConnectionsAdtAPIResult {
        val argument = GetPrivateEndpointConnectionsAdtAPIPlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getPrivateEndpointConnectionsAdtAPIResultToKotlin(getPrivateEndpointConnectionsAdtAPIPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnectionsAdtAPI].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityandcompliance&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionsAdtAPIPlainArgs].
     * @return The Private Endpoint Connection resource.
     */
    public suspend
    fun getPrivateEndpointConnectionsAdtAPI(argument: suspend GetPrivateEndpointConnectionsAdtAPIPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionsAdtAPIResult {
        val builder = GetPrivateEndpointConnectionsAdtAPIPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionsAdtAPIResultToKotlin(getPrivateEndpointConnectionsAdtAPIPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified private endpoint connection associated with the service.
     * Azure REST API version: 2021-03-08.
     * @param argument null
     * @return The Private Endpoint Connection resource.
     */
    public suspend
    fun getPrivateEndpointConnectionsComp(argument: GetPrivateEndpointConnectionsCompPlainArgs):
        GetPrivateEndpointConnectionsCompResult =
        getPrivateEndpointConnectionsCompResultToKotlin(getPrivateEndpointConnectionsCompPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnectionsComp].
     * @param privateEndpointConnectionName The name of the private endpoint connection associated with the Azure resource
     * @param resourceGroupName The name of the resource group that contains the service instance.
     * @param resourceName The name of the service instance.
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnectionsComp(
        privateEndpointConnectionName: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetPrivateEndpointConnectionsCompResult {
        val argument = GetPrivateEndpointConnectionsCompPlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getPrivateEndpointConnectionsCompResultToKotlin(getPrivateEndpointConnectionsCompPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnectionsComp].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityandcompliance&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionsCompPlainArgs].
     * @return The Private Endpoint Connection resource.
     */
    public suspend
    fun getPrivateEndpointConnectionsComp(argument: suspend GetPrivateEndpointConnectionsCompPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionsCompResult {
        val builder = GetPrivateEndpointConnectionsCompPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionsCompResultToKotlin(getPrivateEndpointConnectionsCompPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified private endpoint connection associated with the service.
     * Azure REST API version: 2021-03-08.
     * @param argument null
     * @return The Private Endpoint Connection resource.
     */
    public suspend
    fun getPrivateEndpointConnectionsForEDM(argument: GetPrivateEndpointConnectionsForEDMPlainArgs):
        GetPrivateEndpointConnectionsForEDMResult =
        getPrivateEndpointConnectionsForEDMResultToKotlin(getPrivateEndpointConnectionsForEDMPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnectionsForEDM].
     * @param privateEndpointConnectionName The name of the private endpoint connection associated with the Azure resource
     * @param resourceGroupName The name of the resource group that contains the service instance.
     * @param resourceName The name of the service instance.
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnectionsForEDM(
        privateEndpointConnectionName: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetPrivateEndpointConnectionsForEDMResult {
        val argument = GetPrivateEndpointConnectionsForEDMPlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getPrivateEndpointConnectionsForEDMResultToKotlin(getPrivateEndpointConnectionsForEDMPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnectionsForEDM].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityandcompliance&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionsForEDMPlainArgs].
     * @return The Private Endpoint Connection resource.
     */
    public suspend
    fun getPrivateEndpointConnectionsForEDM(argument: suspend GetPrivateEndpointConnectionsForEDMPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionsForEDMResult {
        val builder = GetPrivateEndpointConnectionsForEDMPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionsForEDMResultToKotlin(getPrivateEndpointConnectionsForEDMPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified private endpoint connection associated with the service.
     * Azure REST API version: 2021-03-08.
     * @param argument null
     * @return The Private Endpoint Connection resource.
     */
    public suspend
    fun getPrivateEndpointConnectionsForMIPPolicySync(argument: GetPrivateEndpointConnectionsForMIPPolicySyncPlainArgs):
        GetPrivateEndpointConnectionsForMIPPolicySyncResult =
        getPrivateEndpointConnectionsForMIPPolicySyncResultToKotlin(getPrivateEndpointConnectionsForMIPPolicySyncPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnectionsForMIPPolicySync].
     * @param privateEndpointConnectionName The name of the private endpoint connection associated with the Azure resource
     * @param resourceGroupName The name of the resource group that contains the service instance.
     * @param resourceName The name of the service instance.
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnectionsForMIPPolicySync(
        privateEndpointConnectionName: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetPrivateEndpointConnectionsForMIPPolicySyncResult {
        val argument = GetPrivateEndpointConnectionsForMIPPolicySyncPlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getPrivateEndpointConnectionsForMIPPolicySyncResultToKotlin(getPrivateEndpointConnectionsForMIPPolicySyncPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnectionsForMIPPolicySync].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityandcompliance&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionsForMIPPolicySyncPlainArgs].
     * @return The Private Endpoint Connection resource.
     */
    public suspend
    fun getPrivateEndpointConnectionsForMIPPolicySync(argument: suspend GetPrivateEndpointConnectionsForMIPPolicySyncPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionsForMIPPolicySyncResult {
        val builder = GetPrivateEndpointConnectionsForMIPPolicySyncPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionsForMIPPolicySyncResultToKotlin(getPrivateEndpointConnectionsForMIPPolicySyncPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified private endpoint connection associated with the service.
     * Azure REST API version: 2021-03-08.
     * @param argument null
     * @return The Private Endpoint Connection resource.
     */
    public suspend
    fun getPrivateEndpointConnectionsForSCCPowershell(argument: GetPrivateEndpointConnectionsForSCCPowershellPlainArgs):
        GetPrivateEndpointConnectionsForSCCPowershellResult =
        getPrivateEndpointConnectionsForSCCPowershellResultToKotlin(getPrivateEndpointConnectionsForSCCPowershellPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnectionsForSCCPowershell].
     * @param privateEndpointConnectionName The name of the private endpoint connection associated with the Azure resource
     * @param resourceGroupName The name of the resource group that contains the service instance.
     * @param resourceName The name of the service instance.
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnectionsForSCCPowershell(
        privateEndpointConnectionName: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetPrivateEndpointConnectionsForSCCPowershellResult {
        val argument = GetPrivateEndpointConnectionsForSCCPowershellPlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getPrivateEndpointConnectionsForSCCPowershellResultToKotlin(getPrivateEndpointConnectionsForSCCPowershellPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnectionsForSCCPowershell].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityandcompliance&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionsForSCCPowershellPlainArgs].
     * @return The Private Endpoint Connection resource.
     */
    public suspend
    fun getPrivateEndpointConnectionsForSCCPowershell(argument: suspend GetPrivateEndpointConnectionsForSCCPowershellPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionsForSCCPowershellResult {
        val builder = GetPrivateEndpointConnectionsForSCCPowershellPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionsForSCCPowershellResultToKotlin(getPrivateEndpointConnectionsForSCCPowershellPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified private endpoint connection associated with the service.
     * Azure REST API version: 2021-03-08.
     * @param argument null
     * @return The Private Endpoint Connection resource.
     */
    public suspend
    fun getPrivateEndpointConnectionsSec(argument: GetPrivateEndpointConnectionsSecPlainArgs):
        GetPrivateEndpointConnectionsSecResult =
        getPrivateEndpointConnectionsSecResultToKotlin(getPrivateEndpointConnectionsSecPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnectionsSec].
     * @param privateEndpointConnectionName The name of the private endpoint connection associated with the Azure resource
     * @param resourceGroupName The name of the resource group that contains the service instance.
     * @param resourceName The name of the service instance.
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnectionsSec(
        privateEndpointConnectionName: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetPrivateEndpointConnectionsSecResult {
        val argument = GetPrivateEndpointConnectionsSecPlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getPrivateEndpointConnectionsSecResultToKotlin(getPrivateEndpointConnectionsSecPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnectionsSec].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityandcompliance&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionsSecPlainArgs].
     * @return The Private Endpoint Connection resource.
     */
    public suspend
    fun getPrivateEndpointConnectionsSec(argument: suspend GetPrivateEndpointConnectionsSecPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionsSecResult {
        val builder = GetPrivateEndpointConnectionsSecPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionsSecResultToKotlin(getPrivateEndpointConnectionsSecPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the metadata of a privateLinkServicesForEDMUpload resource.
     * Azure REST API version: 2021-03-08.
     * @param argument null
     * @return The description of the service.
     */
    public suspend
    fun getPrivateLinkServicesForEDMUpload(argument: GetPrivateLinkServicesForEDMUploadPlainArgs):
        GetPrivateLinkServicesForEDMUploadResult =
        getPrivateLinkServicesForEDMUploadResultToKotlin(getPrivateLinkServicesForEDMUploadPlain(argument.toJava()).await())

    /**
     * @see [getPrivateLinkServicesForEDMUpload].
     * @param resourceGroupName The name of the resource group that contains the service instance.
     * @param resourceName The name of the service instance.
     * @return The description of the service.
     */
    public suspend fun getPrivateLinkServicesForEDMUpload(
        resourceGroupName: String,
        resourceName: String,
    ): GetPrivateLinkServicesForEDMUploadResult {
        val argument = GetPrivateLinkServicesForEDMUploadPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getPrivateLinkServicesForEDMUploadResultToKotlin(getPrivateLinkServicesForEDMUploadPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateLinkServicesForEDMUpload].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityandcompliance&#46;kotlin&#46;inputs&#46;GetPrivateLinkServicesForEDMUploadPlainArgs].
     * @return The description of the service.
     */
    public suspend
    fun getPrivateLinkServicesForEDMUpload(argument: suspend GetPrivateLinkServicesForEDMUploadPlainArgsBuilder.() -> Unit):
        GetPrivateLinkServicesForEDMUploadResult {
        val builder = GetPrivateLinkServicesForEDMUploadPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateLinkServicesForEDMUploadResultToKotlin(getPrivateLinkServicesForEDMUploadPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the metadata of a privateLinkServicesForM365ComplianceCenter resource.
     * Azure REST API version: 2021-03-08.
     * @param argument null
     * @return The description of the service.
     */
    public suspend
    fun getPrivateLinkServicesForM365ComplianceCenter(argument: GetPrivateLinkServicesForM365ComplianceCenterPlainArgs):
        GetPrivateLinkServicesForM365ComplianceCenterResult =
        getPrivateLinkServicesForM365ComplianceCenterResultToKotlin(getPrivateLinkServicesForM365ComplianceCenterPlain(argument.toJava()).await())

    /**
     * @see [getPrivateLinkServicesForM365ComplianceCenter].
     * @param resourceGroupName The name of the resource group that contains the service instance.
     * @param resourceName The name of the service instance.
     * @return The description of the service.
     */
    public suspend fun getPrivateLinkServicesForM365ComplianceCenter(
        resourceGroupName: String,
        resourceName: String,
    ): GetPrivateLinkServicesForM365ComplianceCenterResult {
        val argument = GetPrivateLinkServicesForM365ComplianceCenterPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getPrivateLinkServicesForM365ComplianceCenterResultToKotlin(getPrivateLinkServicesForM365ComplianceCenterPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateLinkServicesForM365ComplianceCenter].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityandcompliance&#46;kotlin&#46;inputs&#46;GetPrivateLinkServicesForM365ComplianceCenterPlainArgs].
     * @return The description of the service.
     */
    public suspend
    fun getPrivateLinkServicesForM365ComplianceCenter(argument: suspend GetPrivateLinkServicesForM365ComplianceCenterPlainArgsBuilder.() -> Unit):
        GetPrivateLinkServicesForM365ComplianceCenterResult {
        val builder = GetPrivateLinkServicesForM365ComplianceCenterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateLinkServicesForM365ComplianceCenterResultToKotlin(getPrivateLinkServicesForM365ComplianceCenterPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the metadata of a privateLinkServicesForM365SecurityCenter resource.
     * Azure REST API version: 2021-03-08.
     * @param argument null
     * @return The description of the service.
     */
    public suspend
    fun getPrivateLinkServicesForM365SecurityCenter(argument: GetPrivateLinkServicesForM365SecurityCenterPlainArgs):
        GetPrivateLinkServicesForM365SecurityCenterResult =
        getPrivateLinkServicesForM365SecurityCenterResultToKotlin(getPrivateLinkServicesForM365SecurityCenterPlain(argument.toJava()).await())

    /**
     * @see [getPrivateLinkServicesForM365SecurityCenter].
     * @param resourceGroupName The name of the resource group that contains the service instance.
     * @param resourceName The name of the service instance.
     * @return The description of the service.
     */
    public suspend fun getPrivateLinkServicesForM365SecurityCenter(
        resourceGroupName: String,
        resourceName: String,
    ): GetPrivateLinkServicesForM365SecurityCenterResult {
        val argument = GetPrivateLinkServicesForM365SecurityCenterPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getPrivateLinkServicesForM365SecurityCenterResultToKotlin(getPrivateLinkServicesForM365SecurityCenterPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateLinkServicesForM365SecurityCenter].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityandcompliance&#46;kotlin&#46;inputs&#46;GetPrivateLinkServicesForM365SecurityCenterPlainArgs].
     * @return The description of the service.
     */
    public suspend
    fun getPrivateLinkServicesForM365SecurityCenter(argument: suspend GetPrivateLinkServicesForM365SecurityCenterPlainArgsBuilder.() -> Unit):
        GetPrivateLinkServicesForM365SecurityCenterResult {
        val builder = GetPrivateLinkServicesForM365SecurityCenterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateLinkServicesForM365SecurityCenterResultToKotlin(getPrivateLinkServicesForM365SecurityCenterPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the metadata of a privateLinkServicesForMIPPolicySync resource.
     * Azure REST API version: 2021-03-08.
     * @param argument null
     * @return The description of the service.
     */
    public suspend
    fun getPrivateLinkServicesForMIPPolicySync(argument: GetPrivateLinkServicesForMIPPolicySyncPlainArgs):
        GetPrivateLinkServicesForMIPPolicySyncResult =
        getPrivateLinkServicesForMIPPolicySyncResultToKotlin(getPrivateLinkServicesForMIPPolicySyncPlain(argument.toJava()).await())

    /**
     * @see [getPrivateLinkServicesForMIPPolicySync].
     * @param resourceGroupName The name of the resource group that contains the service instance.
     * @param resourceName The name of the service instance.
     * @return The description of the service.
     */
    public suspend fun getPrivateLinkServicesForMIPPolicySync(
        resourceGroupName: String,
        resourceName: String,
    ): GetPrivateLinkServicesForMIPPolicySyncResult {
        val argument = GetPrivateLinkServicesForMIPPolicySyncPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getPrivateLinkServicesForMIPPolicySyncResultToKotlin(getPrivateLinkServicesForMIPPolicySyncPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateLinkServicesForMIPPolicySync].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityandcompliance&#46;kotlin&#46;inputs&#46;GetPrivateLinkServicesForMIPPolicySyncPlainArgs].
     * @return The description of the service.
     */
    public suspend
    fun getPrivateLinkServicesForMIPPolicySync(argument: suspend GetPrivateLinkServicesForMIPPolicySyncPlainArgsBuilder.() -> Unit):
        GetPrivateLinkServicesForMIPPolicySyncResult {
        val builder = GetPrivateLinkServicesForMIPPolicySyncPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateLinkServicesForMIPPolicySyncResultToKotlin(getPrivateLinkServicesForMIPPolicySyncPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the metadata of a privateLinkServicesForO365ManagementActivityAPI resource.
     * Azure REST API version: 2021-03-08.
     * @param argument null
     * @return The description of the service.
     */
    public suspend
    fun getPrivateLinkServicesForO365ManagementActivityAPI(argument: GetPrivateLinkServicesForO365ManagementActivityAPIPlainArgs):
        GetPrivateLinkServicesForO365ManagementActivityAPIResult =
        getPrivateLinkServicesForO365ManagementActivityAPIResultToKotlin(getPrivateLinkServicesForO365ManagementActivityAPIPlain(argument.toJava()).await())

    /**
     * @see [getPrivateLinkServicesForO365ManagementActivityAPI].
     * @param resourceGroupName The name of the resource group that contains the service instance.
     * @param resourceName The name of the service instance.
     * @return The description of the service.
     */
    public suspend fun getPrivateLinkServicesForO365ManagementActivityAPI(
        resourceGroupName: String,
        resourceName: String,
    ): GetPrivateLinkServicesForO365ManagementActivityAPIResult {
        val argument = GetPrivateLinkServicesForO365ManagementActivityAPIPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getPrivateLinkServicesForO365ManagementActivityAPIResultToKotlin(getPrivateLinkServicesForO365ManagementActivityAPIPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateLinkServicesForO365ManagementActivityAPI].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityandcompliance&#46;kotlin&#46;inputs&#46;GetPrivateLinkServicesForO365ManagementActivityAPIPlainArgs].
     * @return The description of the service.
     */
    public suspend
    fun getPrivateLinkServicesForO365ManagementActivityAPI(argument: suspend GetPrivateLinkServicesForO365ManagementActivityAPIPlainArgsBuilder.() -> Unit):
        GetPrivateLinkServicesForO365ManagementActivityAPIResult {
        val builder = GetPrivateLinkServicesForO365ManagementActivityAPIPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateLinkServicesForO365ManagementActivityAPIResultToKotlin(getPrivateLinkServicesForO365ManagementActivityAPIPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the metadata of a privateLinkServicesForSCCPowershell resource.
     * Azure REST API version: 2021-03-08.
     * @param argument null
     * @return The description of the service.
     */
    public suspend
    fun getPrivateLinkServicesForSCCPowershell(argument: GetPrivateLinkServicesForSCCPowershellPlainArgs):
        GetPrivateLinkServicesForSCCPowershellResult =
        getPrivateLinkServicesForSCCPowershellResultToKotlin(getPrivateLinkServicesForSCCPowershellPlain(argument.toJava()).await())

    /**
     * @see [getPrivateLinkServicesForSCCPowershell].
     * @param resourceGroupName The name of the resource group that contains the service instance.
     * @param resourceName The name of the service instance.
     * @return The description of the service.
     */
    public suspend fun getPrivateLinkServicesForSCCPowershell(
        resourceGroupName: String,
        resourceName: String,
    ): GetPrivateLinkServicesForSCCPowershellResult {
        val argument = GetPrivateLinkServicesForSCCPowershellPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getPrivateLinkServicesForSCCPowershellResultToKotlin(getPrivateLinkServicesForSCCPowershellPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateLinkServicesForSCCPowershell].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityandcompliance&#46;kotlin&#46;inputs&#46;GetPrivateLinkServicesForSCCPowershellPlainArgs].
     * @return The description of the service.
     */
    public suspend
    fun getPrivateLinkServicesForSCCPowershell(argument: suspend GetPrivateLinkServicesForSCCPowershellPlainArgsBuilder.() -> Unit):
        GetPrivateLinkServicesForSCCPowershellResult {
        val builder = GetPrivateLinkServicesForSCCPowershellPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateLinkServicesForSCCPowershellResultToKotlin(getPrivateLinkServicesForSCCPowershellPlain(builtArgument.toJava()).await())
    }
}
