@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityandcompliance.kotlin.inputs

import com.pulumi.azurenative.securityandcompliance.inputs.GetPrivateLinkServicesForMIPPolicySyncPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group that contains the service instance.
 * @property resourceName The name of the service instance.
 */
public data class GetPrivateLinkServicesForMIPPolicySyncPlainArgs(
    public val resourceGroupName: String,
    public val resourceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityandcompliance.inputs.GetPrivateLinkServicesForMIPPolicySyncPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityandcompliance.inputs.GetPrivateLinkServicesForMIPPolicySyncPlainArgs =
        com.pulumi.azurenative.securityandcompliance.inputs.GetPrivateLinkServicesForMIPPolicySyncPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrivateLinkServicesForMIPPolicySyncPlainArgs].
 */
@PulumiTagMarker
public class GetPrivateLinkServicesForMIPPolicySyncPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value The name of the resource group that contains the service instance.
     */
    @JvmName("gsvgfkbgfcnoqspq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the service instance.
     */
    @JvmName("cyxjptrlwfsxguwu")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetPrivateLinkServicesForMIPPolicySyncPlainArgs =
        GetPrivateLinkServicesForMIPPolicySyncPlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
        )
}
