@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securitydevops.kotlin.inputs

import com.pulumi.azurenative.securitydevops.inputs.AzureDevOpsConnectorPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property authorization
 * @property orgs Gets or sets org onboarding information.
 */
public data class AzureDevOpsConnectorPropertiesArgs(
    public val authorization: Output<AuthorizationInfoArgs>? = null,
    public val orgs: Output<List<AzureDevOpsOrgMetadataArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.securitydevops.inputs.AzureDevOpsConnectorPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.securitydevops.inputs.AzureDevOpsConnectorPropertiesArgs =
        com.pulumi.azurenative.securitydevops.inputs.AzureDevOpsConnectorPropertiesArgs.builder()
            .authorization(authorization?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .orgs(
                orgs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AzureDevOpsConnectorPropertiesArgs].
 */
@PulumiTagMarker
public class AzureDevOpsConnectorPropertiesArgsBuilder internal constructor() {
    private var authorization: Output<AuthorizationInfoArgs>? = null

    private var orgs: Output<List<AzureDevOpsOrgMetadataArgs>>? = null

    /**
     * @param value
     */
    @JvmName("ogsrswsbdllnbpsg")
    public suspend fun authorization(`value`: Output<AuthorizationInfoArgs>) {
        this.authorization = value
    }

    /**
     * @param value Gets or sets org onboarding information.
     */
    @JvmName("xtraxsxrheecyotw")
    public suspend fun orgs(`value`: Output<List<AzureDevOpsOrgMetadataArgs>>) {
        this.orgs = value
    }

    @JvmName("gcwaxvnjhycejqvc")
    public suspend fun orgs(vararg values: Output<AzureDevOpsOrgMetadataArgs>) {
        this.orgs = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets org onboarding information.
     */
    @JvmName("lhxqjltjhwmcykic")
    public suspend fun orgs(values: List<Output<AzureDevOpsOrgMetadataArgs>>) {
        this.orgs = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("chwgcbnfusuqeadl")
    public suspend fun authorization(`value`: AuthorizationInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorization = mapped
    }

    /**
     * @param argument
     */
    @JvmName("wclgdeqahasxfves")
    public suspend fun authorization(argument: suspend AuthorizationInfoArgsBuilder.() -> Unit) {
        val toBeMapped = AuthorizationInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.authorization = mapped
    }

    /**
     * @param value Gets or sets org onboarding information.
     */
    @JvmName("hwwgqkyamylvqtyf")
    public suspend fun orgs(`value`: List<AzureDevOpsOrgMetadataArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.orgs = mapped
    }

    /**
     * @param argument Gets or sets org onboarding information.
     */
    @JvmName("fxyyajtknlofdjyh")
    public suspend fun orgs(argument: List<suspend AzureDevOpsOrgMetadataArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AzureDevOpsOrgMetadataArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.orgs = mapped
    }

    /**
     * @param argument Gets or sets org onboarding information.
     */
    @JvmName("rspxqiypnpaprklu")
    public suspend fun orgs(vararg argument: suspend AzureDevOpsOrgMetadataArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AzureDevOpsOrgMetadataArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.orgs = mapped
    }

    /**
     * @param argument Gets or sets org onboarding information.
     */
    @JvmName("lcsxyltkmthgvqyg")
    public suspend fun orgs(argument: suspend AzureDevOpsOrgMetadataArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AzureDevOpsOrgMetadataArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.orgs = mapped
    }

    /**
     * @param values Gets or sets org onboarding information.
     */
    @JvmName("wkooxjruevrjenya")
    public suspend fun orgs(vararg values: AzureDevOpsOrgMetadataArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.orgs = mapped
    }

    internal fun build(): AzureDevOpsConnectorPropertiesArgs = AzureDevOpsConnectorPropertiesArgs(
        authorization = authorization,
        orgs = orgs,
    )
}
