@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securitydevops.kotlin.inputs

import com.pulumi.azurenative.securitydevops.inputs.GetAzureDevOpsConnectorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property azureDevOpsConnectorName Name of the AzureDevOps Connector.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetAzureDevOpsConnectorPlainArgs(
    public val azureDevOpsConnectorName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.securitydevops.inputs.GetAzureDevOpsConnectorPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.securitydevops.inputs.GetAzureDevOpsConnectorPlainArgs =
        com.pulumi.azurenative.securitydevops.inputs.GetAzureDevOpsConnectorPlainArgs.builder()
            .azureDevOpsConnectorName(azureDevOpsConnectorName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAzureDevOpsConnectorPlainArgs].
 */
@PulumiTagMarker
public class GetAzureDevOpsConnectorPlainArgsBuilder internal constructor() {
    private var azureDevOpsConnectorName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the AzureDevOps Connector.
     */
    @JvmName("wcuuunmfprevkwyp")
    public suspend fun azureDevOpsConnectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.azureDevOpsConnectorName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sjwbtkmvsvfvtucn")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAzureDevOpsConnectorPlainArgs = GetAzureDevOpsConnectorPlainArgs(
        azureDevOpsConnectorName = azureDevOpsConnectorName ?: throw
            PulumiNullFieldException("azureDevOpsConnectorName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
