@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securitydevops.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Org onboarding info.
 * @property autoDiscovery
 * @property name Gets or sets name of the AzureDevOps Org.
 * @property projects
 */
public data class AzureDevOpsOrgMetadataResponse(
    public val autoDiscovery: String? = null,
    public val name: String? = null,
    public val projects: List<AzureDevOpsProjectMetadataResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securitydevops.outputs.AzureDevOpsOrgMetadataResponse):
            AzureDevOpsOrgMetadataResponse = AzureDevOpsOrgMetadataResponse(
            autoDiscovery = javaType.autoDiscovery().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            projects = javaType.projects().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securitydevops.kotlin.outputs.AzureDevOpsProjectMetadataResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
