@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.ActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Action for alert rule.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-01-01.
 * Other available API versions: 2021-03-01-preview, 2023-06-01-preview, 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-11-01, 2023-12-01-preview.
 * ## Example Usage
 * ### Creates or updates an action of alert rule.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var action = new AzureNative.SecurityInsights.Action("action", new()
 *     {
 *         ActionId = "912bec42-cb66-4c03-ac63-1761b6898c3e",
 *         LogicAppResourceId = "/subscriptions/d0cfe6b2-9ac0-4464-9919-dccaee2e48c0/resourceGroups/myRg/providers/Microsoft.Logic/workflows/MyAlerts",
 *         ResourceGroupName = "myRg",
 *         RuleId = "73e01a99-5cd7-4139-a149-9f2736ff2ab5",
 *         TriggerUri = "https://prod-31.northcentralus.logic.azure.com:443/workflows/cd3765391efd48549fd7681ded1d48d7/triggers/manual/paths/invoke?api-version=2016-10-01&sp=%2Ftriggers%2Fmanual%2Frun&sv=1.0&sig=signature",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewAction(ctx, "action", &securityinsights.ActionArgs{
 * 			ActionId:           pulumi.String("912bec42-cb66-4c03-ac63-1761b6898c3e"),
 * 			LogicAppResourceId: pulumi.String("/subscriptions/d0cfe6b2-9ac0-4464-9919-dccaee2e48c0/resourceGroups/myRg/providers/Microsoft.Logic/workflows/MyAlerts"),
 * 			ResourceGroupName:  pulumi.String("myRg"),
 * 			RuleId:             pulumi.String("73e01a99-5cd7-4139-a149-9f2736ff2ab5"),
 * 			TriggerUri:         pulumi.String("https://prod-31.northcentralus.logic.azure.com:443/workflows/cd3765391efd48549fd7681ded1d48d7/triggers/manual/paths/invoke?api-version=2016-10-01&sp=%2Ftriggers%2Fmanual%2Frun&sv=1.0&sig=signature"),
 * 			WorkspaceName:      pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.Action;
 * import com.pulumi.azurenative.securityinsights.ActionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var action = new Action("action", ActionArgs.builder()
 *             .actionId("912bec42-cb66-4c03-ac63-1761b6898c3e")
 *             .logicAppResourceId("/subscriptions/d0cfe6b2-9ac0-4464-9919-dccaee2e48c0/resourceGroups/myRg/providers/Microsoft.Logic/workflows/MyAlerts")
 *             .resourceGroupName("myRg")
 *             .ruleId("73e01a99-5cd7-4139-a149-9f2736ff2ab5")
 *             .triggerUri("https://prod-31.northcentralus.logic.azure.com:443/workflows/cd3765391efd48549fd7681ded1d48d7/triggers/manual/paths/invoke?api-version=2016-10-01&sp=%2Ftriggers%2Fmanual%2Frun&sv=1.0&sig=signature")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:Action 912bec42-cb66-4c03-ac63-1761b6898c3e /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/alertRules/{ruleId}/actions/{actionId}
 * ```
 * @property actionId Action ID
 * @property logicAppResourceId Logic App Resource Id, /subscriptions/{my-subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-workflow-id}.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property ruleId Alert rule ID
 * @property triggerUri Logic App Callback URL for this specific workflow.
 * @property workspaceName The name of the workspace.
 */
public data class ActionArgs(
    public val actionId: Output<String>? = null,
    public val logicAppResourceId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val ruleId: Output<String>? = null,
    public val triggerUri: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.ActionArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.ActionArgs =
        com.pulumi.azurenative.securityinsights.ActionArgs.builder()
            .actionId(actionId?.applyValue({ args0 -> args0 }))
            .logicAppResourceId(logicAppResourceId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .ruleId(ruleId?.applyValue({ args0 -> args0 }))
            .triggerUri(triggerUri?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ActionArgs].
 */
@PulumiTagMarker
public class ActionArgsBuilder internal constructor() {
    private var actionId: Output<String>? = null

    private var logicAppResourceId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var ruleId: Output<String>? = null

    private var triggerUri: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Action ID
     */
    @JvmName("neopktqubudtivhk")
    public suspend fun actionId(`value`: Output<String>) {
        this.actionId = value
    }

    /**
     * @param value Logic App Resource Id, /subscriptions/{my-subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-workflow-id}.
     */
    @JvmName("qamdiawudnqijjfv")
    public suspend fun logicAppResourceId(`value`: Output<String>) {
        this.logicAppResourceId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nwxeejbsyxobykmf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Alert rule ID
     */
    @JvmName("kbynqrktlkqrrqse")
    public suspend fun ruleId(`value`: Output<String>) {
        this.ruleId = value
    }

    /**
     * @param value Logic App Callback URL for this specific workflow.
     */
    @JvmName("jhennsiaoaedkxve")
    public suspend fun triggerUri(`value`: Output<String>) {
        this.triggerUri = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("duhrcjubuoenvtwc")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Action ID
     */
    @JvmName("crrbbaxydabqfhjv")
    public suspend fun actionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionId = mapped
    }

    /**
     * @param value Logic App Resource Id, /subscriptions/{my-subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-workflow-id}.
     */
    @JvmName("bdvogfeblicyeydw")
    public suspend fun logicAppResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logicAppResourceId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nnmpyhqebqhqmfga")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Alert rule ID
     */
    @JvmName("ywmyvbqxycxunshk")
    public suspend fun ruleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleId = mapped
    }

    /**
     * @param value Logic App Callback URL for this specific workflow.
     */
    @JvmName("tbqsemgkutmyrkdc")
    public suspend fun triggerUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.triggerUri = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("mfudduoebsowsimd")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): ActionArgs = ActionArgs(
        actionId = actionId,
        logicAppResourceId = logicAppResourceId,
        resourceGroupName = resourceGroupName,
        ruleId = ruleId,
        triggerUri = triggerUri,
        workspaceName = workspaceName,
    )
}
