@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.kotlin.outputs.ActivityEntityQueriesPropertiesResponseQueryDefinitions
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.securityinsights.kotlin.outputs.ActivityEntityQueriesPropertiesResponseQueryDefinitions.Companion.toKotlin as activityEntityQueriesPropertiesResponseQueryDefinitionsToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ActivityCustomEntityQuery].
 */
@PulumiTagMarker
public class ActivityCustomEntityQueryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ActivityCustomEntityQueryArgs = ActivityCustomEntityQueryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ActivityCustomEntityQueryArgsBuilder.() -> Unit) {
        val builder = ActivityCustomEntityQueryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ActivityCustomEntityQuery {
        val builtJavaResource =
            com.pulumi.azurenative.securityinsights.ActivityCustomEntityQuery(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ActivityCustomEntityQuery(builtJavaResource)
    }
}

/**
 * Represents Activity entity query.
 * Azure REST API version: 2023-06-01-preview. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * ## Example Usage
 * ### Creates or updates an Activity entity query.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var activityCustomEntityQuery = new AzureNative.SecurityInsights.ActivityCustomEntityQuery("activityCustomEntityQuery", new()
 *     {
 *         Content = "On '{{Computer}}' the account '{{TargetAccount}}' was deleted by '{{AddedBy}}'",
 *         Description = "Account deleted on host",
 *         Enabled = true,
 *         EntitiesFilter =
 *         {
 *             { "Host_OsFamily", new[]
 *             {
 *                 "Windows",
 *             } },
 *         },
 *         EntityQueryId = "07da3cc8-c8ad-4710-a44e-334cdcb7882b",
 *         InputEntityType = "Host",
 *         Kind = "Activity",
 *         QueryDefinitions = new AzureNative.SecurityInsights.Inputs.ActivityEntityQueriesPropertiesQueryDefinitionsArgs
 *         {
 *             Query = @"let GetAccountActions = (v_Host_Name:string, v_Host_NTDomain:string, v_Host_DnsDomain:string, v_Host_AzureID:string, v_Host_OMSAgentID:string){
 * SecurityEvent
 * | where EventID in (4725, 4726, 4767, 4720, 4722, 4723, 4724)
 * // parsing for Host to handle variety of conventions coming from data
 * | extend Host_HostName = case(
 * Computer has '@', tostring(split(Computer, '@')[0]),
 * Computer has '\\', tostring(split(Computer, '\\')[1]),
 * Computer has '.', tostring(split(Computer, '.')[0]),
 * Computer
 * )
 * | extend Host_NTDomain = case(
 * Computer has '\\', tostring(split(Computer, '\\')[0]),
 * Computer has '.', tostring(split(Computer, '.')[-2]),
 * Computer
 * )
 * | extend Host_DnsDomain = case(
 * Computer has '\\', tostring(split(Computer, '\\')[0]),
 * Computer has '.', strcat_array(array_slice(split(Computer,'.'),-2,-1),'.'),
 * Computer
 * )
 * | where (Host_HostName =~ v_Host_Name and Host_NTDomain =~ v_Host_NTDomain)
 * or (Host_HostName =~ v_Host_Name and Host_DnsDomain =~ v_Host_DnsDomain)
 * or v_Host_AzureID =~ _ResourceId
 * or v_Host_OMSAgentID == SourceComputerId
 * | project TimeGenerated, EventID, Activity, Computer, TargetAccount, TargetUserName, TargetDomainName, TargetSid, SubjectUserName, SubjectUserSid, _ResourceId, SourceComputerId
 * | extend AddedBy = SubjectUserName
 * // Future support for Activities
 * | extend timestamp = TimeGenerated, HostCustomEntity = Computer, AccountCustomEntity = TargetAccount
 * };
 * GetAccountActions('{{Host_HostName}}', '{{Host_NTDomain}}', '{{Host_DnsDomain}}', '{{Host_AzureID}}', '{{Host_OMSAgentID}}')
 * | where EventID == 4726 ",
 *         },
 *         RequiredInputFieldsSets = new[]
 *         {
 *             new[]
 *             {
 *                 "Host_HostName",
 *                 "Host_NTDomain",
 *             },
 *             new[]
 *             {
 *                 "Host_HostName",
 *                 "Host_DnsDomain",
 *             },
 *             new[]
 *             {
 *                 "Host_AzureID",
 *             },
 *             new[]
 *             {
 *                 "Host_OMSAgentID",
 *             },
 *         },
 *         ResourceGroupName = "myRg",
 *         Title = "An account was deleted on this host",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewActivityCustomEntityQuery(ctx, "activityCustomEntityQuery", &securityinsights.ActivityCustomEntityQueryArgs{
 * 			Content:     pulumi.String("On '{{Computer}}' the account '{{TargetAccount}}' was deleted by '{{AddedBy}}'"),
 * 			Description: pulumi.String("Account deleted on host"),
 * 			Enabled:     pulumi.Bool(true),
 * 			EntitiesFilter: pulumi.StringArrayMap{
 * 				"Host_OsFamily": pulumi.StringArray{
 * 					pulumi.String("Windows"),
 * 				},
 * 			},
 * 			EntityQueryId:   pulumi.String("07da3cc8-c8ad-4710-a44e-334cdcb7882b"),
 * 			InputEntityType: pulumi.String("Host"),
 * 			Kind:            pulumi.String("Activity"),
 * 			QueryDefinitions: &securityinsights.ActivityEntityQueriesPropertiesQueryDefinitionsArgs{
 * 				Query: pulumi.String(`let GetAccountActions = (v_Host_Name:string, v_Host_NTDomain:string, v_Host_DnsDomain:string, v_Host_AzureID:string, v_Host_OMSAgentID:string){
 * SecurityEvent
 * | where EventID in (4725, 4726, 4767, 4720, 4722, 4723, 4724)
 * // parsing for Host to handle variety of conventions coming from data
 * | extend Host_HostName = case(
 * Computer has '@', tostring(split(Computer, '@')[0]),
 * Computer has '\\', tostring(split(Computer, '\\')[1]),
 * Computer has '.', tostring(split(Computer, '.')[0]),
 * Computer
 * )
 * | extend Host_NTDomain = case(
 * Computer has '\\', tostring(split(Computer, '\\')[0]),
 * Computer has '.', tostring(split(Computer, '.')[-2]),
 * Computer
 * )
 * | extend Host_DnsDomain = case(
 * Computer has '\\', tostring(split(Computer, '\\')[0]),
 * Computer has '.', strcat_array(array_slice(split(Computer,'.'),-2,-1),'.'),
 * Computer
 * )
 * | where (Host_HostName =~ v_Host_Name and Host_NTDomain =~ v_Host_NTDomain)
 * or (Host_HostName =~ v_Host_Name and Host_DnsDomain =~ v_Host_DnsDomain)
 * or v_Host_AzureID =~ _ResourceId
 * or v_Host_OMSAgentID == SourceComputerId
 * | project TimeGenerated, EventID, Activity, Computer, TargetAccount, TargetUserName, TargetDomainName, TargetSid, SubjectUserName, SubjectUserSid, _ResourceId, SourceComputerId
 * | extend AddedBy = SubjectUserName
 * // Future support for Activities
 * | extend timestamp = TimeGenerated, HostCustomEntity = Computer, AccountCustomEntity = TargetAccount
 * };
 * GetAccountActions('{{Host_HostName}}', '{{Host_NTDomain}}', '{{Host_DnsDomain}}', '{{Host_AzureID}}', '{{Host_OMSAgentID}}')
 * | where EventID == 4726 `),
 * 			},
 * 			RequiredInputFieldsSets: pulumi.StringArrayArray{
 * 				pulumi.StringArray{
 * 					pulumi.String("Host_HostName"),
 * 					pulumi.String("Host_NTDomain"),
 * 				},
 * 				pulumi.StringArray{
 * 					pulumi.String("Host_HostName"),
 * 					pulumi.String("Host_DnsDomain"),
 * 				},
 * 				pulumi.StringArray{
 * 					pulumi.String("Host_AzureID"),
 * 				},
 * 				pulumi.StringArray{
 * 					pulumi.String("Host_OMSAgentID"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			Title:             pulumi.String("An account was deleted on this host"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.ActivityCustomEntityQuery;
 * import com.pulumi.azurenative.securityinsights.ActivityCustomEntityQueryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var activityCustomEntityQuery = new ActivityCustomEntityQuery("activityCustomEntityQuery", ActivityCustomEntityQueryArgs.builder()
 *             .content("On '{{Computer}}' the account '{{TargetAccount}}' was deleted by '{{AddedBy}}'")
 *             .description("Account deleted on host")
 *             .enabled(true)
 *             .entitiesFilter(Map.of("Host_OsFamily", "Windows"))
 *             .entityQueryId("07da3cc8-c8ad-4710-a44e-334cdcb7882b")
 *             .inputEntityType("Host")
 *             .kind("Activity")
 *             .queryDefinitions(Map.of("query", """
 * let GetAccountActions = (v_Host_Name:string, v_Host_NTDomain:string, v_Host_DnsDomain:string, v_Host_AzureID:string, v_Host_OMSAgentID:string){
 * SecurityEvent
 * | where EventID in (4725, 4726, 4767, 4720, 4722, 4723, 4724)
 * // parsing for Host to handle variety of conventions coming from data
 * | extend Host_HostName = case(
 * Computer has '@', tostring(split(Computer, '@')[0]),
 * Computer has '\\', tostring(split(Computer, '\\')[1]),
 * Computer has '.', tostring(split(Computer, '.')[0]),
 * Computer
 * )
 * | extend Host_NTDomain = case(
 * Computer has '\\', tostring(split(Computer, '\\')[0]),
 * Computer has '.', tostring(split(Computer, '.')[-2]),
 * Computer
 * )
 * | extend Host_DnsDomain = case(
 * Computer has '\\', tostring(split(Computer, '\\')[0]),
 * Computer has '.', strcat_array(array_slice(split(Computer,'.'),-2,-1),'.'),
 * Computer
 * )
 * | where (Host_HostName =~ v_Host_Name and Host_NTDomain =~ v_Host_NTDomain)
 * or (Host_HostName =~ v_Host_Name and Host_DnsDomain =~ v_Host_DnsDomain)
 * or v_Host_AzureID =~ _ResourceId
 * or v_Host_OMSAgentID == SourceComputerId
 * | project TimeGenerated, EventID, Activity, Computer, TargetAccount, TargetUserName, TargetDomainName, TargetSid, SubjectUserName, SubjectUserSid, _ResourceId, SourceComputerId
 * | extend AddedBy = SubjectUserName
 * // Future support for Activities
 * | extend timestamp = TimeGenerated, HostCustomEntity = Computer, AccountCustomEntity = TargetAccount
 * };
 * GetAccountActions('{{Host_HostName}}', '{{Host_NTDomain}}', '{{Host_DnsDomain}}', '{{Host_AzureID}}', '{{Host_OMSAgentID}}')
 * | where EventID == 4726             """))
 *             .requiredInputFieldsSets(
 *                     "Host_HostName",
 *                     "Host_NTDomain",
 *                     "Host_HostName",
 *                     "Host_DnsDomain",
 *                 "Host_AzureID",
 *                 "Host_OMSAgentID")
 *             .resourceGroupName("myRg")
 *             .title("An account was deleted on this host")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:ActivityCustomEntityQuery 07da3cc8-c8ad-4710-a44e-334cdcb7882b /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entityQueries/{entityQueryId}
 * ```
 */
public class ActivityCustomEntityQuery internal constructor(
    override val javaResource: com.pulumi.azurenative.securityinsights.ActivityCustomEntityQuery,
) : KotlinCustomResource(javaResource, ActivityCustomEntityQueryMapper) {
    /**
     * The entity query content to display in timeline
     */
    public val content: Output<String>?
        get() = javaResource.content().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The time the activity was created
     */
    public val createdTimeUtc: Output<String>
        get() = javaResource.createdTimeUtc().applyValue({ args0 -> args0 })

    /**
     * The entity query description
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Determines whether this activity is enabled or disabled.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The query applied only to entities matching to all filters
     */
    public val entitiesFilter: Output<Map<String, List<String>>>?
        get() = javaResource.entitiesFilter().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(
                        args0.value.map({ args0 ->
                            args0
                        }),
                    )
                }).toMap()
            }).orElse(null)
        })

    /**
     * Etag of the azure resource
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the query's source entity
     */
    public val inputEntityType: Output<String>?
        get() = javaResource.inputEntityType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The kind of the entity query
     * Expected value is 'Activity'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * The last time the activity was updated
     */
    public val lastModifiedTimeUtc: Output<String>
        get() = javaResource.lastModifiedTimeUtc().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The Activity query definitions
     */
    public val queryDefinitions: Output<ActivityEntityQueriesPropertiesResponseQueryDefinitions>?
        get() = javaResource.queryDefinitions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    activityEntityQueriesPropertiesResponseQueryDefinitionsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * List of the fields of the source entity that are required to run the query
     */
    public val requiredInputFieldsSets: Output<List<List<String>>>?
        get() = javaResource.requiredInputFieldsSets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.map({ args0 -> args0 }) })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The template id this activity was created from
     */
    public val templateName: Output<String>?
        get() = javaResource.templateName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The entity query title
     */
    public val title: Output<String>?
        get() = javaResource.title().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ActivityCustomEntityQueryMapper : ResourceMapper<ActivityCustomEntityQuery> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.securityinsights.ActivityCustomEntityQuery::class == javaResource::class

    override fun map(javaResource: Resource): ActivityCustomEntityQuery =
        ActivityCustomEntityQuery(
            javaResource as
                com.pulumi.azurenative.securityinsights.ActivityCustomEntityQuery,
        )
}

/**
 * @see [ActivityCustomEntityQuery].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ActivityCustomEntityQuery].
 */
public suspend fun activityCustomEntityQuery(
    name: String,
    block: suspend ActivityCustomEntityQueryResourceBuilder.() -> Unit,
): ActivityCustomEntityQuery {
    val builder = ActivityCustomEntityQueryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ActivityCustomEntityQuery].
 * @param name The _unique_ name of the resulting resource.
 */
public fun activityCustomEntityQuery(name: String): ActivityCustomEntityQuery {
    val builder = ActivityCustomEntityQueryResourceBuilder()
    builder.name(name)
    return builder.build()
}
