@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.BookmarkArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.IncidentInfoArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.IncidentInfoArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.UserInfoArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.UserInfoArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Represents a bookmark in Azure Security Insights.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-01-01.
 * Other available API versions: 2019-01-01-preview, 2023-06-01-preview, 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-11-01, 2023-12-01-preview.
 * ## Example Usage
 * ### Creates or updates a bookmark.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var bookmark = new AzureNative.SecurityInsights.Bookmark("bookmark", new()
 *     {
 *         BookmarkId = "73e01a99-5cd7-4139-a149-9f2736ff2ab5",
 *         Created = "2019-01-01T13:15:30Z",
 *         CreatedBy = new AzureNative.SecurityInsights.Inputs.UserInfoArgs
 *         {
 *             ObjectId = "2046feea-040d-4a46-9e2b-91c2941bfa70",
 *         },
 *         DisplayName = "My bookmark",
 *         Labels = new[]
 *         {
 *             "Tag1",
 *             "Tag2",
 *         },
 *         Notes = "Found a suspicious activity",
 *         Query = "SecurityEvent | where TimeGenerated > ago(1d) and TimeGenerated < ago(2d)",
 *         QueryResult = "Security Event query result",
 *         ResourceGroupName = "myRg",
 *         Updated = "2019-01-01T13:15:30Z",
 *         UpdatedBy = new AzureNative.SecurityInsights.Inputs.UserInfoArgs
 *         {
 *             ObjectId = "2046feea-040d-4a46-9e2b-91c2941bfa70",
 *         },
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewBookmark(ctx, "bookmark", &securityinsights.BookmarkArgs{
 * 			BookmarkId: pulumi.String("73e01a99-5cd7-4139-a149-9f2736ff2ab5"),
 * 			Created:    pulumi.String("2019-01-01T13:15:30Z"),
 * 			CreatedBy: &securityinsights.UserInfoArgs{
 * 				ObjectId: pulumi.String("2046feea-040d-4a46-9e2b-91c2941bfa70"),
 * 			},
 * 			DisplayName: pulumi.String("My bookmark"),
 * 			Labels: pulumi.StringArray{
 * 				pulumi.String("Tag1"),
 * 				pulumi.String("Tag2"),
 * 			},
 * 			Notes:             pulumi.String("Found a suspicious activity"),
 * 			Query:             pulumi.String("SecurityEvent | where TimeGenerated > ago(1d) and TimeGenerated < ago(2d)"),
 * 			QueryResult:       pulumi.String("Security Event query result"),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			Updated:           pulumi.String("2019-01-01T13:15:30Z"),
 * 			UpdatedBy: &securityinsights.UserInfoArgs{
 * 				ObjectId: pulumi.String("2046feea-040d-4a46-9e2b-91c2941bfa70"),
 * 			},
 * 			WorkspaceName: pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.Bookmark;
 * import com.pulumi.azurenative.securityinsights.BookmarkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bookmark = new Bookmark("bookmark", BookmarkArgs.builder()
 *             .bookmarkId("73e01a99-5cd7-4139-a149-9f2736ff2ab5")
 *             .created("2019-01-01T13:15:30Z")
 *             .createdBy(Map.of("objectId", "2046feea-040d-4a46-9e2b-91c2941bfa70"))
 *             .displayName("My bookmark")
 *             .labels(
 *                 "Tag1",
 *                 "Tag2")
 *             .notes("Found a suspicious activity")
 *             .query("SecurityEvent | where TimeGenerated > ago(1d) and TimeGenerated < ago(2d)")
 *             .queryResult("Security Event query result")
 *             .resourceGroupName("myRg")
 *             .updated("2019-01-01T13:15:30Z")
 *             .updatedBy(Map.of("objectId", "2046feea-040d-4a46-9e2b-91c2941bfa70"))
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:Bookmark 73e01a99-5cd7-4139-a149-9f2736ff2ab5 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/bookmarks/{bookmarkId}
 * ```
 * @property bookmarkId Bookmark ID
 * @property created The time the bookmark was created
 * @property createdBy Describes a user that created the bookmark
 * @property displayName The display name of the bookmark
 * @property eventTime The bookmark event time
 * @property incidentInfo Describes an incident that relates to bookmark
 * @property labels List of labels relevant to this bookmark
 * @property notes The notes of the bookmark
 * @property query The query of the bookmark.
 * @property queryEndTime The end time for the query
 * @property queryResult The query result of the bookmark.
 * @property queryStartTime The start time for the query
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property updated The last time the bookmark was updated
 * @property updatedBy Describes a user that updated the bookmark
 * @property workspaceName The name of the workspace.
 */
public data class BookmarkArgs(
    public val bookmarkId: Output<String>? = null,
    public val created: Output<String>? = null,
    public val createdBy: Output<UserInfoArgs>? = null,
    public val displayName: Output<String>? = null,
    public val eventTime: Output<String>? = null,
    public val incidentInfo: Output<IncidentInfoArgs>? = null,
    public val labels: Output<List<String>>? = null,
    public val notes: Output<String>? = null,
    public val query: Output<String>? = null,
    public val queryEndTime: Output<String>? = null,
    public val queryResult: Output<String>? = null,
    public val queryStartTime: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val updated: Output<String>? = null,
    public val updatedBy: Output<UserInfoArgs>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.BookmarkArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.BookmarkArgs =
        com.pulumi.azurenative.securityinsights.BookmarkArgs.builder()
            .bookmarkId(bookmarkId?.applyValue({ args0 -> args0 }))
            .created(created?.applyValue({ args0 -> args0 }))
            .createdBy(createdBy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .eventTime(eventTime?.applyValue({ args0 -> args0 }))
            .incidentInfo(incidentInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .labels(labels?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .notes(notes?.applyValue({ args0 -> args0 }))
            .query(query?.applyValue({ args0 -> args0 }))
            .queryEndTime(queryEndTime?.applyValue({ args0 -> args0 }))
            .queryResult(queryResult?.applyValue({ args0 -> args0 }))
            .queryStartTime(queryStartTime?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .updated(updated?.applyValue({ args0 -> args0 }))
            .updatedBy(updatedBy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BookmarkArgs].
 */
@PulumiTagMarker
public class BookmarkArgsBuilder internal constructor() {
    private var bookmarkId: Output<String>? = null

    private var created: Output<String>? = null

    private var createdBy: Output<UserInfoArgs>? = null

    private var displayName: Output<String>? = null

    private var eventTime: Output<String>? = null

    private var incidentInfo: Output<IncidentInfoArgs>? = null

    private var labels: Output<List<String>>? = null

    private var notes: Output<String>? = null

    private var query: Output<String>? = null

    private var queryEndTime: Output<String>? = null

    private var queryResult: Output<String>? = null

    private var queryStartTime: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var updated: Output<String>? = null

    private var updatedBy: Output<UserInfoArgs>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Bookmark ID
     */
    @JvmName("oefalxudcvnppqsl")
    public suspend fun bookmarkId(`value`: Output<String>) {
        this.bookmarkId = value
    }

    /**
     * @param value The time the bookmark was created
     */
    @JvmName("yffnjmxamkofxoyh")
    public suspend fun created(`value`: Output<String>) {
        this.created = value
    }

    /**
     * @param value Describes a user that created the bookmark
     */
    @JvmName("wgqxflhanbkumutv")
    public suspend fun createdBy(`value`: Output<UserInfoArgs>) {
        this.createdBy = value
    }

    /**
     * @param value The display name of the bookmark
     */
    @JvmName("okqcqqjqyyxeicpe")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The bookmark event time
     */
    @JvmName("edqnhqdqpkkcfbnq")
    public suspend fun eventTime(`value`: Output<String>) {
        this.eventTime = value
    }

    /**
     * @param value Describes an incident that relates to bookmark
     */
    @JvmName("brcdfrmldafxisvx")
    public suspend fun incidentInfo(`value`: Output<IncidentInfoArgs>) {
        this.incidentInfo = value
    }

    /**
     * @param value List of labels relevant to this bookmark
     */
    @JvmName("bmimybilmbfckdyh")
    public suspend fun labels(`value`: Output<List<String>>) {
        this.labels = value
    }

    @JvmName("hbxaihkskkkbyryk")
    public suspend fun labels(vararg values: Output<String>) {
        this.labels = Output.all(values.asList())
    }

    /**
     * @param values List of labels relevant to this bookmark
     */
    @JvmName("yveadsgsxsioqgpm")
    public suspend fun labels(values: List<Output<String>>) {
        this.labels = Output.all(values)
    }

    /**
     * @param value The notes of the bookmark
     */
    @JvmName("iucxduvpomjqtxwr")
    public suspend fun notes(`value`: Output<String>) {
        this.notes = value
    }

    /**
     * @param value The query of the bookmark.
     */
    @JvmName("olpioxaceoqqjynf")
    public suspend fun query(`value`: Output<String>) {
        this.query = value
    }

    /**
     * @param value The end time for the query
     */
    @JvmName("spjkbcpfliptsbkj")
    public suspend fun queryEndTime(`value`: Output<String>) {
        this.queryEndTime = value
    }

    /**
     * @param value The query result of the bookmark.
     */
    @JvmName("urchvumytbwnnlrb")
    public suspend fun queryResult(`value`: Output<String>) {
        this.queryResult = value
    }

    /**
     * @param value The start time for the query
     */
    @JvmName("dephjcdhqhircjfd")
    public suspend fun queryStartTime(`value`: Output<String>) {
        this.queryStartTime = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tmnldopfcuyhsevg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The last time the bookmark was updated
     */
    @JvmName("xqbynujotqankemk")
    public suspend fun updated(`value`: Output<String>) {
        this.updated = value
    }

    /**
     * @param value Describes a user that updated the bookmark
     */
    @JvmName("gmphdhreorparnnc")
    public suspend fun updatedBy(`value`: Output<UserInfoArgs>) {
        this.updatedBy = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("igojlvssnbubbnnq")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Bookmark ID
     */
    @JvmName("fksnsuiewnxarlag")
    public suspend fun bookmarkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bookmarkId = mapped
    }

    /**
     * @param value The time the bookmark was created
     */
    @JvmName("judflafdcwjyccdh")
    public suspend fun created(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.created = mapped
    }

    /**
     * @param value Describes a user that created the bookmark
     */
    @JvmName("axpxlkklfudiiidx")
    public suspend fun createdBy(`value`: UserInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createdBy = mapped
    }

    /**
     * @param argument Describes a user that created the bookmark
     */
    @JvmName("xasbpkohwheaqwxr")
    public suspend fun createdBy(argument: suspend UserInfoArgsBuilder.() -> Unit) {
        val toBeMapped = UserInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.createdBy = mapped
    }

    /**
     * @param value The display name of the bookmark
     */
    @JvmName("jmucxjybhfcgnove")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The bookmark event time
     */
    @JvmName("xkbwphcehuwrfpth")
    public suspend fun eventTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventTime = mapped
    }

    /**
     * @param value Describes an incident that relates to bookmark
     */
    @JvmName("swkmlwqrlnfrlevb")
    public suspend fun incidentInfo(`value`: IncidentInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.incidentInfo = mapped
    }

    /**
     * @param argument Describes an incident that relates to bookmark
     */
    @JvmName("tjoqolysbufgudok")
    public suspend fun incidentInfo(argument: suspend IncidentInfoArgsBuilder.() -> Unit) {
        val toBeMapped = IncidentInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.incidentInfo = mapped
    }

    /**
     * @param value List of labels relevant to this bookmark
     */
    @JvmName("jtsldpikljhidipj")
    public suspend fun labels(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param values List of labels relevant to this bookmark
     */
    @JvmName("gsjrcnjxtpxjudla")
    public suspend fun labels(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param value The notes of the bookmark
     */
    @JvmName("ddoflvunjinltkoj")
    public suspend fun notes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notes = mapped
    }

    /**
     * @param value The query of the bookmark.
     */
    @JvmName("whuibbcfkdmjcmbo")
    public suspend fun query(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.query = mapped
    }

    /**
     * @param value The end time for the query
     */
    @JvmName("byiywfmafcisvmxp")
    public suspend fun queryEndTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryEndTime = mapped
    }

    /**
     * @param value The query result of the bookmark.
     */
    @JvmName("xlsvngxkmikjxmat")
    public suspend fun queryResult(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryResult = mapped
    }

    /**
     * @param value The start time for the query
     */
    @JvmName("jkimayjiyimqsyjn")
    public suspend fun queryStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryStartTime = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mfwrerjnjpwtqmlm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The last time the bookmark was updated
     */
    @JvmName("sspjdhfybqsfeilo")
    public suspend fun updated(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.updated = mapped
    }

    /**
     * @param value Describes a user that updated the bookmark
     */
    @JvmName("jwrnonartburhrbv")
    public suspend fun updatedBy(`value`: UserInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.updatedBy = mapped
    }

    /**
     * @param argument Describes a user that updated the bookmark
     */
    @JvmName("tfmnbmkdtrpdagfu")
    public suspend fun updatedBy(argument: suspend UserInfoArgsBuilder.() -> Unit) {
        val toBeMapped = UserInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.updatedBy = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("igqxjkyouqavcqvc")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): BookmarkArgs = BookmarkArgs(
        bookmarkId = bookmarkId,
        created = created,
        createdBy = createdBy,
        displayName = displayName,
        eventTime = eventTime,
        incidentInfo = incidentInfo,
        labels = labels,
        notes = notes,
        query = query,
        queryEndTime = queryEndTime,
        queryResult = queryResult,
        queryStartTime = queryStartTime,
        resourceGroupName = resourceGroupName,
        updated = updated,
        updatedBy = updatedBy,
        workspaceName = workspaceName,
    )
}
