@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.CustomizableConnectorDefinitionArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.CustomizableConnectionsConfigArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.CustomizableConnectionsConfigArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.CustomizableConnectorUiConfigArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.CustomizableConnectorUiConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Connector definition for kind 'Customizable'.
 * Azure REST API version: 2023-07-01-preview.
 * ## Example Usage
 * ### Create data connector definition
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var customizableConnectorDefinition = new AzureNative.SecurityInsights.CustomizableConnectorDefinition("customizableConnectorDefinition", new()
 *     {
 *         ConnectorUiConfig = new AzureNative.SecurityInsights.Inputs.CustomizableConnectorUiConfigArgs
 *         {
 *             Availability = new AzureNative.SecurityInsights.Inputs.ConnectorDefinitionsAvailabilityArgs
 *             {
 *                 IsPreview = false,
 *                 Status = 1,
 *             },
 *             ConnectivityCriteria = new[]
 *             {
 *                 new AzureNative.SecurityInsights.Inputs.ConnectivityCriterionArgs
 *                 {
 *                     Type = "IsConnectedQuery",
 *                     Value = new[]
 *                     {
 *                         @"GitHubAuditLogPolling_CL
 *  | summarize LastLogReceived = max(TimeGenerated)
 *  | project IsConnected = LastLogReceived > ago(30d)",
 *                     },
 *                 },
 *             },
 *             DataTypes = new[]
 *             {
 *                 new AzureNative.SecurityInsights.Inputs.ConnectorDataTypeArgs
 *                 {
 *                     LastDataReceivedQuery = @"GitHubAuditLogPolling_CL
 *             | summarize Time = max(TimeGenerated)
 *             | where isnotempty(Time)",
 *                     Name = "GitHubAuditLogPolling_CL",
 *                 },
 *             },
 *             DescriptionMarkdown = "The GitHub audit log connector provides the capability to ingest GitHub logs into Azure Sentinel. By connecting GitHub audit logs into Azure Sentinel, you can view this data in workbooks, use it to create custom alerts, and improve your investigation process.",
 *             GraphQueries = new[]
 *             {
 *                 new AzureNative.SecurityInsights.Inputs.GraphQueryArgs
 *                 {
 *                     BaseQuery = "GitHubAuditLogPolling_CL",
 *                     Legend = "GitHub audit log events",
 *                     MetricName = "Total events received",
 *                 },
 *             },
 *             InstructionSteps = new[]
 *             {
 *                 new AzureNative.SecurityInsights.Inputs.InstructionStepArgs
 *                 {
 *                     Description = @"Enable GitHub audit Logs.
 *  Follow [this](https://docs.github.com/en/github/authenticating-to-github/keeping-your-account-and-data-secure/creating-a-personal-access-token) to create or find your personal key",
 *                     Instructions = new[]
 *                     {
 *                         new AzureNative.SecurityInsights.Inputs.InstructionStepDetailsArgs
 *                         {
 *                             Parameters =
 *                             {
 *                                 { "clientIdLabel", "Client ID" },
 *                                 { "clientSecretLabel", "Client Secret" },
 *                                 { "connectButtonLabel", "Connect" },
 *                                 { "disconnectButtonLabel", "Disconnect" },
 *                             },
 *                             Type = "OAuthForm",
 *                         },
 *                     },
 *                     Title = "Connect GitHub Enterprise Audit Log to Azure Sentinel",
 *                 },
 *             },
 *             Permissions = new AzureNative.SecurityInsights.Inputs.ConnectorDefinitionsPermissionsArgs
 *             {
 *                 Customs = new[]
 *                 {
 *                     new AzureNative.SecurityInsights.Inputs.CustomPermissionDetailsArgs
 *                     {
 *                         Description = "You need access to GitHub personal token, the key should have 'admin:org' scope",
 *                         Name = "GitHub API personal token Key",
 *                     },
 *                 },
 *                 ResourceProvider = new[]
 *                 {
 *                     new AzureNative.SecurityInsights.Inputs.ConnectorDefinitionsResourceProviderArgs
 *                     {
 *                         PermissionsDisplayText = "read and write permissions are required.",
 *                         Provider = "Microsoft.OperationalInsights/workspaces",
 *                         ProviderDisplayName = "Workspace",
 *                         RequiredPermissions = new AzureNative.SecurityInsights.Inputs.ResourceProviderRequiredPermissionsArgs
 *                         {
 *                             Action = false,
 *                             Delete = false,
 *                             Read = false,
 *                             Write = true,
 *                         },
 *                         Scope = "Workspace",
 *                     },
 *                 },
 *             },
 *             Publisher = "GitHub",
 *             SampleQueries = new[]
 *             {
 *                 new AzureNative.SecurityInsights.Inputs.SampleQueryArgs
 *                 {
 *                     Description = "All logs",
 *                     Query = @"GitHubAuditLogPolling_CL
 *  | take 10",
 *                 },
 *             },
 *             Title = "GitHub Enterprise Audit Log",
 *         },
 *         DataConnectorDefinitionName = "73e01a99-5cd7-4139-a149-9f2736ff2ab5",
 *         Kind = "Customizable",
 *         ResourceGroupName = "myRg",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := securityinsights.NewCustomizableConnectorDefinition(ctx, "customizableConnectorDefinition", &securityinsights.CustomizableConnectorDefinitionArgs{
 * ConnectorUiConfig: securityinsights.CustomizableConnectorUiConfigResponse{
 * Availability: &securityinsights.ConnectorDefinitionsAvailabilityArgs{
 * IsPreview: pulumi.Bool(false),
 * Status: pulumi.Int(1),
 * },
 * ConnectivityCriteria: securityinsights.ConnectivityCriterionArray{
 * &securityinsights.ConnectivityCriterionArgs{
 * Type: pulumi.String("IsConnectedQuery"),
 * Value: pulumi.StringArray{
 * pulumi.String("GitHubAuditLogPolling_CL \n | summarize LastLogReceived = max(TimeGenerated)\n | project IsConnected = LastLogReceived > ago(30d)"),
 * },
 * },
 * },
 * DataTypes: securityinsights.ConnectorDataTypeArray{
 * &securityinsights.ConnectorDataTypeArgs{
 * LastDataReceivedQuery: pulumi.String("GitHubAuditLogPolling_CL \n            | summarize Time = max(TimeGenerated)\n            | where isnotempty(Time)"),
 * Name: pulumi.String("GitHubAuditLogPolling_CL"),
 * },
 * },
 * DescriptionMarkdown: pulumi.String("The GitHub audit log connector provides the capability to ingest GitHub logs into Azure Sentinel. By connecting GitHub audit logs into Azure Sentinel, you can view this data in workbooks, use it to create custom alerts, and improve your investigation process."),
 * GraphQueries: securityinsights.GraphQueryArray{
 * &securityinsights.GraphQueryArgs{
 * BaseQuery: pulumi.String("GitHubAuditLogPolling_CL"),
 * Legend: pulumi.String("GitHub audit log events"),
 * MetricName: pulumi.String("Total events received"),
 * },
 * },
 * InstructionSteps: []securityinsights.InstructionStepArgs{
 * {
 * Description: pulumi.String("Enable GitHub audit Logs. \n Follow [this](https://docs.github.com/en/github/authenticating-to-github/keeping-your-account-and-data-secure/creating-a-personal-access-token) to create or find your personal key"),
 * Instructions: securityinsights.InstructionStepDetailsArray{
 * {
 * Parameters: {
 * ClientIdLabel: "Client ID",
 * ClientSecretLabel: "Client Secret",
 * ConnectButtonLabel: "Connect",
 * DisconnectButtonLabel: "Disconnect",
 * },
 * Type: pulumi.String("OAuthForm"),
 * },
 * },
 * Title: pulumi.String("Connect GitHub Enterprise Audit Log to Azure Sentinel"),
 * },
 * },
 * Permissions: interface{}{
 * Customs: securityinsights.CustomPermissionDetailsArray{
 * &securityinsights.CustomPermissionDetailsArgs{
 * Description: pulumi.String("You need access to GitHub personal token, the key should have 'admin:org' scope"),
 * Name: pulumi.String("GitHub API personal token Key"),
 * },
 * },
 * ResourceProvider: securityinsights.ConnectorDefinitionsResourceProviderArray{
 * interface{}{
 * PermissionsDisplayText: pulumi.String("read and write permissions are required."),
 * Provider: pulumi.String("Microsoft.OperationalInsights/workspaces"),
 * ProviderDisplayName: pulumi.String("Workspace"),
 * RequiredPermissions: &securityinsights.ResourceProviderRequiredPermissionsArgs{
 * Action: pulumi.Bool(false),
 * Delete: pulumi.Bool(false),
 * Read: pulumi.Bool(false),
 * Write: pulumi.Bool(true),
 * },
 * Scope: pulumi.String("Workspace"),
 * },
 * },
 * },
 * Publisher: pulumi.String("GitHub"),
 * SampleQueries: securityinsights.SampleQueryArray{
 * &securityinsights.SampleQueryArgs{
 * Description: pulumi.String("All logs"),
 * Query: pulumi.String("GitHubAuditLogPolling_CL \n | take 10"),
 * },
 * },
 * Title: pulumi.String("GitHub Enterprise Audit Log"),
 * },
 * DataConnectorDefinitionName: pulumi.String("73e01a99-5cd7-4139-a149-9f2736ff2ab5"),
 * Kind: pulumi.String("Customizable"),
 * ResourceGroupName: pulumi.String("myRg"),
 * WorkspaceName: pulumi.String("myWorkspace"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.CustomizableConnectorDefinition;
 * import com.pulumi.azurenative.securityinsights.CustomizableConnectorDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var customizableConnectorDefinition = new CustomizableConnectorDefinition("customizableConnectorDefinition", CustomizableConnectorDefinitionArgs.builder()
 *             .connectorUiConfig(Map.ofEntries(
 *                 Map.entry("availability", Map.ofEntries(
 *                     Map.entry("isPreview", false),
 *                     Map.entry("status", 1)
 *                 )),
 *                 Map.entry("connectivityCriteria", Map.ofEntries(
 *                     Map.entry("type", "IsConnectedQuery"),
 *                     Map.entry("value", """
 * GitHubAuditLogPolling_CL
 *  | summarize LastLogReceived = max(TimeGenerated)
 *  | project IsConnected = LastLogReceived > ago(30d)                    """)
 *                 )),
 *                 Map.entry("dataTypes", Map.ofEntries(
 *                     Map.entry("lastDataReceivedQuery", """
 * GitHubAuditLogPolling_CL
 *             | summarize Time = max(TimeGenerated)
 *             | where isnotempty(Time)                    """),
 *                     Map.entry("name", "GitHubAuditLogPolling_CL")
 *                 )),
 *                 Map.entry("descriptionMarkdown", "The GitHub audit log connector provides the capability to ingest GitHub logs into Azure Sentinel. By connecting GitHub audit logs into Azure Sentinel, you can view this data in workbooks, use it to create custom alerts, and improve your investigation process."),
 *                 Map.entry("graphQueries", Map.ofEntries(
 *                     Map.entry("baseQuery", "GitHubAuditLogPolling_CL"),
 *                     Map.entry("legend", "GitHub audit log events"),
 *                     Map.entry("metricName", "Total events received")
 *                 )),
 *                 Map.entry("instructionSteps", Map.ofEntries(
 *                     Map.entry("description", """
 * Enable GitHub audit Logs.
 *  Follow [this](https://docs.github.com/en/github/authenticating-to-github/keeping-your-account-and-data-secure/creating-a-personal-access-token) to create or find your personal key                    """),
 *                     Map.entry("instructions", Map.ofEntries(
 *                         Map.entry("parameters", Map.ofEntries(
 *                             Map.entry("clientIdLabel", "Client ID"),
 *                             Map.entry("clientSecretLabel", "Client Secret"),
 *                             Map.entry("connectButtonLabel", "Connect"),
 *                             Map.entry("disconnectButtonLabel", "Disconnect")
 *                         )),
 *                         Map.entry("type", "OAuthForm")
 *                     )),
 *                     Map.entry("title", "Connect GitHub Enterprise Audit Log to Azure Sentinel")
 *                 )),
 *                 Map.entry("permissions", Map.ofEntries(
 *                     Map.entry("customs", Map.ofEntries(
 *                         Map.entry("description", "You need access to GitHub personal token, the key should have 'admin:org' scope"),
 *                         Map.entry("name", "GitHub API personal token Key")
 *                     )),
 *                     Map.entry("resourceProvider", Map.ofEntries(
 *                         Map.entry("permissionsDisplayText", "read and write permissions are required."),
 *                         Map.entry("provider", "Microsoft.OperationalInsights/workspaces"),
 *                         Map.entry("providerDisplayName", "Workspace"),
 *                         Map.entry("requiredPermissions", Map.ofEntries(
 *                             Map.entry("action", false),
 *                             Map.entry("delete", false),
 *                             Map.entry("read", false),
 *                             Map.entry("write", true)
 *                         )),
 *                         Map.entry("scope", "Workspace")
 *                     ))
 *                 )),
 *                 Map.entry("publisher", "GitHub"),
 *                 Map.entry("sampleQueries", Map.ofEntries(
 *                     Map.entry("description", "All logs"),
 *                     Map.entry("query", """
 * GitHubAuditLogPolling_CL
 *  | take 10                    """)
 *                 )),
 *                 Map.entry("title", "GitHub Enterprise Audit Log")
 *             ))
 *             .dataConnectorDefinitionName("73e01a99-5cd7-4139-a149-9f2736ff2ab5")
 *             .kind("Customizable")
 *             .resourceGroupName("myRg")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:CustomizableConnectorDefinition 73e01a99-5cd7-4139-a149-9f2736ff2ab5 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/dataConnectorDefinitions/{dataConnectorDefinitionName}
 * ```
 * @property connectionsConfig The UiConfig for 'Customizable' connector definition kind.
 * @property connectorUiConfig The UiConfig for 'Customizable' connector definition kind.
 * @property createdTimeUtc Gets or sets the connector definition created date in UTC format.
 * @property dataConnectorDefinitionName The data connector definition name.
 * @property kind The kind of the data connector definitions
 * Expected value is 'Customizable'.
 * @property lastModifiedUtc Gets or sets the connector definition last modified date in UTC format.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName The name of the workspace.
 */
public data class CustomizableConnectorDefinitionArgs(
    public val connectionsConfig: Output<CustomizableConnectionsConfigArgs>? = null,
    public val connectorUiConfig: Output<CustomizableConnectorUiConfigArgs>? = null,
    public val createdTimeUtc: Output<String>? = null,
    public val dataConnectorDefinitionName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val lastModifiedUtc: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.CustomizableConnectorDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.CustomizableConnectorDefinitionArgs =
        com.pulumi.azurenative.securityinsights.CustomizableConnectorDefinitionArgs.builder()
            .connectionsConfig(connectionsConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .connectorUiConfig(connectorUiConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .createdTimeUtc(createdTimeUtc?.applyValue({ args0 -> args0 }))
            .dataConnectorDefinitionName(dataConnectorDefinitionName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .lastModifiedUtc(lastModifiedUtc?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomizableConnectorDefinitionArgs].
 */
@PulumiTagMarker
public class CustomizableConnectorDefinitionArgsBuilder internal constructor() {
    private var connectionsConfig: Output<CustomizableConnectionsConfigArgs>? = null

    private var connectorUiConfig: Output<CustomizableConnectorUiConfigArgs>? = null

    private var createdTimeUtc: Output<String>? = null

    private var dataConnectorDefinitionName: Output<String>? = null

    private var kind: Output<String>? = null

    private var lastModifiedUtc: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The UiConfig for 'Customizable' connector definition kind.
     */
    @JvmName("hituhwhnypbjaovy")
    public suspend fun connectionsConfig(`value`: Output<CustomizableConnectionsConfigArgs>) {
        this.connectionsConfig = value
    }

    /**
     * @param value The UiConfig for 'Customizable' connector definition kind.
     */
    @JvmName("bknakxvnpauoqpic")
    public suspend fun connectorUiConfig(`value`: Output<CustomizableConnectorUiConfigArgs>) {
        this.connectorUiConfig = value
    }

    /**
     * @param value Gets or sets the connector definition created date in UTC format.
     */
    @JvmName("mehkiswlmmoypqln")
    public suspend fun createdTimeUtc(`value`: Output<String>) {
        this.createdTimeUtc = value
    }

    /**
     * @param value The data connector definition name.
     */
    @JvmName("vtymvohioijjpsym")
    public suspend fun dataConnectorDefinitionName(`value`: Output<String>) {
        this.dataConnectorDefinitionName = value
    }

    /**
     * @param value The kind of the data connector definitions
     * Expected value is 'Customizable'.
     */
    @JvmName("ydloyegwxiumovjm")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Gets or sets the connector definition last modified date in UTC format.
     */
    @JvmName("gneljapvqgstptmu")
    public suspend fun lastModifiedUtc(`value`: Output<String>) {
        this.lastModifiedUtc = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("aaeoydwvecvhqlgq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("kpltdgnbqbrygesv")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The UiConfig for 'Customizable' connector definition kind.
     */
    @JvmName("hxwmuornucthuyib")
    public suspend fun connectionsConfig(`value`: CustomizableConnectionsConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionsConfig = mapped
    }

    /**
     * @param argument The UiConfig for 'Customizable' connector definition kind.
     */
    @JvmName("vywnlkqmdaflevuj")
    public suspend
    fun connectionsConfig(argument: suspend CustomizableConnectionsConfigArgsBuilder.() -> Unit) {
        val toBeMapped = CustomizableConnectionsConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectionsConfig = mapped
    }

    /**
     * @param value The UiConfig for 'Customizable' connector definition kind.
     */
    @JvmName("iwvgsubihnlypkyn")
    public suspend fun connectorUiConfig(`value`: CustomizableConnectorUiConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectorUiConfig = mapped
    }

    /**
     * @param argument The UiConfig for 'Customizable' connector definition kind.
     */
    @JvmName("alhgadulgkqfqpni")
    public suspend
    fun connectorUiConfig(argument: suspend CustomizableConnectorUiConfigArgsBuilder.() -> Unit) {
        val toBeMapped = CustomizableConnectorUiConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectorUiConfig = mapped
    }

    /**
     * @param value Gets or sets the connector definition created date in UTC format.
     */
    @JvmName("bnjndhsrdbleugyj")
    public suspend fun createdTimeUtc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createdTimeUtc = mapped
    }

    /**
     * @param value The data connector definition name.
     */
    @JvmName("eykpfgboesqfawan")
    public suspend fun dataConnectorDefinitionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataConnectorDefinitionName = mapped
    }

    /**
     * @param value The kind of the data connector definitions
     * Expected value is 'Customizable'.
     */
    @JvmName("fijuwqevapmktiry")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Gets or sets the connector definition last modified date in UTC format.
     */
    @JvmName("dtigiqtqxwpqlxgm")
    public suspend fun lastModifiedUtc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastModifiedUtc = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ajkuugmwylvihecs")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("ivbrbwayouprfeew")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): CustomizableConnectorDefinitionArgs = CustomizableConnectorDefinitionArgs(
        connectionsConfig = connectionsConfig,
        connectorUiConfig = connectorUiConfig,
        createdTimeUtc = createdTimeUtc,
        dataConnectorDefinitionName = dataConnectorDefinitionName,
        kind = kind,
        lastModifiedUtc = lastModifiedUtc,
        resourceGroupName = resourceGroupName,
        workspaceName = workspaceName,
    )
}
