@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [FusionAlertRule].
 */
@PulumiTagMarker
public class FusionAlertRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FusionAlertRuleArgs = FusionAlertRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FusionAlertRuleArgsBuilder.() -> Unit) {
        val builder = FusionAlertRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): FusionAlertRule {
        val builtJavaResource =
            com.pulumi.azurenative.securityinsights.FusionAlertRule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return FusionAlertRule(builtJavaResource)
    }
}

/**
 * Represents Fusion alert rule.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-01-01.
 * ## Example Usage
 * ### Creates or updates a Fusion alert rule.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fusionAlertRule = new AzureNative.SecurityInsights.FusionAlertRule("fusionAlertRule", new()
 *     {
 *         AlertRuleTemplateName = "f71aba3d-28fb-450b-b192-4e76a83015c8",
 *         Enabled = true,
 *         Kind = "Fusion",
 *         ResourceGroupName = "myRg",
 *         RuleId = "myFirstFusionRule",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewFusionAlertRule(ctx, "fusionAlertRule", &securityinsights.FusionAlertRuleArgs{
 * 			AlertRuleTemplateName: pulumi.String("f71aba3d-28fb-450b-b192-4e76a83015c8"),
 * 			Enabled:               pulumi.Bool(true),
 * 			Kind:                  pulumi.String("Fusion"),
 * 			ResourceGroupName:     pulumi.String("myRg"),
 * 			RuleId:                pulumi.String("myFirstFusionRule"),
 * 			WorkspaceName:         pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.FusionAlertRule;
 * import com.pulumi.azurenative.securityinsights.FusionAlertRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fusionAlertRule = new FusionAlertRule("fusionAlertRule", FusionAlertRuleArgs.builder()
 *             .alertRuleTemplateName("f71aba3d-28fb-450b-b192-4e76a83015c8")
 *             .enabled(true)
 *             .kind("Fusion")
 *             .resourceGroupName("myRg")
 *             .ruleId("myFirstFusionRule")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates or updates a MicrosoftSecurityIncidentCreation rule.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fusionAlertRule = new AzureNative.SecurityInsights.FusionAlertRule("fusionAlertRule", new()
 *     {
 *         ResourceGroupName = "myRg",
 *         RuleId = "microsoftSecurityIncidentCreationRuleExample",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewFusionAlertRule(ctx, "fusionAlertRule", &securityinsights.FusionAlertRuleArgs{
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			RuleId:            pulumi.String("microsoftSecurityIncidentCreationRuleExample"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.FusionAlertRule;
 * import com.pulumi.azurenative.securityinsights.FusionAlertRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fusionAlertRule = new FusionAlertRule("fusionAlertRule", FusionAlertRuleArgs.builder()
 *             .resourceGroupName("myRg")
 *             .ruleId("microsoftSecurityIncidentCreationRuleExample")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates or updates a Scheduled alert rule.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fusionAlertRule = new AzureNative.SecurityInsights.FusionAlertRule("fusionAlertRule", new()
 *     {
 *         ResourceGroupName = "myRg",
 *         RuleId = "73e01a99-5cd7-4139-a149-9f2736ff2ab5",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewFusionAlertRule(ctx, "fusionAlertRule", &securityinsights.FusionAlertRuleArgs{
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			RuleId:            pulumi.String("73e01a99-5cd7-4139-a149-9f2736ff2ab5"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.FusionAlertRule;
 * import com.pulumi.azurenative.securityinsights.FusionAlertRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fusionAlertRule = new FusionAlertRule("fusionAlertRule", FusionAlertRuleArgs.builder()
 *             .resourceGroupName("myRg")
 *             .ruleId("73e01a99-5cd7-4139-a149-9f2736ff2ab5")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:FusionAlertRule 73e01a99-5cd7-4139-a149-9f2736ff2ab5 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/alertRules/{ruleId}
 * ```
 */
public class FusionAlertRule internal constructor(
    override val javaResource: com.pulumi.azurenative.securityinsights.FusionAlertRule,
) : KotlinCustomResource(javaResource, FusionAlertRuleMapper) {
    /**
     * The Name of the alert rule template used to create this rule.
     */
    public val alertRuleTemplateName: Output<String>
        get() = javaResource.alertRuleTemplateName().applyValue({ args0 -> args0 })

    /**
     * The description of the alert rule.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The display name for alerts created by this alert rule.
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * Determines whether this alert rule is enabled or disabled.
     */
    public val enabled: Output<Boolean>
        get() = javaResource.enabled().applyValue({ args0 -> args0 })

    /**
     * Etag of the azure resource
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The kind of the alert rule
     * Expected value is 'Fusion'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * The last time that this alert has been modified.
     */
    public val lastModifiedUtc: Output<String>
        get() = javaResource.lastModifiedUtc().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The severity for alerts created by this alert rule.
     */
    public val severity: Output<String>
        get() = javaResource.severity().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The tactics of the alert rule
     */
    public val tactics: Output<List<String>>
        get() = javaResource.tactics().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The techniques of the alert rule
     */
    public val techniques: Output<List<String>>
        get() = javaResource.techniques().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object FusionAlertRuleMapper : ResourceMapper<FusionAlertRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.securityinsights.FusionAlertRule::class == javaResource::class

    override fun map(javaResource: Resource): FusionAlertRule = FusionAlertRule(
        javaResource as
            com.pulumi.azurenative.securityinsights.FusionAlertRule,
    )
}

/**
 * @see [FusionAlertRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FusionAlertRule].
 */
public suspend fun fusionAlertRule(
    name: String,
    block: suspend FusionAlertRuleResourceBuilder.() -> Unit,
): FusionAlertRule {
    val builder = FusionAlertRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FusionAlertRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun fusionAlertRule(name: String): FusionAlertRule {
    val builder = FusionAlertRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
