@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [HuntRelation].
 */
@PulumiTagMarker
public class HuntRelationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HuntRelationArgs = HuntRelationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HuntRelationArgsBuilder.() -> Unit) {
        val builder = HuntRelationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): HuntRelation {
        val builtJavaResource =
            com.pulumi.azurenative.securityinsights.HuntRelation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return HuntRelation(builtJavaResource)
    }
}

/**
 * Represents a Hunt Relation in Azure Security Insights.
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-12-01-preview.
 * ## Example Usage
 * ### Creates or updates a hunt relation.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var huntRelation = new AzureNative.SecurityInsights.HuntRelation("huntRelation", new()
 *     {
 *         HuntId = "163e7b2a-a2ec-4041-aaba-d878a38f265f",
 *         HuntRelationId = "2216d0e1-91e3-4902-89fd-d2df8c535096",
 *         Labels = new[]
 *         {
 *             "Test Label",
 *         },
 *         RelatedResourceId = "/subscriptions/bd794837-4d29-4647-9105-6339bfdb4e6a/resourceGroups/mms-eus/providers/Microsoft.OperationalInsights/workspaces/avdvirint/providers/Microsoft.SecurityInsights/Bookmarks/2216d0e1-91e3-4902-89fd-d2df8c535096",
 *         ResourceGroupName = "myRg",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewHuntRelation(ctx, "huntRelation", &securityinsights.HuntRelationArgs{
 * 			HuntId:         pulumi.String("163e7b2a-a2ec-4041-aaba-d878a38f265f"),
 * 			HuntRelationId: pulumi.String("2216d0e1-91e3-4902-89fd-d2df8c535096"),
 * 			Labels: pulumi.StringArray{
 * 				pulumi.String("Test Label"),
 * 			},
 * 			RelatedResourceId: pulumi.String("/subscriptions/bd794837-4d29-4647-9105-6339bfdb4e6a/resourceGroups/mms-eus/providers/Microsoft.OperationalInsights/workspaces/avdvirint/providers/Microsoft.SecurityInsights/Bookmarks/2216d0e1-91e3-4902-89fd-d2df8c535096"),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.HuntRelation;
 * import com.pulumi.azurenative.securityinsights.HuntRelationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var huntRelation = new HuntRelation("huntRelation", HuntRelationArgs.builder()
 *             .huntId("163e7b2a-a2ec-4041-aaba-d878a38f265f")
 *             .huntRelationId("2216d0e1-91e3-4902-89fd-d2df8c535096")
 *             .labels("Test Label")
 *             .relatedResourceId("/subscriptions/bd794837-4d29-4647-9105-6339bfdb4e6a/resourceGroups/mms-eus/providers/Microsoft.OperationalInsights/workspaces/avdvirint/providers/Microsoft.SecurityInsights/Bookmarks/2216d0e1-91e3-4902-89fd-d2df8c535096")
 *             .resourceGroupName("myRg")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:HuntRelation 2216d0e1-91e3-4902-89fd-d2df8c535096 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/hunts/{huntId}/relations/{huntRelationId}
 * ```
 */
public class HuntRelation internal constructor(
    override val javaResource: com.pulumi.azurenative.securityinsights.HuntRelation,
) : KotlinCustomResource(javaResource, HuntRelationMapper) {
    /**
     * Etag of the azure resource
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * List of labels relevant to this hunt
     */
    public val labels: Output<List<String>>?
        get() = javaResource.labels().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The id of the related resource
     */
    public val relatedResourceId: Output<String>
        get() = javaResource.relatedResourceId().applyValue({ args0 -> args0 })

    /**
     * The resource that the relation is related to
     */
    public val relatedResourceKind: Output<String>
        get() = javaResource.relatedResourceKind().applyValue({ args0 -> args0 })

    /**
     * The name of the related resource
     */
    public val relatedResourceName: Output<String>
        get() = javaResource.relatedResourceName().applyValue({ args0 -> args0 })

    /**
     * The type of the hunt relation
     */
    public val relationType: Output<String>
        get() = javaResource.relationType().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object HuntRelationMapper : ResourceMapper<HuntRelation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.securityinsights.HuntRelation::class == javaResource::class

    override fun map(javaResource: Resource): HuntRelation = HuntRelation(
        javaResource as
            com.pulumi.azurenative.securityinsights.HuntRelation,
    )
}

/**
 * @see [HuntRelation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HuntRelation].
 */
public suspend fun huntRelation(
    name: String,
    block: suspend HuntRelationResourceBuilder.() -> Unit,
): HuntRelation {
    val builder = HuntRelationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HuntRelation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun huntRelation(name: String): HuntRelation {
    val builder = HuntRelationResourceBuilder()
    builder.name(name)
    return builder.build()
}
