@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.HuntRelationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Represents a Hunt Relation in Azure Security Insights.
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-12-01-preview.
 * ## Example Usage
 * ### Creates or updates a hunt relation.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var huntRelation = new AzureNative.SecurityInsights.HuntRelation("huntRelation", new()
 *     {
 *         HuntId = "163e7b2a-a2ec-4041-aaba-d878a38f265f",
 *         HuntRelationId = "2216d0e1-91e3-4902-89fd-d2df8c535096",
 *         Labels = new[]
 *         {
 *             "Test Label",
 *         },
 *         RelatedResourceId = "/subscriptions/bd794837-4d29-4647-9105-6339bfdb4e6a/resourceGroups/mms-eus/providers/Microsoft.OperationalInsights/workspaces/avdvirint/providers/Microsoft.SecurityInsights/Bookmarks/2216d0e1-91e3-4902-89fd-d2df8c535096",
 *         ResourceGroupName = "myRg",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewHuntRelation(ctx, "huntRelation", &securityinsights.HuntRelationArgs{
 * 			HuntId:         pulumi.String("163e7b2a-a2ec-4041-aaba-d878a38f265f"),
 * 			HuntRelationId: pulumi.String("2216d0e1-91e3-4902-89fd-d2df8c535096"),
 * 			Labels: pulumi.StringArray{
 * 				pulumi.String("Test Label"),
 * 			},
 * 			RelatedResourceId: pulumi.String("/subscriptions/bd794837-4d29-4647-9105-6339bfdb4e6a/resourceGroups/mms-eus/providers/Microsoft.OperationalInsights/workspaces/avdvirint/providers/Microsoft.SecurityInsights/Bookmarks/2216d0e1-91e3-4902-89fd-d2df8c535096"),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.HuntRelation;
 * import com.pulumi.azurenative.securityinsights.HuntRelationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var huntRelation = new HuntRelation("huntRelation", HuntRelationArgs.builder()
 *             .huntId("163e7b2a-a2ec-4041-aaba-d878a38f265f")
 *             .huntRelationId("2216d0e1-91e3-4902-89fd-d2df8c535096")
 *             .labels("Test Label")
 *             .relatedResourceId("/subscriptions/bd794837-4d29-4647-9105-6339bfdb4e6a/resourceGroups/mms-eus/providers/Microsoft.OperationalInsights/workspaces/avdvirint/providers/Microsoft.SecurityInsights/Bookmarks/2216d0e1-91e3-4902-89fd-d2df8c535096")
 *             .resourceGroupName("myRg")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:HuntRelation 2216d0e1-91e3-4902-89fd-d2df8c535096 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/hunts/{huntId}/relations/{huntRelationId}
 * ```
 * @property huntId The hunt id (GUID)
 * @property huntRelationId The hunt relation id (GUID)
 * @property labels List of labels relevant to this hunt
 * @property relatedResourceId The id of the related resource
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName The name of the workspace.
 */
public data class HuntRelationArgs(
    public val huntId: Output<String>? = null,
    public val huntRelationId: Output<String>? = null,
    public val labels: Output<List<String>>? = null,
    public val relatedResourceId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.HuntRelationArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.HuntRelationArgs =
        com.pulumi.azurenative.securityinsights.HuntRelationArgs.builder()
            .huntId(huntId?.applyValue({ args0 -> args0 }))
            .huntRelationId(huntRelationId?.applyValue({ args0 -> args0 }))
            .labels(labels?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .relatedResourceId(relatedResourceId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HuntRelationArgs].
 */
@PulumiTagMarker
public class HuntRelationArgsBuilder internal constructor() {
    private var huntId: Output<String>? = null

    private var huntRelationId: Output<String>? = null

    private var labels: Output<List<String>>? = null

    private var relatedResourceId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The hunt id (GUID)
     */
    @JvmName("xkvjsjpknjiopqoy")
    public suspend fun huntId(`value`: Output<String>) {
        this.huntId = value
    }

    /**
     * @param value The hunt relation id (GUID)
     */
    @JvmName("chuxuitgdbkuwmhk")
    public suspend fun huntRelationId(`value`: Output<String>) {
        this.huntRelationId = value
    }

    /**
     * @param value List of labels relevant to this hunt
     */
    @JvmName("yallwghcthoisepn")
    public suspend fun labels(`value`: Output<List<String>>) {
        this.labels = value
    }

    @JvmName("myfyhjaxygjoskly")
    public suspend fun labels(vararg values: Output<String>) {
        this.labels = Output.all(values.asList())
    }

    /**
     * @param values List of labels relevant to this hunt
     */
    @JvmName("rseudmjtdfdqnqok")
    public suspend fun labels(values: List<Output<String>>) {
        this.labels = Output.all(values)
    }

    /**
     * @param value The id of the related resource
     */
    @JvmName("opptgitxvvtkbmmt")
    public suspend fun relatedResourceId(`value`: Output<String>) {
        this.relatedResourceId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dlwhhemraaurniby")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("ibfehfxiyopnbhtq")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The hunt id (GUID)
     */
    @JvmName("bpotxmqemlgxciip")
    public suspend fun huntId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.huntId = mapped
    }

    /**
     * @param value The hunt relation id (GUID)
     */
    @JvmName("lmsojupucsbimqrb")
    public suspend fun huntRelationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.huntRelationId = mapped
    }

    /**
     * @param value List of labels relevant to this hunt
     */
    @JvmName("edtxfctclflhgrxx")
    public suspend fun labels(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param values List of labels relevant to this hunt
     */
    @JvmName("xpcgcsalrewrywfr")
    public suspend fun labels(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param value The id of the related resource
     */
    @JvmName("merlbmamechorpvo")
    public suspend fun relatedResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relatedResourceId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cburblatsrdjecse")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("uviaetssadqxktxo")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): HuntRelationArgs = HuntRelationArgs(
        huntId = huntId,
        huntRelationId = huntRelationId,
        labels = labels,
        relatedResourceId = relatedResourceId,
        resourceGroupName = resourceGroupName,
        workspaceName = workspaceName,
    )
}
