@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.kotlin.outputs.IncidentAdditionalDataResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.IncidentLabelResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.IncidentOwnerInfoResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.securityinsights.kotlin.outputs.IncidentAdditionalDataResponse.Companion.toKotlin as incidentAdditionalDataResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.IncidentLabelResponse.Companion.toKotlin as incidentLabelResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.IncidentOwnerInfoResponse.Companion.toKotlin as incidentOwnerInfoResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Incident].
 */
@PulumiTagMarker
public class IncidentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IncidentArgs = IncidentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IncidentArgsBuilder.() -> Unit) {
        val builder = IncidentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Incident {
        val builtJavaResource =
            com.pulumi.azurenative.securityinsights.Incident(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Incident(builtJavaResource)
    }
}

/**
 * Represents an incident in Azure Security Insights.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-01-01.
 * Other available API versions: 2021-03-01-preview, 2023-02-01-preview, 2023-03-01-preview, 2023-06-01-preview, 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-11-01, 2023-12-01-preview.
 * ## Example Usage
 * ### Creates or updates an incident.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var incident = new AzureNative.SecurityInsights.Incident("incident", new()
 *     {
 *         Classification = "FalsePositive",
 *         ClassificationComment = "Not a malicious activity",
 *         ClassificationReason = "IncorrectAlertLogic",
 *         Description = "This is a demo incident",
 *         FirstActivityTimeUtc = "2019-01-01T13:00:30Z",
 *         IncidentId = "73e01a99-5cd7-4139-a149-9f2736ff2ab5",
 *         LastActivityTimeUtc = "2019-01-01T13:05:30Z",
 *         Owner = new AzureNative.SecurityInsights.Inputs.IncidentOwnerInfoArgs
 *         {
 *             ObjectId = "2046feea-040d-4a46-9e2b-91c2941bfa70",
 *         },
 *         ResourceGroupName = "myRg",
 *         Severity = "High",
 *         Status = "Closed",
 *         Title = "My incident",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewIncident(ctx, "incident", &securityinsights.IncidentArgs{
 * 			Classification:        pulumi.String("FalsePositive"),
 * 			ClassificationComment: pulumi.String("Not a malicious activity"),
 * 			ClassificationReason:  pulumi.String("IncorrectAlertLogic"),
 * 			Description:           pulumi.String("This is a demo incident"),
 * 			FirstActivityTimeUtc:  pulumi.String("2019-01-01T13:00:30Z"),
 * 			IncidentId:            pulumi.String("73e01a99-5cd7-4139-a149-9f2736ff2ab5"),
 * 			LastActivityTimeUtc:   pulumi.String("2019-01-01T13:05:30Z"),
 * 			Owner: &securityinsights.IncidentOwnerInfoArgs{
 * 				ObjectId: pulumi.String("2046feea-040d-4a46-9e2b-91c2941bfa70"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			Severity:          pulumi.String("High"),
 * 			Status:            pulumi.String("Closed"),
 * 			Title:             pulumi.String("My incident"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.Incident;
 * import com.pulumi.azurenative.securityinsights.IncidentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var incident = new Incident("incident", IncidentArgs.builder()
 *             .classification("FalsePositive")
 *             .classificationComment("Not a malicious activity")
 *             .classificationReason("IncorrectAlertLogic")
 *             .description("This is a demo incident")
 *             .firstActivityTimeUtc("2019-01-01T13:00:30Z")
 *             .incidentId("73e01a99-5cd7-4139-a149-9f2736ff2ab5")
 *             .lastActivityTimeUtc("2019-01-01T13:05:30Z")
 *             .owner(Map.of("objectId", "2046feea-040d-4a46-9e2b-91c2941bfa70"))
 *             .resourceGroupName("myRg")
 *             .severity("High")
 *             .status("Closed")
 *             .title("My incident")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:Incident 73e01a99-5cd7-4139-a149-9f2736ff2ab5 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/incidents/{incidentId}
 * ```
 */
public class Incident internal constructor(
    override val javaResource: com.pulumi.azurenative.securityinsights.Incident,
) : KotlinCustomResource(javaResource, IncidentMapper) {
    /**
     * Additional data on the incident
     */
    public val additionalData: Output<IncidentAdditionalDataResponse>
        get() = javaResource.additionalData().applyValue({ args0 ->
            args0.let({ args0 ->
                incidentAdditionalDataResponseToKotlin(args0)
            })
        })

    /**
     * The reason the incident was closed
     */
    public val classification: Output<String>?
        get() = javaResource.classification().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Describes the reason the incident was closed
     */
    public val classificationComment: Output<String>?
        get() = javaResource.classificationComment().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The classification reason the incident was closed with
     */
    public val classificationReason: Output<String>?
        get() = javaResource.classificationReason().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The time the incident was created
     */
    public val createdTimeUtc: Output<String>
        get() = javaResource.createdTimeUtc().applyValue({ args0 -> args0 })

    /**
     * The description of the incident
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Etag of the azure resource
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The time of the first activity in the incident
     */
    public val firstActivityTimeUtc: Output<String>?
        get() = javaResource.firstActivityTimeUtc().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A sequential number
     */
    public val incidentNumber: Output<Int>
        get() = javaResource.incidentNumber().applyValue({ args0 -> args0 })

    /**
     * The deep-link url to the incident in Azure portal
     */
    public val incidentUrl: Output<String>
        get() = javaResource.incidentUrl().applyValue({ args0 -> args0 })

    /**
     * List of labels relevant to this incident
     */
    public val labels: Output<List<IncidentLabelResponse>>?
        get() = javaResource.labels().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> incidentLabelResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The time of the last activity in the incident
     */
    public val lastActivityTimeUtc: Output<String>?
        get() = javaResource.lastActivityTimeUtc().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The last time the incident was updated
     */
    public val lastModifiedTimeUtc: Output<String>
        get() = javaResource.lastModifiedTimeUtc().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Describes a user that the incident is assigned to
     */
    public val owner: Output<IncidentOwnerInfoResponse>?
        get() = javaResource.owner().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    incidentOwnerInfoResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The incident ID assigned by the incident provider
     */
    public val providerIncidentId: Output<String>
        get() = javaResource.providerIncidentId().applyValue({ args0 -> args0 })

    /**
     * The name of the source provider that generated the incident
     */
    public val providerName: Output<String>
        get() = javaResource.providerName().applyValue({ args0 -> args0 })

    /**
     * List of resource ids of Analytic rules related to the incident
     */
    public val relatedAnalyticRuleIds: Output<List<String>>
        get() = javaResource.relatedAnalyticRuleIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The severity of the incident
     */
    public val severity: Output<String>
        get() = javaResource.severity().applyValue({ args0 -> args0 })

    /**
     * The status of the incident
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The title of the incident
     */
    public val title: Output<String>
        get() = javaResource.title().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object IncidentMapper : ResourceMapper<Incident> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.securityinsights.Incident::class == javaResource::class

    override fun map(javaResource: Resource): Incident = Incident(
        javaResource as
            com.pulumi.azurenative.securityinsights.Incident,
    )
}

/**
 * @see [Incident].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Incident].
 */
public suspend fun incident(name: String, block: suspend IncidentResourceBuilder.() -> Unit):
    Incident {
    val builder = IncidentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Incident].
 * @param name The _unique_ name of the resulting resource.
 */
public fun incident(name: String): Incident {
    val builder = IncidentResourceBuilder()
    builder.name(name)
    return builder.build()
}
