@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.kotlin.outputs.ClientInfoResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.securityinsights.kotlin.outputs.ClientInfoResponse.Companion.toKotlin as clientInfoResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [IncidentComment].
 */
@PulumiTagMarker
public class IncidentCommentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IncidentCommentArgs = IncidentCommentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IncidentCommentArgsBuilder.() -> Unit) {
        val builder = IncidentCommentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): IncidentComment {
        val builtJavaResource =
            com.pulumi.azurenative.securityinsights.IncidentComment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return IncidentComment(builtJavaResource)
    }
}

/**
 * Represents an incident comment
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * Other available API versions: 2021-03-01-preview, 2023-06-01-preview, 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-11-01, 2023-12-01-preview.
 * ## Example Usage
 * ### Creates or updates an incident comment.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var incidentComment = new AzureNative.SecurityInsights.IncidentComment("incidentComment", new()
 *     {
 *         IncidentCommentId = "4bb36b7b-26ff-4d1c-9cbe-0d8ab3da0014",
 *         IncidentId = "73e01a99-5cd7-4139-a149-9f2736ff2ab5",
 *         Message = "Some message",
 *         ResourceGroupName = "myRg",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewIncidentComment(ctx, "incidentComment", &securityinsights.IncidentCommentArgs{
 * 			IncidentCommentId: pulumi.String("4bb36b7b-26ff-4d1c-9cbe-0d8ab3da0014"),
 * 			IncidentId:        pulumi.String("73e01a99-5cd7-4139-a149-9f2736ff2ab5"),
 * 			Message:           pulumi.String("Some message"),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.IncidentComment;
 * import com.pulumi.azurenative.securityinsights.IncidentCommentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var incidentComment = new IncidentComment("incidentComment", IncidentCommentArgs.builder()
 *             .incidentCommentId("4bb36b7b-26ff-4d1c-9cbe-0d8ab3da0014")
 *             .incidentId("73e01a99-5cd7-4139-a149-9f2736ff2ab5")
 *             .message("Some message")
 *             .resourceGroupName("myRg")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:IncidentComment 4bb36b7b-26ff-4d1c-9cbe-0d8ab3da0014 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/incidents/{incidentId}/comments/{incidentCommentId}
 * ```
 */
public class IncidentComment internal constructor(
    override val javaResource: com.pulumi.azurenative.securityinsights.IncidentComment,
) : KotlinCustomResource(javaResource, IncidentCommentMapper) {
    /**
     * Describes the client that created the comment
     */
    public val author: Output<ClientInfoResponse>
        get() = javaResource.author().applyValue({ args0 ->
            args0.let({ args0 ->
                clientInfoResponseToKotlin(args0)
            })
        })

    /**
     * The time the comment was created
     */
    public val createdTimeUtc: Output<String>
        get() = javaResource.createdTimeUtc().applyValue({ args0 -> args0 })

    /**
     * Etag of the azure resource
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The time the comment was updated
     */
    public val lastModifiedTimeUtc: Output<String>
        get() = javaResource.lastModifiedTimeUtc().applyValue({ args0 -> args0 })

    /**
     * The comment message
     */
    public val message: Output<String>
        get() = javaResource.message().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object IncidentCommentMapper : ResourceMapper<IncidentComment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.securityinsights.IncidentComment::class == javaResource::class

    override fun map(javaResource: Resource): IncidentComment = IncidentComment(
        javaResource as
            com.pulumi.azurenative.securityinsights.IncidentComment,
    )
}

/**
 * @see [IncidentComment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IncidentComment].
 */
public suspend fun incidentComment(
    name: String,
    block: suspend IncidentCommentResourceBuilder.() -> Unit,
): IncidentComment {
    val builder = IncidentCommentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IncidentComment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun incidentComment(name: String): IncidentComment {
    val builder = IncidentCommentResourceBuilder()
    builder.name(name)
    return builder.build()
}
