@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.IncidentRelationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents a relation between two resources
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * Other available API versions: 2021-03-01-preview, 2023-06-01-preview, 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-11-01, 2023-12-01-preview.
 * ## Example Usage
 * ### Creates or updates an incident relation.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var incidentRelation = new AzureNative.SecurityInsights.IncidentRelation("incidentRelation", new()
 *     {
 *         IncidentId = "afbd324f-6c48-459c-8710-8d1e1cd03812",
 *         RelatedResourceId = "/subscriptions/d0cfe6b2-9ac0-4464-9919-dccaee2e48c0/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace/providers/Microsoft.SecurityInsights/bookmarks/2216d0e1-91e3-4902-89fd-d2df8c535096",
 *         RelationName = "4bb36b7b-26ff-4d1c-9cbe-0d8ab3da0014",
 *         ResourceGroupName = "myRg",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewIncidentRelation(ctx, "incidentRelation", &securityinsights.IncidentRelationArgs{
 * 			IncidentId:        pulumi.String("afbd324f-6c48-459c-8710-8d1e1cd03812"),
 * 			RelatedResourceId: pulumi.String("/subscriptions/d0cfe6b2-9ac0-4464-9919-dccaee2e48c0/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace/providers/Microsoft.SecurityInsights/bookmarks/2216d0e1-91e3-4902-89fd-d2df8c535096"),
 * 			RelationName:      pulumi.String("4bb36b7b-26ff-4d1c-9cbe-0d8ab3da0014"),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.IncidentRelation;
 * import com.pulumi.azurenative.securityinsights.IncidentRelationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var incidentRelation = new IncidentRelation("incidentRelation", IncidentRelationArgs.builder()
 *             .incidentId("afbd324f-6c48-459c-8710-8d1e1cd03812")
 *             .relatedResourceId("/subscriptions/d0cfe6b2-9ac0-4464-9919-dccaee2e48c0/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace/providers/Microsoft.SecurityInsights/bookmarks/2216d0e1-91e3-4902-89fd-d2df8c535096")
 *             .relationName("4bb36b7b-26ff-4d1c-9cbe-0d8ab3da0014")
 *             .resourceGroupName("myRg")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:IncidentRelation 4bb36b7b-26ff-4d1c-9cbe-0d8ab3da0014 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/incidents/{incidentId}/relations/{relationName}
 * ```
 * @property incidentId Incident ID
 * @property relatedResourceId The resource ID of the related resource
 * @property relationName Relation Name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName The name of the workspace.
 */
public data class IncidentRelationArgs(
    public val incidentId: Output<String>? = null,
    public val relatedResourceId: Output<String>? = null,
    public val relationName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.IncidentRelationArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.IncidentRelationArgs =
        com.pulumi.azurenative.securityinsights.IncidentRelationArgs.builder()
            .incidentId(incidentId?.applyValue({ args0 -> args0 }))
            .relatedResourceId(relatedResourceId?.applyValue({ args0 -> args0 }))
            .relationName(relationName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IncidentRelationArgs].
 */
@PulumiTagMarker
public class IncidentRelationArgsBuilder internal constructor() {
    private var incidentId: Output<String>? = null

    private var relatedResourceId: Output<String>? = null

    private var relationName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Incident ID
     */
    @JvmName("ovswvxvhhqodnsdj")
    public suspend fun incidentId(`value`: Output<String>) {
        this.incidentId = value
    }

    /**
     * @param value The resource ID of the related resource
     */
    @JvmName("jgggcbfevgvhhchq")
    public suspend fun relatedResourceId(`value`: Output<String>) {
        this.relatedResourceId = value
    }

    /**
     * @param value Relation Name
     */
    @JvmName("cmnobghkyybmgkyd")
    public suspend fun relationName(`value`: Output<String>) {
        this.relationName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lmfowvogpgviiehw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("ifkfsxiflduaulvt")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Incident ID
     */
    @JvmName("bwqotfunpbgjxcjk")
    public suspend fun incidentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.incidentId = mapped
    }

    /**
     * @param value The resource ID of the related resource
     */
    @JvmName("ftommytvuapkhkxl")
    public suspend fun relatedResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relatedResourceId = mapped
    }

    /**
     * @param value Relation Name
     */
    @JvmName("fbfjfrqellmtyhrt")
    public suspend fun relationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relationName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("aerarngegsbsuqgb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("iuexiosjrefvdcyc")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): IncidentRelationArgs = IncidentRelationArgs(
        incidentId = incidentId,
        relatedResourceId = relatedResourceId,
        relationName = relationName,
        resourceGroupName = resourceGroupName,
        workspaceName = workspaceName,
    )
}
