@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataAuthorResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataCategoriesResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataDependenciesResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataSourceResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataSupportResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataAuthorResponse.Companion.toKotlin as metadataAuthorResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataCategoriesResponse.Companion.toKotlin as metadataCategoriesResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataDependenciesResponse.Companion.toKotlin as metadataDependenciesResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataSourceResponse.Companion.toKotlin as metadataSourceResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.MetadataSupportResponse.Companion.toKotlin as metadataSupportResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Metadata].
 */
@PulumiTagMarker
public class MetadataResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MetadataArgs = MetadataArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MetadataArgsBuilder.() -> Unit) {
        val builder = MetadataArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Metadata {
        val builtJavaResource =
            com.pulumi.azurenative.securityinsights.Metadata(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Metadata(builtJavaResource)
    }
}

/**
 * Metadata resource definition.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * Other available API versions: 2021-03-01-preview, 2023-02-01-preview, 2023-06-01-preview, 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-11-01, 2023-12-01-preview.
 * ## Example Usage
 * ### Create/update minimal metadata.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var metadata = new AzureNative.SecurityInsights.Metadata("metadata", new()
 *     {
 *         ContentId = "c00ee137-7475-47c8-9cce-ec6f0f1bedd0",
 *         Kind = "AnalyticsRule",
 *         MetadataName = "metadataName",
 *         ParentId = "/subscriptions/2e1dc338-d04d-4443-b721-037eff4fdcac/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace/providers/Microsoft.SecurityInsights/alertRules/ruleName",
 *         ResourceGroupName = "myRg",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewMetadata(ctx, "metadata", &securityinsights.MetadataArgs{
 * 			ContentId:         pulumi.String("c00ee137-7475-47c8-9cce-ec6f0f1bedd0"),
 * 			Kind:              pulumi.String("AnalyticsRule"),
 * 			MetadataName:      pulumi.String("metadataName"),
 * 			ParentId:          pulumi.String("/subscriptions/2e1dc338-d04d-4443-b721-037eff4fdcac/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace/providers/Microsoft.SecurityInsights/alertRules/ruleName"),
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.Metadata;
 * import com.pulumi.azurenative.securityinsights.MetadataArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var metadata = new Metadata("metadata", MetadataArgs.builder()
 *             .contentId("c00ee137-7475-47c8-9cce-ec6f0f1bedd0")
 *             .kind("AnalyticsRule")
 *             .metadataName("metadataName")
 *             .parentId("/subscriptions/2e1dc338-d04d-4443-b721-037eff4fdcac/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace/providers/Microsoft.SecurityInsights/alertRules/ruleName")
 *             .resourceGroupName("myRg")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:Metadata metadataName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/metadata/{metadataName}
 * ```
 */
public class Metadata internal constructor(
    override val javaResource: com.pulumi.azurenative.securityinsights.Metadata,
) : KotlinCustomResource(javaResource, MetadataMapper) {
    /**
     * The creator of the content item.
     */
    public val author: Output<MetadataAuthorResponse>?
        get() = javaResource.author().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    metadataAuthorResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Categories for the solution content item
     */
    public val categories: Output<MetadataCategoriesResponse>?
        get() = javaResource.categories().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    metadataCategoriesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Static ID for the content.  Used to identify dependencies and content from solutions or community.  Hard-coded/static for out of the box content and solutions. Dynamic for user-created.  This is the resource name
     */
    public val contentId: Output<String>?
        get() = javaResource.contentId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Schema version of the content. Can be used to distinguish between different flow based on the schema version
     */
    public val contentSchemaVersion: Output<String>?
        get() = javaResource.contentSchemaVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The custom version of the content. A optional free text
     */
    public val customVersion: Output<String>?
        get() = javaResource.customVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Dependencies for the content item, what other content items it requires to work.  Can describe more complex dependencies using a recursive/nested structure. For a single dependency an id/kind/version can be supplied or operator/criteria for complex formats.
     */
    public val dependencies: Output<MetadataDependenciesResponse>?
        get() = javaResource.dependencies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    metadataDependenciesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Etag of the azure resource
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * first publish date solution content item
     */
    public val firstPublishDate: Output<String>?
        get() = javaResource.firstPublishDate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * the icon identifier. this id can later be fetched from the solution template
     */
    public val icon: Output<String>?
        get() = javaResource.icon().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The kind of content the metadata is for.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * last publish date for the solution content item
     */
    public val lastPublishDate: Output<String>?
        get() = javaResource.lastPublishDate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Full parent resource ID of the content item the metadata is for.  This is the full resource ID including the scope (subscription and resource group)
     */
    public val parentId: Output<String>
        get() = javaResource.parentId().applyValue({ args0 -> args0 })

    /**
     * preview image file names. These will be taken from the solution artifacts
     */
    public val previewImages: Output<List<String>>?
        get() = javaResource.previewImages().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * preview image file names. These will be taken from the solution artifacts. used for dark theme support
     */
    public val previewImagesDark: Output<List<String>>?
        get() = javaResource.previewImagesDark().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Providers for the solution content item
     */
    public val providers: Output<List<String>>?
        get() = javaResource.providers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Source of the content.  This is where/how it was created.
     */
    public val source: Output<MetadataSourceResponse>?
        get() = javaResource.source().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    metadataSourceResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Support information for the metadata - type, name, contact information
     */
    public val support: Output<MetadataSupportResponse>?
        get() = javaResource.support().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    metadataSupportResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * the tactics the resource covers
     */
    public val threatAnalysisTactics: Output<List<String>>?
        get() = javaResource.threatAnalysisTactics().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * the techniques the resource covers, these have to be aligned with the tactics being used
     */
    public val threatAnalysisTechniques: Output<List<String>>?
        get() = javaResource.threatAnalysisTechniques().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Version of the content.  Default and recommended format is numeric (e.g. 1, 1.0, 1.0.0, 1.0.0.0), following ARM template best practices.  Can also be any string, but then we cannot guarantee any version checks
     */
    public val version: Output<String>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object MetadataMapper : ResourceMapper<Metadata> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.securityinsights.Metadata::class == javaResource::class

    override fun map(javaResource: Resource): Metadata = Metadata(
        javaResource as
            com.pulumi.azurenative.securityinsights.Metadata,
    )
}

/**
 * @see [Metadata].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Metadata].
 */
public suspend fun metadata(name: String, block: suspend MetadataResourceBuilder.() -> Unit):
    Metadata {
    val builder = MetadataResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Metadata].
 * @param name The _unique_ name of the resulting resource.
 */
public fun metadata(name: String): Metadata {
    val builder = MetadataResourceBuilder()
    builder.name(name)
    return builder.build()
}
