@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.kotlin.outputs.AlertDetailsOverrideResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.EntityMappingResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.EventGroupingSettingsResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.IncidentConfigurationResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.securityinsights.kotlin.outputs.AlertDetailsOverrideResponse.Companion.toKotlin as alertDetailsOverrideResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.EntityMappingResponse.Companion.toKotlin as entityMappingResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.EventGroupingSettingsResponse.Companion.toKotlin as eventGroupingSettingsResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.IncidentConfigurationResponse.Companion.toKotlin as incidentConfigurationResponseToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ScheduledAlertRule].
 */
@PulumiTagMarker
public class ScheduledAlertRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ScheduledAlertRuleArgs = ScheduledAlertRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ScheduledAlertRuleArgsBuilder.() -> Unit) {
        val builder = ScheduledAlertRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ScheduledAlertRule {
        val builtJavaResource =
            com.pulumi.azurenative.securityinsights.ScheduledAlertRule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ScheduledAlertRule(builtJavaResource)
    }
}

/**
 * Represents scheduled alert rule.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-01-01.
 * ## Example Usage
 * ### Creates or updates a Fusion alert rule.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var scheduledAlertRule = new AzureNative.SecurityInsights.ScheduledAlertRule("scheduledAlertRule", new()
 *     {
 *         ResourceGroupName = "myRg",
 *         RuleId = "myFirstFusionRule",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewScheduledAlertRule(ctx, "scheduledAlertRule", &securityinsights.ScheduledAlertRuleArgs{
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			RuleId:            pulumi.String("myFirstFusionRule"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.ScheduledAlertRule;
 * import com.pulumi.azurenative.securityinsights.ScheduledAlertRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var scheduledAlertRule = new ScheduledAlertRule("scheduledAlertRule", ScheduledAlertRuleArgs.builder()
 *             .resourceGroupName("myRg")
 *             .ruleId("myFirstFusionRule")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates or updates a MicrosoftSecurityIncidentCreation rule.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var scheduledAlertRule = new AzureNative.SecurityInsights.ScheduledAlertRule("scheduledAlertRule", new()
 *     {
 *         ResourceGroupName = "myRg",
 *         RuleId = "microsoftSecurityIncidentCreationRuleExample",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewScheduledAlertRule(ctx, "scheduledAlertRule", &securityinsights.ScheduledAlertRuleArgs{
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			RuleId:            pulumi.String("microsoftSecurityIncidentCreationRuleExample"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.ScheduledAlertRule;
 * import com.pulumi.azurenative.securityinsights.ScheduledAlertRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var scheduledAlertRule = new ScheduledAlertRule("scheduledAlertRule", ScheduledAlertRuleArgs.builder()
 *             .resourceGroupName("myRg")
 *             .ruleId("microsoftSecurityIncidentCreationRuleExample")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates or updates a Scheduled alert rule.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var scheduledAlertRule = new AzureNative.SecurityInsights.ScheduledAlertRule("scheduledAlertRule", new()
 *     {
 *         AlertDetailsOverride = new AzureNative.SecurityInsights.Inputs.AlertDetailsOverrideArgs
 *         {
 *             AlertDescriptionFormat = "Suspicious activity was made by {{ComputerIP}}",
 *             AlertDisplayNameFormat = "Alert from {{Computer}}",
 *             AlertDynamicProperties = new[]
 *             {
 *                 new AzureNative.SecurityInsights.Inputs.AlertPropertyMappingArgs
 *                 {
 *                     AlertProperty = "ProductComponentName",
 *                     Value = "ProductComponentNameCustomColumn",
 *                 },
 *                 new AzureNative.SecurityInsights.Inputs.AlertPropertyMappingArgs
 *                 {
 *                     AlertProperty = "ProductName",
 *                     Value = "ProductNameCustomColumn",
 *                 },
 *                 new AzureNative.SecurityInsights.Inputs.AlertPropertyMappingArgs
 *                 {
 *                     AlertProperty = "AlertLink",
 *                     Value = "Link",
 *                 },
 *             },
 *         },
 *         CustomDetails =
 *         {
 *             { "OperatingSystemName", "OSName" },
 *             { "OperatingSystemType", "OSType" },
 *         },
 *         Description = "An example for a scheduled rule",
 *         DisplayName = "My scheduled rule",
 *         Enabled = true,
 *         EntityMappings = new[]
 *         {
 *             new AzureNative.SecurityInsights.Inputs.EntityMappingArgs
 *             {
 *                 EntityType = "Host",
 *                 FieldMappings = new[]
 *                 {
 *                     new AzureNative.SecurityInsights.Inputs.FieldMappingArgs
 *                     {
 *                         ColumnName = "Computer",
 *                         Identifier = "FullName",
 *                     },
 *                 },
 *             },
 *             new AzureNative.SecurityInsights.Inputs.EntityMappingArgs
 *             {
 *                 EntityType = "IP",
 *                 FieldMappings = new[]
 *                 {
 *                     new AzureNative.SecurityInsights.Inputs.FieldMappingArgs
 *                     {
 *                         ColumnName = "ComputerIP",
 *                         Identifier = "Address",
 *                     },
 *                 },
 *             },
 *         },
 *         EventGroupingSettings = new AzureNative.SecurityInsights.Inputs.EventGroupingSettingsArgs
 *         {
 *             AggregationKind = "AlertPerResult",
 *         },
 *         IncidentConfiguration = new AzureNative.SecurityInsights.Inputs.IncidentConfigurationArgs
 *         {
 *             CreateIncident = true,
 *             GroupingConfiguration = new AzureNative.SecurityInsights.Inputs.GroupingConfigurationArgs
 *             {
 *                 Enabled = true,
 *                 GroupByAlertDetails = new[]
 *                 {
 *                     "DisplayName",
 *                 },
 *                 GroupByCustomDetails = new[]
 *                 {
 *                     "OperatingSystemType",
 *                     "OperatingSystemName",
 *                 },
 *                 GroupByEntities = new[]
 *                 {
 *                     "Host",
 *                 },
 *                 LookbackDuration = "PT5H",
 *                 MatchingMethod = "Selected",
 *                 ReopenClosedIncident = false,
 *             },
 *         },
 *         Kind = "Scheduled",
 *         Query = "Heartbeat",
 *         QueryFrequency = "PT1H",
 *         QueryPeriod = "P2DT1H30M",
 *         ResourceGroupName = "myRg",
 *         RuleId = "73e01a99-5cd7-4139-a149-9f2736ff2ab5",
 *         Severity = "High",
 *         SuppressionDuration = "PT1H",
 *         SuppressionEnabled = false,
 *         Tactics = new[]
 *         {
 *             "Persistence",
 *             "LateralMovement",
 *         },
 *         TriggerOperator = AzureNative.SecurityInsights.TriggerOperator.GreaterThan,
 *         TriggerThreshold = 0,
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewScheduledAlertRule(ctx, "scheduledAlertRule", &securityinsights.ScheduledAlertRuleArgs{
 * 			AlertDetailsOverride: securityinsights.AlertDetailsOverrideResponse{
 * 				AlertDescriptionFormat: pulumi.String("Suspicious activity was made by {{ComputerIP}}"),
 * 				AlertDisplayNameFormat: pulumi.String("Alert from {{Computer}}"),
 * 				AlertDynamicProperties: securityinsights.AlertPropertyMappingArray{
 * 					&securityinsights.AlertPropertyMappingArgs{
 * 						AlertProperty: pulumi.String("ProductComponentName"),
 * 						Value:         pulumi.String("ProductComponentNameCustomColumn"),
 * 					},
 * 					&securityinsights.AlertPropertyMappingArgs{
 * 						AlertProperty: pulumi.String("ProductName"),
 * 						Value:         pulumi.String("ProductNameCustomColumn"),
 * 					},
 * 					&securityinsights.AlertPropertyMappingArgs{
 * 						AlertProperty: pulumi.String("AlertLink"),
 * 						Value:         pulumi.String("Link"),
 * 					},
 * 				},
 * 			},
 * 			CustomDetails: pulumi.StringMap{
 * 				"OperatingSystemName": pulumi.String("OSName"),
 * 				"OperatingSystemType": pulumi.String("OSType"),
 * 			},
 * 			Description: pulumi.String("An example for a scheduled rule"),
 * 			DisplayName: pulumi.String("My scheduled rule"),
 * 			Enabled:     pulumi.Bool(true),
 * 			EntityMappings: []securityinsights.EntityMappingArgs{
 * 				{
 * 					EntityType: pulumi.String("Host"),
 * 					FieldMappings: securityinsights.FieldMappingArray{
 * 						{
 * 							ColumnName: pulumi.String("Computer"),
 * 							Identifier: pulumi.String("FullName"),
 * 						},
 * 					},
 * 				},
 * 				{
 * 					EntityType: pulumi.String("IP"),
 * 					FieldMappings: securityinsights.FieldMappingArray{
 * 						{
 * 							ColumnName: pulumi.String("ComputerIP"),
 * 							Identifier: pulumi.String("Address"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			EventGroupingSettings: &securityinsights.EventGroupingSettingsArgs{
 * 				AggregationKind: pulumi.String("AlertPerResult"),
 * 			},
 * 			IncidentConfiguration: securityinsights.IncidentConfigurationResponse{
 * 				CreateIncident: pulumi.Bool(true),
 * 				GroupingConfiguration: &securityinsights.GroupingConfigurationArgs{
 * 					Enabled: pulumi.Bool(true),
 * 					GroupByAlertDetails: pulumi.StringArray{
 * 						pulumi.String("DisplayName"),
 * 					},
 * 					GroupByCustomDetails: pulumi.StringArray{
 * 						pulumi.String("OperatingSystemType"),
 * 						pulumi.String("OperatingSystemName"),
 * 					},
 * 					GroupByEntities: pulumi.StringArray{
 * 						pulumi.String("Host"),
 * 					},
 * 					LookbackDuration:     pulumi.String("PT5H"),
 * 					MatchingMethod:       pulumi.String("Selected"),
 * 					ReopenClosedIncident: pulumi.Bool(false),
 * 				},
 * 			},
 * 			Kind:                pulumi.String("Scheduled"),
 * 			Query:               pulumi.String("Heartbeat"),
 * 			QueryFrequency:      pulumi.String("PT1H"),
 * 			QueryPeriod:         pulumi.String("P2DT1H30M"),
 * 			ResourceGroupName:   pulumi.String("myRg"),
 * 			RuleId:              pulumi.String("73e01a99-5cd7-4139-a149-9f2736ff2ab5"),
 * 			Severity:            pulumi.String("High"),
 * 			SuppressionDuration: pulumi.String("PT1H"),
 * 			SuppressionEnabled:  pulumi.Bool(false),
 * 			Tactics: pulumi.StringArray{
 * 				pulumi.String("Persistence"),
 * 				pulumi.String("LateralMovement"),
 * 			},
 * 			TriggerOperator:  securityinsights.TriggerOperatorGreaterThan,
 * 			TriggerThreshold: pulumi.Int(0),
 * 			WorkspaceName:    pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.ScheduledAlertRule;
 * import com.pulumi.azurenative.securityinsights.ScheduledAlertRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var scheduledAlertRule = new ScheduledAlertRule("scheduledAlertRule", ScheduledAlertRuleArgs.builder()
 *             .alertDetailsOverride(Map.ofEntries(
 *                 Map.entry("alertDescriptionFormat", "Suspicious activity was made by {{ComputerIP}}"),
 *                 Map.entry("alertDisplayNameFormat", "Alert from {{Computer}}"),
 *                 Map.entry("alertDynamicProperties",
 *                     Map.ofEntries(
 *                         Map.entry("alertProperty", "ProductComponentName"),
 *                         Map.entry("value", "ProductComponentNameCustomColumn")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("alertProperty", "ProductName"),
 *                         Map.entry("value", "ProductNameCustomColumn")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("alertProperty", "AlertLink"),
 *                         Map.entry("value", "Link")
 *                     ))
 *             ))
 *             .customDetails(Map.ofEntries(
 *                 Map.entry("OperatingSystemName", "OSName"),
 *                 Map.entry("OperatingSystemType", "OSType")
 *             ))
 *             .description("An example for a scheduled rule")
 *             .displayName("My scheduled rule")
 *             .enabled(true)
 *             .entityMappings(
 *                 Map.ofEntries(
 *                     Map.entry("entityType", "Host"),
 *                     Map.entry("fieldMappings", Map.ofEntries(
 *                         Map.entry("columnName", "Computer"),
 *                         Map.entry("identifier", "FullName")
 *                     ))
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("entityType", "IP"),
 *                     Map.entry("fieldMappings", Map.ofEntries(
 *                         Map.entry("columnName", "ComputerIP"),
 *                         Map.entry("identifier", "Address")
 *                     ))
 *                 ))
 *             .eventGroupingSettings(Map.of("aggregationKind", "AlertPerResult"))
 *             .incidentConfiguration(Map.ofEntries(
 *                 Map.entry("createIncident", true),
 *                 Map.entry("groupingConfiguration", Map.ofEntries(
 *                     Map.entry("enabled", true),
 *                     Map.entry("groupByAlertDetails", "DisplayName"),
 *                     Map.entry("groupByCustomDetails",
 *                         "OperatingSystemType",
 *                         "OperatingSystemName"),
 *                     Map.entry("groupByEntities", "Host"),
 *                     Map.entry("lookbackDuration", "PT5H"),
 *                     Map.entry("matchingMethod", "Selected"),
 *                     Map.entry("reopenClosedIncident", false)
 *                 ))
 *             ))
 *             .kind("Scheduled")
 *             .query("Heartbeat")
 *             .queryFrequency("PT1H")
 *             .queryPeriod("P2DT1H30M")
 *             .resourceGroupName("myRg")
 *             .ruleId("73e01a99-5cd7-4139-a149-9f2736ff2ab5")
 *             .severity("High")
 *             .suppressionDuration("PT1H")
 *             .suppressionEnabled(false)
 *             .tactics(
 *                 "Persistence",
 *                 "LateralMovement")
 *             .triggerOperator("GreaterThan")
 *             .triggerThreshold(0)
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:ScheduledAlertRule 73e01a99-5cd7-4139-a149-9f2736ff2ab5 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/alertRules/{ruleId}
 * ```
 */
public class ScheduledAlertRule internal constructor(
    override val javaResource: com.pulumi.azurenative.securityinsights.ScheduledAlertRule,
) : KotlinCustomResource(javaResource, ScheduledAlertRuleMapper) {
    /**
     * The alert details override settings
     */
    public val alertDetailsOverride: Output<AlertDetailsOverrideResponse>?
        get() = javaResource.alertDetailsOverride().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> alertDetailsOverrideResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The Name of the alert rule template used to create this rule.
     */
    public val alertRuleTemplateName: Output<String>?
        get() = javaResource.alertRuleTemplateName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Dictionary of string key-value pairs of columns to be attached to the alert
     */
    public val customDetails: Output<Map<String, String>>?
        get() = javaResource.customDetails().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * The description of the alert rule.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The display name for alerts created by this alert rule.
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * Determines whether this alert rule is enabled or disabled.
     */
    public val enabled: Output<Boolean>
        get() = javaResource.enabled().applyValue({ args0 -> args0 })

    /**
     * Array of the entity mappings of the alert rule
     */
    public val entityMappings: Output<List<EntityMappingResponse>>?
        get() = javaResource.entityMappings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        entityMappingResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Etag of the azure resource
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The event grouping settings.
     */
    public val eventGroupingSettings: Output<EventGroupingSettingsResponse>?
        get() = javaResource.eventGroupingSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> eventGroupingSettingsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The settings of the incidents that created from alerts triggered by this analytics rule
     */
    public val incidentConfiguration: Output<IncidentConfigurationResponse>?
        get() = javaResource.incidentConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> incidentConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The kind of the alert rule
     * Expected value is 'Scheduled'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * The last time that this alert rule has been modified.
     */
    public val lastModifiedUtc: Output<String>
        get() = javaResource.lastModifiedUtc().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The query that creates alerts for this rule.
     */
    public val query: Output<String>
        get() = javaResource.query().applyValue({ args0 -> args0 })

    /**
     * The frequency (in ISO 8601 duration format) for this alert rule to run.
     */
    public val queryFrequency: Output<String>
        get() = javaResource.queryFrequency().applyValue({ args0 -> args0 })

    /**
     * The period (in ISO 8601 duration format) that this alert rule looks at.
     */
    public val queryPeriod: Output<String>
        get() = javaResource.queryPeriod().applyValue({ args0 -> args0 })

    /**
     * The severity for alerts created by this alert rule.
     */
    public val severity: Output<String>
        get() = javaResource.severity().applyValue({ args0 -> args0 })

    /**
     * The suppression (in ISO 8601 duration format) to wait since last time this alert rule been triggered.
     */
    public val suppressionDuration: Output<String>
        get() = javaResource.suppressionDuration().applyValue({ args0 -> args0 })

    /**
     * Determines whether the suppression for this alert rule is enabled or disabled.
     */
    public val suppressionEnabled: Output<Boolean>
        get() = javaResource.suppressionEnabled().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The tactics of the alert rule
     */
    public val tactics: Output<List<String>>?
        get() = javaResource.tactics().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The techniques of the alert rule
     */
    public val techniques: Output<List<String>>?
        get() = javaResource.techniques().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The version of the alert rule template used to create this rule - in format <a.b.c>, where all are numbers, for example 0 <1.0.2>
     */
    public val templateVersion: Output<String>?
        get() = javaResource.templateVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The operation against the threshold that triggers alert rule.
     */
    public val triggerOperator: Output<String>
        get() = javaResource.triggerOperator().applyValue({ args0 -> args0 })

    /**
     * The threshold triggers this alert rule.
     */
    public val triggerThreshold: Output<Int>
        get() = javaResource.triggerThreshold().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ScheduledAlertRuleMapper : ResourceMapper<ScheduledAlertRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.securityinsights.ScheduledAlertRule::class == javaResource::class

    override fun map(javaResource: Resource): ScheduledAlertRule = ScheduledAlertRule(
        javaResource as
            com.pulumi.azurenative.securityinsights.ScheduledAlertRule,
    )
}

/**
 * @see [ScheduledAlertRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ScheduledAlertRule].
 */
public suspend fun scheduledAlertRule(
    name: String,
    block: suspend ScheduledAlertRuleResourceBuilder.() -> Unit,
): ScheduledAlertRule {
    val builder = ScheduledAlertRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ScheduledAlertRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun scheduledAlertRule(name: String): ScheduledAlertRule {
    val builder = ScheduledAlertRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
