@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getAADDataConnectorPlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getAATPDataConnectorPlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getASCDataConnectorPlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getActionPlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getActivityCustomEntityQueryPlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getAnomaliesPlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getAnomalySecurityMLAnalyticsSettingsPlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getAutomationRulePlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getAwsCloudTrailDataConnectorPlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getBookmarkPlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getBookmarkRelationPlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getContentPackagePlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getContentTemplatePlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getCustomizableConnectorDefinitionPlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getEntitiesGetTimelinePlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getEntityAnalyticsPlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getEntityInsightsPlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getEyesOnPlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getFileImportPlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getFusionAlertRulePlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getHuntCommentPlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getHuntPlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getHuntRelationPlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getIncidentCommentPlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getIncidentPlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getIncidentRelationPlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getIncidentTaskPlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getMCASDataConnectorPlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getMDATPDataConnectorPlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getMetadataPlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getMicrosoftSecurityIncidentCreationAlertRulePlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getOfficeDataConnectorPlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getScheduledAlertRulePlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getSentinelOnboardingStatePlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getSourceControlPlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getTIDataConnectorPlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getThreatIntelligenceIndicatorPlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getUebaPlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getWatchlistItemPlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getWatchlistPlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getWorkspaceManagerAssignmentPlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getWorkspaceManagerConfigurationPlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getWorkspaceManagerGroupPlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.getWorkspaceManagerMemberPlain
import com.pulumi.azurenative.securityinsights.SecurityinsightsFunctions.listSourceControlRepositoriesPlain
import com.pulumi.azurenative.securityinsights.kotlin.enums.EntityTimelineKind
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetAADDataConnectorPlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetAADDataConnectorPlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetAATPDataConnectorPlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetAATPDataConnectorPlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetASCDataConnectorPlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetASCDataConnectorPlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetActionPlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetActionPlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetActivityCustomEntityQueryPlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetActivityCustomEntityQueryPlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetAnomaliesPlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetAnomaliesPlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetAnomalySecurityMLAnalyticsSettingsPlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetAnomalySecurityMLAnalyticsSettingsPlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetAutomationRulePlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetAutomationRulePlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetAwsCloudTrailDataConnectorPlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetAwsCloudTrailDataConnectorPlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetBookmarkPlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetBookmarkPlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetBookmarkRelationPlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetBookmarkRelationPlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetContentPackagePlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetContentPackagePlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetContentTemplatePlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetContentTemplatePlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetCustomizableConnectorDefinitionPlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetCustomizableConnectorDefinitionPlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetEntitiesGetTimelinePlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetEntitiesGetTimelinePlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetEntityAnalyticsPlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetEntityAnalyticsPlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetEntityInsightsPlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetEntityInsightsPlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetEyesOnPlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetEyesOnPlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetFileImportPlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetFileImportPlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetFusionAlertRulePlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetFusionAlertRulePlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetHuntCommentPlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetHuntCommentPlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetHuntPlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetHuntPlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetHuntRelationPlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetHuntRelationPlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetIncidentCommentPlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetIncidentCommentPlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetIncidentPlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetIncidentPlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetIncidentRelationPlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetIncidentRelationPlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetIncidentTaskPlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetIncidentTaskPlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetMCASDataConnectorPlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetMCASDataConnectorPlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetMDATPDataConnectorPlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetMDATPDataConnectorPlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetMetadataPlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetMetadataPlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetMicrosoftSecurityIncidentCreationAlertRulePlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetMicrosoftSecurityIncidentCreationAlertRulePlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetOfficeDataConnectorPlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetOfficeDataConnectorPlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetScheduledAlertRulePlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetScheduledAlertRulePlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetSentinelOnboardingStatePlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetSentinelOnboardingStatePlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetSourceControlPlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetSourceControlPlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetTIDataConnectorPlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetTIDataConnectorPlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetThreatIntelligenceIndicatorPlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetThreatIntelligenceIndicatorPlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetUebaPlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetUebaPlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetWatchlistItemPlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetWatchlistItemPlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetWatchlistPlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetWatchlistPlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetWorkspaceManagerAssignmentPlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetWorkspaceManagerAssignmentPlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetWorkspaceManagerConfigurationPlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetWorkspaceManagerConfigurationPlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetWorkspaceManagerGroupPlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetWorkspaceManagerGroupPlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetWorkspaceManagerMemberPlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.GetWorkspaceManagerMemberPlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.ListSourceControlRepositoriesPlainArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.ListSourceControlRepositoriesPlainArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetAADDataConnectorResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetAATPDataConnectorResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetASCDataConnectorResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetActionResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetActivityCustomEntityQueryResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetAnomaliesResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetAnomalySecurityMLAnalyticsSettingsResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetAutomationRuleResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetAwsCloudTrailDataConnectorResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetBookmarkRelationResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetBookmarkResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetContentPackageResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetContentTemplateResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetCustomizableConnectorDefinitionResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetEntitiesGetTimelineResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetEntityAnalyticsResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetEntityInsightsResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetEyesOnResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetFileImportResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetFusionAlertRuleResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetHuntCommentResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetHuntRelationResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetHuntResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetIncidentCommentResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetIncidentRelationResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetIncidentResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetIncidentTaskResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetMCASDataConnectorResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetMDATPDataConnectorResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetMetadataResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetMicrosoftSecurityIncidentCreationAlertRuleResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetOfficeDataConnectorResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetScheduledAlertRuleResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetSentinelOnboardingStateResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetSourceControlResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetTIDataConnectorResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetThreatIntelligenceIndicatorResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetUebaResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetWatchlistItemResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetWatchlistResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetWorkspaceManagerAssignmentResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetWorkspaceManagerConfigurationResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetWorkspaceManagerGroupResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetWorkspaceManagerMemberResult
import com.pulumi.azurenative.securityinsights.kotlin.outputs.ListSourceControlRepositoriesResult
import com.pulumi.core.Either
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetAADDataConnectorResult.Companion.toKotlin as getAADDataConnectorResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetAATPDataConnectorResult.Companion.toKotlin as getAATPDataConnectorResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetASCDataConnectorResult.Companion.toKotlin as getASCDataConnectorResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetActionResult.Companion.toKotlin as getActionResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetActivityCustomEntityQueryResult.Companion.toKotlin as getActivityCustomEntityQueryResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetAnomaliesResult.Companion.toKotlin as getAnomaliesResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetAnomalySecurityMLAnalyticsSettingsResult.Companion.toKotlin as getAnomalySecurityMLAnalyticsSettingsResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetAutomationRuleResult.Companion.toKotlin as getAutomationRuleResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetAwsCloudTrailDataConnectorResult.Companion.toKotlin as getAwsCloudTrailDataConnectorResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetBookmarkRelationResult.Companion.toKotlin as getBookmarkRelationResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetBookmarkResult.Companion.toKotlin as getBookmarkResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetContentPackageResult.Companion.toKotlin as getContentPackageResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetContentTemplateResult.Companion.toKotlin as getContentTemplateResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetCustomizableConnectorDefinitionResult.Companion.toKotlin as getCustomizableConnectorDefinitionResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetEntitiesGetTimelineResult.Companion.toKotlin as getEntitiesGetTimelineResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetEntityAnalyticsResult.Companion.toKotlin as getEntityAnalyticsResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetEntityInsightsResult.Companion.toKotlin as getEntityInsightsResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetEyesOnResult.Companion.toKotlin as getEyesOnResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetFileImportResult.Companion.toKotlin as getFileImportResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetFusionAlertRuleResult.Companion.toKotlin as getFusionAlertRuleResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetHuntCommentResult.Companion.toKotlin as getHuntCommentResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetHuntRelationResult.Companion.toKotlin as getHuntRelationResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetHuntResult.Companion.toKotlin as getHuntResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetIncidentCommentResult.Companion.toKotlin as getIncidentCommentResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetIncidentRelationResult.Companion.toKotlin as getIncidentRelationResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetIncidentResult.Companion.toKotlin as getIncidentResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetIncidentTaskResult.Companion.toKotlin as getIncidentTaskResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetMCASDataConnectorResult.Companion.toKotlin as getMCASDataConnectorResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetMDATPDataConnectorResult.Companion.toKotlin as getMDATPDataConnectorResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetMetadataResult.Companion.toKotlin as getMetadataResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetMicrosoftSecurityIncidentCreationAlertRuleResult.Companion.toKotlin as getMicrosoftSecurityIncidentCreationAlertRuleResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetOfficeDataConnectorResult.Companion.toKotlin as getOfficeDataConnectorResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetScheduledAlertRuleResult.Companion.toKotlin as getScheduledAlertRuleResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetSentinelOnboardingStateResult.Companion.toKotlin as getSentinelOnboardingStateResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetSourceControlResult.Companion.toKotlin as getSourceControlResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetTIDataConnectorResult.Companion.toKotlin as getTIDataConnectorResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetThreatIntelligenceIndicatorResult.Companion.toKotlin as getThreatIntelligenceIndicatorResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetUebaResult.Companion.toKotlin as getUebaResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetWatchlistItemResult.Companion.toKotlin as getWatchlistItemResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetWatchlistResult.Companion.toKotlin as getWatchlistResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetWorkspaceManagerAssignmentResult.Companion.toKotlin as getWorkspaceManagerAssignmentResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetWorkspaceManagerConfigurationResult.Companion.toKotlin as getWorkspaceManagerConfigurationResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetWorkspaceManagerGroupResult.Companion.toKotlin as getWorkspaceManagerGroupResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.GetWorkspaceManagerMemberResult.Companion.toKotlin as getWorkspaceManagerMemberResultToKotlin
import com.pulumi.azurenative.securityinsights.kotlin.outputs.ListSourceControlRepositoriesResult.Companion.toKotlin as listSourceControlRepositoriesResultToKotlin

public object SecurityinsightsFunctions {
    /**
     * Gets a data connector.
     * Azure REST API version: 2023-02-01.
     * @param argument null
     * @return Represents AAD (Azure Active Directory) data connector.
     */
    public suspend fun getAADDataConnector(argument: GetAADDataConnectorPlainArgs):
        GetAADDataConnectorResult =
        getAADDataConnectorResultToKotlin(getAADDataConnectorPlain(argument.toJava()).await())

    /**
     * @see [getAADDataConnector].
     * @param dataConnectorId Connector ID
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Represents AAD (Azure Active Directory) data connector.
     */
    public suspend fun getAADDataConnector(
        dataConnectorId: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetAADDataConnectorResult {
        val argument = GetAADDataConnectorPlainArgs(
            dataConnectorId = dataConnectorId,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getAADDataConnectorResultToKotlin(getAADDataConnectorPlain(argument.toJava()).await())
    }

    /**
     * @see [getAADDataConnector].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetAADDataConnectorPlainArgs].
     * @return Represents AAD (Azure Active Directory) data connector.
     */
    public suspend
    fun getAADDataConnector(argument: suspend GetAADDataConnectorPlainArgsBuilder.() -> Unit):
        GetAADDataConnectorResult {
        val builder = GetAADDataConnectorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAADDataConnectorResultToKotlin(getAADDataConnectorPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a data connector.
     * Azure REST API version: 2023-02-01.
     * @param argument null
     * @return Represents AATP (Azure Advanced Threat Protection) data connector.
     */
    public suspend fun getAATPDataConnector(argument: GetAATPDataConnectorPlainArgs):
        GetAATPDataConnectorResult =
        getAATPDataConnectorResultToKotlin(getAATPDataConnectorPlain(argument.toJava()).await())

    /**
     * @see [getAATPDataConnector].
     * @param dataConnectorId Connector ID
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Represents AATP (Azure Advanced Threat Protection) data connector.
     */
    public suspend fun getAATPDataConnector(
        dataConnectorId: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetAATPDataConnectorResult {
        val argument = GetAATPDataConnectorPlainArgs(
            dataConnectorId = dataConnectorId,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getAATPDataConnectorResultToKotlin(getAATPDataConnectorPlain(argument.toJava()).await())
    }

    /**
     * @see [getAATPDataConnector].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetAATPDataConnectorPlainArgs].
     * @return Represents AATP (Azure Advanced Threat Protection) data connector.
     */
    public suspend
    fun getAATPDataConnector(argument: suspend GetAATPDataConnectorPlainArgsBuilder.() -> Unit):
        GetAATPDataConnectorResult {
        val builder = GetAATPDataConnectorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAATPDataConnectorResultToKotlin(getAATPDataConnectorPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a data connector.
     * Azure REST API version: 2023-02-01.
     * @param argument null
     * @return Represents ASC (Azure Security Center) data connector.
     */
    public suspend fun getASCDataConnector(argument: GetASCDataConnectorPlainArgs):
        GetASCDataConnectorResult =
        getASCDataConnectorResultToKotlin(getASCDataConnectorPlain(argument.toJava()).await())

    /**
     * @see [getASCDataConnector].
     * @param dataConnectorId Connector ID
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Represents ASC (Azure Security Center) data connector.
     */
    public suspend fun getASCDataConnector(
        dataConnectorId: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetASCDataConnectorResult {
        val argument = GetASCDataConnectorPlainArgs(
            dataConnectorId = dataConnectorId,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getASCDataConnectorResultToKotlin(getASCDataConnectorPlain(argument.toJava()).await())
    }

    /**
     * @see [getASCDataConnector].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetASCDataConnectorPlainArgs].
     * @return Represents ASC (Azure Security Center) data connector.
     */
    public suspend
    fun getASCDataConnector(argument: suspend GetASCDataConnectorPlainArgsBuilder.() -> Unit):
        GetASCDataConnectorResult {
        val builder = GetASCDataConnectorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getASCDataConnectorResultToKotlin(getASCDataConnectorPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the action of alert rule.
     * Azure REST API version: 2023-02-01.
     * Other available API versions: 2021-03-01-preview, 2023-06-01-preview, 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-11-01, 2023-12-01-preview.
     * @param argument null
     * @return Action for alert rule.
     */
    public suspend fun getAction(argument: GetActionPlainArgs): GetActionResult =
        getActionResultToKotlin(getActionPlain(argument.toJava()).await())

    /**
     * @see [getAction].
     * @param actionId Action ID
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param ruleId Alert rule ID
     * @param workspaceName The name of the workspace.
     * @return Action for alert rule.
     */
    public suspend fun getAction(
        actionId: String,
        resourceGroupName: String,
        ruleId: String,
        workspaceName: String,
    ): GetActionResult {
        val argument = GetActionPlainArgs(
            actionId = actionId,
            resourceGroupName = resourceGroupName,
            ruleId = ruleId,
            workspaceName = workspaceName,
        )
        return getActionResultToKotlin(getActionPlain(argument.toJava()).await())
    }

    /**
     * @see [getAction].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetActionPlainArgs].
     * @return Action for alert rule.
     */
    public suspend fun getAction(argument: suspend GetActionPlainArgsBuilder.() -> Unit):
        GetActionResult {
        val builder = GetActionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getActionResultToKotlin(getActionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an entity query.
     * Azure REST API version: 2023-06-01-preview.
     * @param argument null
     * @return Represents Activity entity query.
     */
    public suspend fun getActivityCustomEntityQuery(argument: GetActivityCustomEntityQueryPlainArgs):
        GetActivityCustomEntityQueryResult =
        getActivityCustomEntityQueryResultToKotlin(getActivityCustomEntityQueryPlain(argument.toJava()).await())

    /**
     * @see [getActivityCustomEntityQuery].
     * @param entityQueryId entity query ID
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Represents Activity entity query.
     */
    public suspend fun getActivityCustomEntityQuery(
        entityQueryId: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetActivityCustomEntityQueryResult {
        val argument = GetActivityCustomEntityQueryPlainArgs(
            entityQueryId = entityQueryId,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getActivityCustomEntityQueryResultToKotlin(getActivityCustomEntityQueryPlain(argument.toJava()).await())
    }

    /**
     * @see [getActivityCustomEntityQuery].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetActivityCustomEntityQueryPlainArgs].
     * @return Represents Activity entity query.
     */
    public suspend
    fun getActivityCustomEntityQuery(argument: suspend GetActivityCustomEntityQueryPlainArgsBuilder.() -> Unit):
        GetActivityCustomEntityQueryResult {
        val builder = GetActivityCustomEntityQueryPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getActivityCustomEntityQueryResultToKotlin(getActivityCustomEntityQueryPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a setting.
     * Azure REST API version: 2023-06-01-preview.
     * @param argument null
     * @return Settings with single toggle.
     */
    public suspend fun getAnomalies(argument: GetAnomaliesPlainArgs): GetAnomaliesResult =
        getAnomaliesResultToKotlin(getAnomaliesPlain(argument.toJava()).await())

    /**
     * @see [getAnomalies].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param settingsName The setting name. Supports - Anomalies, EyesOn, EntityAnalytics, Ueba
     * @param workspaceName The name of the workspace.
     * @return Settings with single toggle.
     */
    public suspend fun getAnomalies(
        resourceGroupName: String,
        settingsName: String,
        workspaceName: String,
    ): GetAnomaliesResult {
        val argument = GetAnomaliesPlainArgs(
            resourceGroupName = resourceGroupName,
            settingsName = settingsName,
            workspaceName = workspaceName,
        )
        return getAnomaliesResultToKotlin(getAnomaliesPlain(argument.toJava()).await())
    }

    /**
     * @see [getAnomalies].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetAnomaliesPlainArgs].
     * @return Settings with single toggle.
     */
    public suspend fun getAnomalies(argument: suspend GetAnomaliesPlainArgsBuilder.() -> Unit):
        GetAnomaliesResult {
        val builder = GetAnomaliesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAnomaliesResultToKotlin(getAnomaliesPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the Security ML Analytics Settings.
     * Azure REST API version: 2023-02-01.
     * @param argument null
     * @return Represents Anomaly Security ML Analytics Settings
     */
    public suspend
    fun getAnomalySecurityMLAnalyticsSettings(argument: GetAnomalySecurityMLAnalyticsSettingsPlainArgs):
        GetAnomalySecurityMLAnalyticsSettingsResult =
        getAnomalySecurityMLAnalyticsSettingsResultToKotlin(getAnomalySecurityMLAnalyticsSettingsPlain(argument.toJava()).await())

    /**
     * @see [getAnomalySecurityMLAnalyticsSettings].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param settingsResourceName Security ML Analytics Settings resource name
     * @param workspaceName The name of the workspace.
     * @return Represents Anomaly Security ML Analytics Settings
     */
    public suspend fun getAnomalySecurityMLAnalyticsSettings(
        resourceGroupName: String,
        settingsResourceName: String,
        workspaceName: String,
    ): GetAnomalySecurityMLAnalyticsSettingsResult {
        val argument = GetAnomalySecurityMLAnalyticsSettingsPlainArgs(
            resourceGroupName = resourceGroupName,
            settingsResourceName = settingsResourceName,
            workspaceName = workspaceName,
        )
        return getAnomalySecurityMLAnalyticsSettingsResultToKotlin(getAnomalySecurityMLAnalyticsSettingsPlain(argument.toJava()).await())
    }

    /**
     * @see [getAnomalySecurityMLAnalyticsSettings].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetAnomalySecurityMLAnalyticsSettingsPlainArgs].
     * @return Represents Anomaly Security ML Analytics Settings
     */
    public suspend
    fun getAnomalySecurityMLAnalyticsSettings(argument: suspend GetAnomalySecurityMLAnalyticsSettingsPlainArgsBuilder.() -> Unit):
        GetAnomalySecurityMLAnalyticsSettingsResult {
        val builder = GetAnomalySecurityMLAnalyticsSettingsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAnomalySecurityMLAnalyticsSettingsResultToKotlin(getAnomalySecurityMLAnalyticsSettingsPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the automation rule.
     * Azure REST API version: 2023-02-01.
     * Other available API versions: 2019-01-01-preview, 2023-06-01-preview, 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-11-01, 2023-12-01-preview.
     * @param argument null
     * @return null
     */
    public suspend fun getAutomationRule(argument: GetAutomationRulePlainArgs):
        GetAutomationRuleResult =
        getAutomationRuleResultToKotlin(getAutomationRulePlain(argument.toJava()).await())

    /**
     * @see [getAutomationRule].
     * @param automationRuleId Automation rule ID
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return null
     */
    public suspend fun getAutomationRule(
        automationRuleId: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetAutomationRuleResult {
        val argument = GetAutomationRulePlainArgs(
            automationRuleId = automationRuleId,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getAutomationRuleResultToKotlin(getAutomationRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getAutomationRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetAutomationRulePlainArgs].
     * @return null
     */
    public suspend
    fun getAutomationRule(argument: suspend GetAutomationRulePlainArgsBuilder.() -> Unit):
        GetAutomationRuleResult {
        val builder = GetAutomationRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAutomationRuleResultToKotlin(getAutomationRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a data connector.
     * Azure REST API version: 2023-02-01.
     * @param argument null
     * @return Represents Amazon Web Services CloudTrail data connector.
     */
    public suspend
    fun getAwsCloudTrailDataConnector(argument: GetAwsCloudTrailDataConnectorPlainArgs):
        GetAwsCloudTrailDataConnectorResult =
        getAwsCloudTrailDataConnectorResultToKotlin(getAwsCloudTrailDataConnectorPlain(argument.toJava()).await())

    /**
     * @see [getAwsCloudTrailDataConnector].
     * @param dataConnectorId Connector ID
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Represents Amazon Web Services CloudTrail data connector.
     */
    public suspend fun getAwsCloudTrailDataConnector(
        dataConnectorId: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetAwsCloudTrailDataConnectorResult {
        val argument = GetAwsCloudTrailDataConnectorPlainArgs(
            dataConnectorId = dataConnectorId,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getAwsCloudTrailDataConnectorResultToKotlin(getAwsCloudTrailDataConnectorPlain(argument.toJava()).await())
    }

    /**
     * @see [getAwsCloudTrailDataConnector].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetAwsCloudTrailDataConnectorPlainArgs].
     * @return Represents Amazon Web Services CloudTrail data connector.
     */
    public suspend
    fun getAwsCloudTrailDataConnector(argument: suspend GetAwsCloudTrailDataConnectorPlainArgsBuilder.() -> Unit):
        GetAwsCloudTrailDataConnectorResult {
        val builder = GetAwsCloudTrailDataConnectorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAwsCloudTrailDataConnectorResultToKotlin(getAwsCloudTrailDataConnectorPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a bookmark.
     * Azure REST API version: 2023-02-01.
     * Other available API versions: 2019-01-01-preview, 2023-06-01-preview, 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-11-01, 2023-12-01-preview.
     * @param argument null
     * @return Represents a bookmark in Azure Security Insights.
     */
    public suspend fun getBookmark(argument: GetBookmarkPlainArgs): GetBookmarkResult =
        getBookmarkResultToKotlin(getBookmarkPlain(argument.toJava()).await())

    /**
     * @see [getBookmark].
     * @param bookmarkId Bookmark ID
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Represents a bookmark in Azure Security Insights.
     */
    public suspend fun getBookmark(
        bookmarkId: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetBookmarkResult {
        val argument = GetBookmarkPlainArgs(
            bookmarkId = bookmarkId,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getBookmarkResultToKotlin(getBookmarkPlain(argument.toJava()).await())
    }

    /**
     * @see [getBookmark].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetBookmarkPlainArgs].
     * @return Represents a bookmark in Azure Security Insights.
     */
    public suspend fun getBookmark(argument: suspend GetBookmarkPlainArgsBuilder.() -> Unit):
        GetBookmarkResult {
        val builder = GetBookmarkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBookmarkResultToKotlin(getBookmarkPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a bookmark relation.
     * Azure REST API version: 2023-06-01-preview.
     * Other available API versions: 2019-01-01-preview, 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-12-01-preview.
     * @param argument null
     * @return Represents a relation between two resources
     */
    public suspend fun getBookmarkRelation(argument: GetBookmarkRelationPlainArgs):
        GetBookmarkRelationResult =
        getBookmarkRelationResultToKotlin(getBookmarkRelationPlain(argument.toJava()).await())

    /**
     * @see [getBookmarkRelation].
     * @param bookmarkId Bookmark ID
     * @param relationName Relation Name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Represents a relation between two resources
     */
    public suspend fun getBookmarkRelation(
        bookmarkId: String,
        relationName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetBookmarkRelationResult {
        val argument = GetBookmarkRelationPlainArgs(
            bookmarkId = bookmarkId,
            relationName = relationName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getBookmarkRelationResultToKotlin(getBookmarkRelationPlain(argument.toJava()).await())
    }

    /**
     * @see [getBookmarkRelation].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetBookmarkRelationPlainArgs].
     * @return Represents a relation between two resources
     */
    public suspend
    fun getBookmarkRelation(argument: suspend GetBookmarkRelationPlainArgsBuilder.() -> Unit):
        GetBookmarkRelationResult {
        val builder = GetBookmarkRelationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBookmarkRelationResultToKotlin(getBookmarkRelationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an installed packages by its id.
     * Azure REST API version: 2023-06-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-11-01, 2023-12-01-preview.
     * @param argument null
     * @return Represents a Package in Azure Security Insights.
     */
    public suspend fun getContentPackage(argument: GetContentPackagePlainArgs):
        GetContentPackageResult =
        getContentPackageResultToKotlin(getContentPackagePlain(argument.toJava()).await())

    /**
     * @see [getContentPackage].
     * @param packageId package Id
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Represents a Package in Azure Security Insights.
     */
    public suspend fun getContentPackage(
        packageId: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetContentPackageResult {
        val argument = GetContentPackagePlainArgs(
            packageId = packageId,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getContentPackageResultToKotlin(getContentPackagePlain(argument.toJava()).await())
    }

    /**
     * @see [getContentPackage].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetContentPackagePlainArgs].
     * @return Represents a Package in Azure Security Insights.
     */
    public suspend
    fun getContentPackage(argument: suspend GetContentPackagePlainArgsBuilder.() -> Unit):
        GetContentPackageResult {
        val builder = GetContentPackagePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getContentPackageResultToKotlin(getContentPackagePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a template byt its identifier.
     * Azure REST API version: 2023-06-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-11-01, 2023-12-01-preview.
     * @param argument null
     * @return Template resource definition.
     */
    public suspend fun getContentTemplate(argument: GetContentTemplatePlainArgs):
        GetContentTemplateResult =
        getContentTemplateResultToKotlin(getContentTemplatePlain(argument.toJava()).await())

    /**
     * @see [getContentTemplate].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param templateId template Id
     * @param workspaceName The name of the workspace.
     * @return Template resource definition.
     */
    public suspend fun getContentTemplate(
        resourceGroupName: String,
        templateId: String,
        workspaceName: String,
    ): GetContentTemplateResult {
        val argument = GetContentTemplatePlainArgs(
            resourceGroupName = resourceGroupName,
            templateId = templateId,
            workspaceName = workspaceName,
        )
        return getContentTemplateResultToKotlin(getContentTemplatePlain(argument.toJava()).await())
    }

    /**
     * @see [getContentTemplate].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetContentTemplatePlainArgs].
     * @return Template resource definition.
     */
    public suspend
    fun getContentTemplate(argument: suspend GetContentTemplatePlainArgsBuilder.() -> Unit):
        GetContentTemplateResult {
        val builder = GetContentTemplatePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getContentTemplateResultToKotlin(getContentTemplatePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a data connector definition.
     * Azure REST API version: 2023-07-01-preview.
     * @param argument null
     * @return Connector definition for kind 'Customizable'.
     */
    public suspend
    fun getCustomizableConnectorDefinition(argument: GetCustomizableConnectorDefinitionPlainArgs):
        GetCustomizableConnectorDefinitionResult =
        getCustomizableConnectorDefinitionResultToKotlin(getCustomizableConnectorDefinitionPlain(argument.toJava()).await())

    /**
     * @see [getCustomizableConnectorDefinition].
     * @param dataConnectorDefinitionName The data connector definition name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Connector definition for kind 'Customizable'.
     */
    public suspend fun getCustomizableConnectorDefinition(
        dataConnectorDefinitionName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetCustomizableConnectorDefinitionResult {
        val argument = GetCustomizableConnectorDefinitionPlainArgs(
            dataConnectorDefinitionName = dataConnectorDefinitionName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getCustomizableConnectorDefinitionResultToKotlin(getCustomizableConnectorDefinitionPlain(argument.toJava()).await())
    }

    /**
     * @see [getCustomizableConnectorDefinition].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetCustomizableConnectorDefinitionPlainArgs].
     * @return Connector definition for kind 'Customizable'.
     */
    public suspend
    fun getCustomizableConnectorDefinition(argument: suspend GetCustomizableConnectorDefinitionPlainArgsBuilder.() -> Unit):
        GetCustomizableConnectorDefinitionResult {
        val builder = GetCustomizableConnectorDefinitionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCustomizableConnectorDefinitionResultToKotlin(getCustomizableConnectorDefinitionPlain(builtArgument.toJava()).await())
    }

    /**
     * Timeline for an entity.
     * Azure REST API version: 2023-06-01-preview.
     * Other available API versions: 2019-01-01-preview, 2021-09-01-preview, 2021-10-01-preview, 2022-01-01-preview, 2022-04-01-preview, 2022-05-01-preview, 2022-06-01-preview, 2022-07-01-preview, 2022-08-01-preview, 2022-09-01-preview, 2022-10-01-preview, 2022-11-01-preview, 2022-12-01-preview, 2023-02-01-preview, 2023-03-01-preview, 2023-04-01-preview, 2023-05-01-preview, 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-12-01-preview.
     * @param argument null
     * @return The entity timeline result operation response.
     */
    public suspend fun getEntitiesGetTimeline(argument: GetEntitiesGetTimelinePlainArgs):
        GetEntitiesGetTimelineResult =
        getEntitiesGetTimelineResultToKotlin(getEntitiesGetTimelinePlain(argument.toJava()).await())

    /**
     * @see [getEntitiesGetTimeline].
     * @param endTime The end timeline date, so the results returned are before this date.
     * @param entityId entity ID
     * @param kinds Array of timeline Item kinds.
     * @param numberOfBucket The number of bucket for timeline queries aggregation.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param startTime The start timeline date, so the results returned are after this date.
     * @param workspaceName The name of the workspace.
     * @return The entity timeline result operation response.
     */
    public suspend fun getEntitiesGetTimeline(
        endTime: String,
        entityId: String,
        kinds: List<Either<String, EntityTimelineKind>>? = null,
        numberOfBucket: Int? = null,
        resourceGroupName: String,
        startTime: String,
        workspaceName: String,
    ): GetEntitiesGetTimelineResult {
        val argument = GetEntitiesGetTimelinePlainArgs(
            endTime = endTime,
            entityId = entityId,
            kinds = kinds,
            numberOfBucket = numberOfBucket,
            resourceGroupName = resourceGroupName,
            startTime = startTime,
            workspaceName = workspaceName,
        )
        return getEntitiesGetTimelineResultToKotlin(getEntitiesGetTimelinePlain(argument.toJava()).await())
    }

    /**
     * @see [getEntitiesGetTimeline].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetEntitiesGetTimelinePlainArgs].
     * @return The entity timeline result operation response.
     */
    public suspend
    fun getEntitiesGetTimeline(argument: suspend GetEntitiesGetTimelinePlainArgsBuilder.() -> Unit):
        GetEntitiesGetTimelineResult {
        val builder = GetEntitiesGetTimelinePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEntitiesGetTimelineResultToKotlin(getEntitiesGetTimelinePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a setting.
     * Azure REST API version: 2023-06-01-preview.
     * @param argument null
     * @return Settings with single toggle.
     */
    public suspend fun getEntityAnalytics(argument: GetEntityAnalyticsPlainArgs):
        GetEntityAnalyticsResult =
        getEntityAnalyticsResultToKotlin(getEntityAnalyticsPlain(argument.toJava()).await())

    /**
     * @see [getEntityAnalytics].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param settingsName The setting name. Supports - Anomalies, EyesOn, EntityAnalytics, Ueba
     * @param workspaceName The name of the workspace.
     * @return Settings with single toggle.
     */
    public suspend fun getEntityAnalytics(
        resourceGroupName: String,
        settingsName: String,
        workspaceName: String,
    ): GetEntityAnalyticsResult {
        val argument = GetEntityAnalyticsPlainArgs(
            resourceGroupName = resourceGroupName,
            settingsName = settingsName,
            workspaceName = workspaceName,
        )
        return getEntityAnalyticsResultToKotlin(getEntityAnalyticsPlain(argument.toJava()).await())
    }

    /**
     * @see [getEntityAnalytics].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetEntityAnalyticsPlainArgs].
     * @return Settings with single toggle.
     */
    public suspend
    fun getEntityAnalytics(argument: suspend GetEntityAnalyticsPlainArgsBuilder.() -> Unit):
        GetEntityAnalyticsResult {
        val builder = GetEntityAnalyticsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEntityAnalyticsResultToKotlin(getEntityAnalyticsPlain(builtArgument.toJava()).await())
    }

    /**
     * Execute Insights for an entity.
     * Azure REST API version: 2023-06-01-preview.
     * Other available API versions: 2019-01-01-preview, 2021-09-01-preview, 2021-10-01-preview, 2022-01-01-preview, 2022-04-01-preview, 2022-05-01-preview, 2022-06-01-preview, 2022-07-01-preview, 2022-08-01-preview, 2022-09-01-preview, 2022-10-01-preview, 2022-11-01-preview, 2022-12-01-preview, 2023-02-01-preview, 2023-03-01-preview, 2023-04-01-preview, 2023-05-01-preview, 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-12-01-preview.
     * @param argument null
     * @return The Get Insights result operation response.
     */
    public suspend fun getEntityInsights(argument: GetEntityInsightsPlainArgs):
        GetEntityInsightsResult =
        getEntityInsightsResultToKotlin(getEntityInsightsPlain(argument.toJava()).await())

    /**
     * @see [getEntityInsights].
     * @param addDefaultExtendedTimeRange Indicates if query time range should be extended with default time range of the query. Default value is false
     * @param endTime The end timeline date, so the results returned are before this date.
     * @param entityId entity ID
     * @param insightQueryIds List of Insights Query Id. If empty, default value is all insights of this entity
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param startTime The start timeline date, so the results returned are after this date.
     * @param workspaceName The name of the workspace.
     * @return The Get Insights result operation response.
     */
    public suspend fun getEntityInsights(
        addDefaultExtendedTimeRange: Boolean? = null,
        endTime: String,
        entityId: String,
        insightQueryIds: List<String>? = null,
        resourceGroupName: String,
        startTime: String,
        workspaceName: String,
    ): GetEntityInsightsResult {
        val argument = GetEntityInsightsPlainArgs(
            addDefaultExtendedTimeRange = addDefaultExtendedTimeRange,
            endTime = endTime,
            entityId = entityId,
            insightQueryIds = insightQueryIds,
            resourceGroupName = resourceGroupName,
            startTime = startTime,
            workspaceName = workspaceName,
        )
        return getEntityInsightsResultToKotlin(getEntityInsightsPlain(argument.toJava()).await())
    }

    /**
     * @see [getEntityInsights].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetEntityInsightsPlainArgs].
     * @return The Get Insights result operation response.
     */
    public suspend
    fun getEntityInsights(argument: suspend GetEntityInsightsPlainArgsBuilder.() -> Unit):
        GetEntityInsightsResult {
        val builder = GetEntityInsightsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEntityInsightsResultToKotlin(getEntityInsightsPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a setting.
     * Azure REST API version: 2023-06-01-preview.
     * @param argument null
     * @return Settings with single toggle.
     */
    public suspend fun getEyesOn(argument: GetEyesOnPlainArgs): GetEyesOnResult =
        getEyesOnResultToKotlin(getEyesOnPlain(argument.toJava()).await())

    /**
     * @see [getEyesOn].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param settingsName The setting name. Supports - Anomalies, EyesOn, EntityAnalytics, Ueba
     * @param workspaceName The name of the workspace.
     * @return Settings with single toggle.
     */
    public suspend fun getEyesOn(
        resourceGroupName: String,
        settingsName: String,
        workspaceName: String,
    ): GetEyesOnResult {
        val argument = GetEyesOnPlainArgs(
            resourceGroupName = resourceGroupName,
            settingsName = settingsName,
            workspaceName = workspaceName,
        )
        return getEyesOnResultToKotlin(getEyesOnPlain(argument.toJava()).await())
    }

    /**
     * @see [getEyesOn].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetEyesOnPlainArgs].
     * @return Settings with single toggle.
     */
    public suspend fun getEyesOn(argument: suspend GetEyesOnPlainArgsBuilder.() -> Unit):
        GetEyesOnResult {
        val builder = GetEyesOnPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEyesOnResultToKotlin(getEyesOnPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a file import.
     * Azure REST API version: 2023-06-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-12-01-preview.
     * @param argument null
     * @return Represents a file import in Azure Security Insights.
     */
    public suspend fun getFileImport(argument: GetFileImportPlainArgs): GetFileImportResult =
        getFileImportResultToKotlin(getFileImportPlain(argument.toJava()).await())

    /**
     * @see [getFileImport].
     * @param fileImportId File import ID
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Represents a file import in Azure Security Insights.
     */
    public suspend fun getFileImport(
        fileImportId: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetFileImportResult {
        val argument = GetFileImportPlainArgs(
            fileImportId = fileImportId,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getFileImportResultToKotlin(getFileImportPlain(argument.toJava()).await())
    }

    /**
     * @see [getFileImport].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetFileImportPlainArgs].
     * @return Represents a file import in Azure Security Insights.
     */
    public suspend fun getFileImport(argument: suspend GetFileImportPlainArgsBuilder.() -> Unit):
        GetFileImportResult {
        val builder = GetFileImportPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFileImportResultToKotlin(getFileImportPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the alert rule.
     * Azure REST API version: 2023-02-01.
     * @param argument null
     * @return Represents Fusion alert rule.
     */
    public suspend fun getFusionAlertRule(argument: GetFusionAlertRulePlainArgs):
        GetFusionAlertRuleResult =
        getFusionAlertRuleResultToKotlin(getFusionAlertRulePlain(argument.toJava()).await())

    /**
     * @see [getFusionAlertRule].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param ruleId Alert rule ID
     * @param workspaceName The name of the workspace.
     * @return Represents Fusion alert rule.
     */
    public suspend fun getFusionAlertRule(
        resourceGroupName: String,
        ruleId: String,
        workspaceName: String,
    ): GetFusionAlertRuleResult {
        val argument = GetFusionAlertRulePlainArgs(
            resourceGroupName = resourceGroupName,
            ruleId = ruleId,
            workspaceName = workspaceName,
        )
        return getFusionAlertRuleResultToKotlin(getFusionAlertRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getFusionAlertRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetFusionAlertRulePlainArgs].
     * @return Represents Fusion alert rule.
     */
    public suspend
    fun getFusionAlertRule(argument: suspend GetFusionAlertRulePlainArgsBuilder.() -> Unit):
        GetFusionAlertRuleResult {
        val builder = GetFusionAlertRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFusionAlertRuleResultToKotlin(getFusionAlertRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a hunt, without relations and comments.
     * Azure REST API version: 2023-06-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-12-01-preview.
     * @param argument null
     * @return Represents a Hunt in Azure Security Insights.
     */
    public suspend fun getHunt(argument: GetHuntPlainArgs): GetHuntResult =
        getHuntResultToKotlin(getHuntPlain(argument.toJava()).await())

    /**
     * @see [getHunt].
     * @param huntId The hunt id (GUID)
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Represents a Hunt in Azure Security Insights.
     */
    public suspend fun getHunt(
        huntId: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetHuntResult {
        val argument = GetHuntPlainArgs(
            huntId = huntId,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getHuntResultToKotlin(getHuntPlain(argument.toJava()).await())
    }

    /**
     * @see [getHunt].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetHuntPlainArgs].
     * @return Represents a Hunt in Azure Security Insights.
     */
    public suspend fun getHunt(argument: suspend GetHuntPlainArgsBuilder.() -> Unit): GetHuntResult {
        val builder = GetHuntPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHuntResultToKotlin(getHuntPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a hunt comment
     * Azure REST API version: 2023-06-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-12-01-preview.
     * @param argument null
     * @return Represents a Hunt Comment in Azure Security Insights
     */
    public suspend fun getHuntComment(argument: GetHuntCommentPlainArgs): GetHuntCommentResult =
        getHuntCommentResultToKotlin(getHuntCommentPlain(argument.toJava()).await())

    /**
     * @see [getHuntComment].
     * @param huntCommentId The hunt comment id (GUID)
     * @param huntId The hunt id (GUID)
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Represents a Hunt Comment in Azure Security Insights
     */
    public suspend fun getHuntComment(
        huntCommentId: String,
        huntId: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetHuntCommentResult {
        val argument = GetHuntCommentPlainArgs(
            huntCommentId = huntCommentId,
            huntId = huntId,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getHuntCommentResultToKotlin(getHuntCommentPlain(argument.toJava()).await())
    }

    /**
     * @see [getHuntComment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetHuntCommentPlainArgs].
     * @return Represents a Hunt Comment in Azure Security Insights
     */
    public suspend fun getHuntComment(argument: suspend GetHuntCommentPlainArgsBuilder.() -> Unit):
        GetHuntCommentResult {
        val builder = GetHuntCommentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHuntCommentResultToKotlin(getHuntCommentPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a hunt relation
     * Azure REST API version: 2023-06-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-12-01-preview.
     * @param argument null
     * @return Represents a Hunt Relation in Azure Security Insights.
     */
    public suspend fun getHuntRelation(argument: GetHuntRelationPlainArgs): GetHuntRelationResult =
        getHuntRelationResultToKotlin(getHuntRelationPlain(argument.toJava()).await())

    /**
     * @see [getHuntRelation].
     * @param huntId The hunt id (GUID)
     * @param huntRelationId The hunt relation id (GUID)
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Represents a Hunt Relation in Azure Security Insights.
     */
    public suspend fun getHuntRelation(
        huntId: String,
        huntRelationId: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetHuntRelationResult {
        val argument = GetHuntRelationPlainArgs(
            huntId = huntId,
            huntRelationId = huntRelationId,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getHuntRelationResultToKotlin(getHuntRelationPlain(argument.toJava()).await())
    }

    /**
     * @see [getHuntRelation].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetHuntRelationPlainArgs].
     * @return Represents a Hunt Relation in Azure Security Insights.
     */
    public suspend fun getHuntRelation(argument: suspend GetHuntRelationPlainArgsBuilder.() -> Unit):
        GetHuntRelationResult {
        val builder = GetHuntRelationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHuntRelationResultToKotlin(getHuntRelationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a given incident.
     * Azure REST API version: 2023-02-01.
     * Other available API versions: 2021-03-01-preview, 2023-02-01-preview, 2023-03-01-preview, 2023-06-01-preview, 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-11-01, 2023-12-01-preview.
     * @param argument null
     * @return Represents an incident in Azure Security Insights.
     */
    public suspend fun getIncident(argument: GetIncidentPlainArgs): GetIncidentResult =
        getIncidentResultToKotlin(getIncidentPlain(argument.toJava()).await())

    /**
     * @see [getIncident].
     * @param incidentId Incident ID
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Represents an incident in Azure Security Insights.
     */
    public suspend fun getIncident(
        incidentId: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetIncidentResult {
        val argument = GetIncidentPlainArgs(
            incidentId = incidentId,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getIncidentResultToKotlin(getIncidentPlain(argument.toJava()).await())
    }

    /**
     * @see [getIncident].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetIncidentPlainArgs].
     * @return Represents an incident in Azure Security Insights.
     */
    public suspend fun getIncident(argument: suspend GetIncidentPlainArgsBuilder.() -> Unit):
        GetIncidentResult {
        val builder = GetIncidentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIncidentResultToKotlin(getIncidentPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a comment for a given incident.
     * Azure REST API version: 2023-02-01.
     * Other available API versions: 2021-03-01-preview, 2023-06-01-preview, 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-11-01, 2023-12-01-preview.
     * @param argument null
     * @return Represents an incident comment
     */
    public suspend fun getIncidentComment(argument: GetIncidentCommentPlainArgs):
        GetIncidentCommentResult =
        getIncidentCommentResultToKotlin(getIncidentCommentPlain(argument.toJava()).await())

    /**
     * @see [getIncidentComment].
     * @param incidentCommentId Incident comment ID
     * @param incidentId Incident ID
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Represents an incident comment
     */
    public suspend fun getIncidentComment(
        incidentCommentId: String,
        incidentId: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetIncidentCommentResult {
        val argument = GetIncidentCommentPlainArgs(
            incidentCommentId = incidentCommentId,
            incidentId = incidentId,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getIncidentCommentResultToKotlin(getIncidentCommentPlain(argument.toJava()).await())
    }

    /**
     * @see [getIncidentComment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetIncidentCommentPlainArgs].
     * @return Represents an incident comment
     */
    public suspend
    fun getIncidentComment(argument: suspend GetIncidentCommentPlainArgsBuilder.() -> Unit):
        GetIncidentCommentResult {
        val builder = GetIncidentCommentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIncidentCommentResultToKotlin(getIncidentCommentPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a relation for a given incident.
     * Azure REST API version: 2023-02-01.
     * Other available API versions: 2021-03-01-preview, 2023-06-01-preview, 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-11-01, 2023-12-01-preview.
     * @param argument null
     * @return Represents a relation between two resources
     */
    public suspend fun getIncidentRelation(argument: GetIncidentRelationPlainArgs):
        GetIncidentRelationResult =
        getIncidentRelationResultToKotlin(getIncidentRelationPlain(argument.toJava()).await())

    /**
     * @see [getIncidentRelation].
     * @param incidentId Incident ID
     * @param relationName Relation Name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Represents a relation between two resources
     */
    public suspend fun getIncidentRelation(
        incidentId: String,
        relationName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetIncidentRelationResult {
        val argument = GetIncidentRelationPlainArgs(
            incidentId = incidentId,
            relationName = relationName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getIncidentRelationResultToKotlin(getIncidentRelationPlain(argument.toJava()).await())
    }

    /**
     * @see [getIncidentRelation].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetIncidentRelationPlainArgs].
     * @return Represents a relation between two resources
     */
    public suspend
    fun getIncidentRelation(argument: suspend GetIncidentRelationPlainArgsBuilder.() -> Unit):
        GetIncidentRelationResult {
        val builder = GetIncidentRelationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIncidentRelationResultToKotlin(getIncidentRelationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an incident task.
     * Azure REST API version: 2023-06-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-12-01-preview.
     * @param argument null
     * @return null
     */
    public suspend fun getIncidentTask(argument: GetIncidentTaskPlainArgs): GetIncidentTaskResult =
        getIncidentTaskResultToKotlin(getIncidentTaskPlain(argument.toJava()).await())

    /**
     * @see [getIncidentTask].
     * @param incidentId Incident ID
     * @param incidentTaskId Incident task ID
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return null
     */
    public suspend fun getIncidentTask(
        incidentId: String,
        incidentTaskId: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetIncidentTaskResult {
        val argument = GetIncidentTaskPlainArgs(
            incidentId = incidentId,
            incidentTaskId = incidentTaskId,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getIncidentTaskResultToKotlin(getIncidentTaskPlain(argument.toJava()).await())
    }

    /**
     * @see [getIncidentTask].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetIncidentTaskPlainArgs].
     * @return null
     */
    public suspend fun getIncidentTask(argument: suspend GetIncidentTaskPlainArgsBuilder.() -> Unit):
        GetIncidentTaskResult {
        val builder = GetIncidentTaskPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIncidentTaskResultToKotlin(getIncidentTaskPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a data connector.
     * Azure REST API version: 2023-02-01.
     * @param argument null
     * @return Represents MCAS (Microsoft Cloud App Security) data connector.
     */
    public suspend fun getMCASDataConnector(argument: GetMCASDataConnectorPlainArgs):
        GetMCASDataConnectorResult =
        getMCASDataConnectorResultToKotlin(getMCASDataConnectorPlain(argument.toJava()).await())

    /**
     * @see [getMCASDataConnector].
     * @param dataConnectorId Connector ID
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Represents MCAS (Microsoft Cloud App Security) data connector.
     */
    public suspend fun getMCASDataConnector(
        dataConnectorId: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetMCASDataConnectorResult {
        val argument = GetMCASDataConnectorPlainArgs(
            dataConnectorId = dataConnectorId,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getMCASDataConnectorResultToKotlin(getMCASDataConnectorPlain(argument.toJava()).await())
    }

    /**
     * @see [getMCASDataConnector].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetMCASDataConnectorPlainArgs].
     * @return Represents MCAS (Microsoft Cloud App Security) data connector.
     */
    public suspend
    fun getMCASDataConnector(argument: suspend GetMCASDataConnectorPlainArgsBuilder.() -> Unit):
        GetMCASDataConnectorResult {
        val builder = GetMCASDataConnectorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMCASDataConnectorResultToKotlin(getMCASDataConnectorPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a data connector.
     * Azure REST API version: 2023-02-01.
     * @param argument null
     * @return Represents MDATP (Microsoft Defender Advanced Threat Protection) data connector.
     */
    public suspend fun getMDATPDataConnector(argument: GetMDATPDataConnectorPlainArgs):
        GetMDATPDataConnectorResult =
        getMDATPDataConnectorResultToKotlin(getMDATPDataConnectorPlain(argument.toJava()).await())

    /**
     * @see [getMDATPDataConnector].
     * @param dataConnectorId Connector ID
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Represents MDATP (Microsoft Defender Advanced Threat Protection) data connector.
     */
    public suspend fun getMDATPDataConnector(
        dataConnectorId: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetMDATPDataConnectorResult {
        val argument = GetMDATPDataConnectorPlainArgs(
            dataConnectorId = dataConnectorId,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getMDATPDataConnectorResultToKotlin(getMDATPDataConnectorPlain(argument.toJava()).await())
    }

    /**
     * @see [getMDATPDataConnector].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetMDATPDataConnectorPlainArgs].
     * @return Represents MDATP (Microsoft Defender Advanced Threat Protection) data connector.
     */
    public suspend
    fun getMDATPDataConnector(argument: suspend GetMDATPDataConnectorPlainArgsBuilder.() -> Unit):
        GetMDATPDataConnectorResult {
        val builder = GetMDATPDataConnectorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMDATPDataConnectorResultToKotlin(getMDATPDataConnectorPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a Metadata.
     * Azure REST API version: 2023-02-01.
     * Other available API versions: 2021-03-01-preview, 2023-02-01-preview, 2023-06-01-preview, 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-11-01, 2023-12-01-preview.
     * @param argument null
     * @return Metadata resource definition.
     */
    public suspend fun getMetadata(argument: GetMetadataPlainArgs): GetMetadataResult =
        getMetadataResultToKotlin(getMetadataPlain(argument.toJava()).await())

    /**
     * @see [getMetadata].
     * @param metadataName The Metadata name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Metadata resource definition.
     */
    public suspend fun getMetadata(
        metadataName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetMetadataResult {
        val argument = GetMetadataPlainArgs(
            metadataName = metadataName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getMetadataResultToKotlin(getMetadataPlain(argument.toJava()).await())
    }

    /**
     * @see [getMetadata].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetMetadataPlainArgs].
     * @return Metadata resource definition.
     */
    public suspend fun getMetadata(argument: suspend GetMetadataPlainArgsBuilder.() -> Unit):
        GetMetadataResult {
        val builder = GetMetadataPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMetadataResultToKotlin(getMetadataPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the alert rule.
     * Azure REST API version: 2023-02-01.
     * @param argument null
     * @return Represents MicrosoftSecurityIncidentCreation rule.
     */
    public suspend
    fun getMicrosoftSecurityIncidentCreationAlertRule(argument: GetMicrosoftSecurityIncidentCreationAlertRulePlainArgs):
        GetMicrosoftSecurityIncidentCreationAlertRuleResult =
        getMicrosoftSecurityIncidentCreationAlertRuleResultToKotlin(getMicrosoftSecurityIncidentCreationAlertRulePlain(argument.toJava()).await())

    /**
     * @see [getMicrosoftSecurityIncidentCreationAlertRule].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param ruleId Alert rule ID
     * @param workspaceName The name of the workspace.
     * @return Represents MicrosoftSecurityIncidentCreation rule.
     */
    public suspend fun getMicrosoftSecurityIncidentCreationAlertRule(
        resourceGroupName: String,
        ruleId: String,
        workspaceName: String,
    ): GetMicrosoftSecurityIncidentCreationAlertRuleResult {
        val argument = GetMicrosoftSecurityIncidentCreationAlertRulePlainArgs(
            resourceGroupName = resourceGroupName,
            ruleId = ruleId,
            workspaceName = workspaceName,
        )
        return getMicrosoftSecurityIncidentCreationAlertRuleResultToKotlin(getMicrosoftSecurityIncidentCreationAlertRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getMicrosoftSecurityIncidentCreationAlertRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetMicrosoftSecurityIncidentCreationAlertRulePlainArgs].
     * @return Represents MicrosoftSecurityIncidentCreation rule.
     */
    public suspend
    fun getMicrosoftSecurityIncidentCreationAlertRule(argument: suspend GetMicrosoftSecurityIncidentCreationAlertRulePlainArgsBuilder.() -> Unit):
        GetMicrosoftSecurityIncidentCreationAlertRuleResult {
        val builder = GetMicrosoftSecurityIncidentCreationAlertRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMicrosoftSecurityIncidentCreationAlertRuleResultToKotlin(getMicrosoftSecurityIncidentCreationAlertRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a data connector.
     * Azure REST API version: 2023-02-01.
     * @param argument null
     * @return Represents office data connector.
     */
    public suspend fun getOfficeDataConnector(argument: GetOfficeDataConnectorPlainArgs):
        GetOfficeDataConnectorResult =
        getOfficeDataConnectorResultToKotlin(getOfficeDataConnectorPlain(argument.toJava()).await())

    /**
     * @see [getOfficeDataConnector].
     * @param dataConnectorId Connector ID
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Represents office data connector.
     */
    public suspend fun getOfficeDataConnector(
        dataConnectorId: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetOfficeDataConnectorResult {
        val argument = GetOfficeDataConnectorPlainArgs(
            dataConnectorId = dataConnectorId,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getOfficeDataConnectorResultToKotlin(getOfficeDataConnectorPlain(argument.toJava()).await())
    }

    /**
     * @see [getOfficeDataConnector].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetOfficeDataConnectorPlainArgs].
     * @return Represents office data connector.
     */
    public suspend
    fun getOfficeDataConnector(argument: suspend GetOfficeDataConnectorPlainArgsBuilder.() -> Unit):
        GetOfficeDataConnectorResult {
        val builder = GetOfficeDataConnectorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOfficeDataConnectorResultToKotlin(getOfficeDataConnectorPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the alert rule.
     * Azure REST API version: 2023-02-01.
     * @param argument null
     * @return Represents scheduled alert rule.
     */
    public suspend fun getScheduledAlertRule(argument: GetScheduledAlertRulePlainArgs):
        GetScheduledAlertRuleResult =
        getScheduledAlertRuleResultToKotlin(getScheduledAlertRulePlain(argument.toJava()).await())

    /**
     * @see [getScheduledAlertRule].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param ruleId Alert rule ID
     * @param workspaceName The name of the workspace.
     * @return Represents scheduled alert rule.
     */
    public suspend fun getScheduledAlertRule(
        resourceGroupName: String,
        ruleId: String,
        workspaceName: String,
    ): GetScheduledAlertRuleResult {
        val argument = GetScheduledAlertRulePlainArgs(
            resourceGroupName = resourceGroupName,
            ruleId = ruleId,
            workspaceName = workspaceName,
        )
        return getScheduledAlertRuleResultToKotlin(getScheduledAlertRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getScheduledAlertRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetScheduledAlertRulePlainArgs].
     * @return Represents scheduled alert rule.
     */
    public suspend
    fun getScheduledAlertRule(argument: suspend GetScheduledAlertRulePlainArgsBuilder.() -> Unit):
        GetScheduledAlertRuleResult {
        val builder = GetScheduledAlertRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getScheduledAlertRuleResultToKotlin(getScheduledAlertRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Get Sentinel onboarding state
     * Azure REST API version: 2023-02-01.
     * Other available API versions: 2021-03-01-preview, 2023-06-01-preview, 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-11-01, 2023-12-01-preview.
     * @param argument null
     * @return Sentinel onboarding state
     */
    public suspend fun getSentinelOnboardingState(argument: GetSentinelOnboardingStatePlainArgs):
        GetSentinelOnboardingStateResult =
        getSentinelOnboardingStateResultToKotlin(getSentinelOnboardingStatePlain(argument.toJava()).await())

    /**
     * @see [getSentinelOnboardingState].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sentinelOnboardingStateName The Sentinel onboarding state name. Supports - default
     * @param workspaceName The name of the workspace.
     * @return Sentinel onboarding state
     */
    public suspend fun getSentinelOnboardingState(
        resourceGroupName: String,
        sentinelOnboardingStateName: String,
        workspaceName: String,
    ): GetSentinelOnboardingStateResult {
        val argument = GetSentinelOnboardingStatePlainArgs(
            resourceGroupName = resourceGroupName,
            sentinelOnboardingStateName = sentinelOnboardingStateName,
            workspaceName = workspaceName,
        )
        return getSentinelOnboardingStateResultToKotlin(getSentinelOnboardingStatePlain(argument.toJava()).await())
    }

    /**
     * @see [getSentinelOnboardingState].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetSentinelOnboardingStatePlainArgs].
     * @return Sentinel onboarding state
     */
    public suspend
    fun getSentinelOnboardingState(argument: suspend GetSentinelOnboardingStatePlainArgsBuilder.() -> Unit):
        GetSentinelOnboardingStateResult {
        val builder = GetSentinelOnboardingStatePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSentinelOnboardingStateResultToKotlin(getSentinelOnboardingStatePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a source control byt its identifier.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2021-03-01-preview.
     * @param argument null
     * @return Represents a SourceControl in Azure Security Insights.
     */
    public suspend fun getSourceControl(argument: GetSourceControlPlainArgs): GetSourceControlResult =
        getSourceControlResultToKotlin(getSourceControlPlain(argument.toJava()).await())

    /**
     * @see [getSourceControl].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sourceControlId Source control Id
     * @param workspaceName The name of the workspace.
     * @return Represents a SourceControl in Azure Security Insights.
     */
    public suspend fun getSourceControl(
        resourceGroupName: String,
        sourceControlId: String,
        workspaceName: String,
    ): GetSourceControlResult {
        val argument = GetSourceControlPlainArgs(
            resourceGroupName = resourceGroupName,
            sourceControlId = sourceControlId,
            workspaceName = workspaceName,
        )
        return getSourceControlResultToKotlin(getSourceControlPlain(argument.toJava()).await())
    }

    /**
     * @see [getSourceControl].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetSourceControlPlainArgs].
     * @return Represents a SourceControl in Azure Security Insights.
     */
    public suspend
    fun getSourceControl(argument: suspend GetSourceControlPlainArgsBuilder.() -> Unit):
        GetSourceControlResult {
        val builder = GetSourceControlPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSourceControlResultToKotlin(getSourceControlPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a data connector.
     * Azure REST API version: 2023-02-01.
     * @param argument null
     * @return Represents threat intelligence data connector.
     */
    public suspend fun getTIDataConnector(argument: GetTIDataConnectorPlainArgs):
        GetTIDataConnectorResult =
        getTIDataConnectorResultToKotlin(getTIDataConnectorPlain(argument.toJava()).await())

    /**
     * @see [getTIDataConnector].
     * @param dataConnectorId Connector ID
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Represents threat intelligence data connector.
     */
    public suspend fun getTIDataConnector(
        dataConnectorId: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetTIDataConnectorResult {
        val argument = GetTIDataConnectorPlainArgs(
            dataConnectorId = dataConnectorId,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getTIDataConnectorResultToKotlin(getTIDataConnectorPlain(argument.toJava()).await())
    }

    /**
     * @see [getTIDataConnector].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetTIDataConnectorPlainArgs].
     * @return Represents threat intelligence data connector.
     */
    public suspend
    fun getTIDataConnector(argument: suspend GetTIDataConnectorPlainArgsBuilder.() -> Unit):
        GetTIDataConnectorResult {
        val builder = GetTIDataConnectorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTIDataConnectorResultToKotlin(getTIDataConnectorPlain(builtArgument.toJava()).await())
    }

    /**
     * View a threat intelligence indicator by name.
     * Azure REST API version: 2023-02-01.
     * Other available API versions: 2021-04-01, 2021-09-01-preview, 2023-06-01-preview, 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-11-01, 2023-12-01-preview.
     * @param argument null
     * @return Threat intelligence information object.
     */
    public suspend
    fun getThreatIntelligenceIndicator(argument: GetThreatIntelligenceIndicatorPlainArgs):
        GetThreatIntelligenceIndicatorResult =
        getThreatIntelligenceIndicatorResultToKotlin(getThreatIntelligenceIndicatorPlain(argument.toJava()).await())

    /**
     * @see [getThreatIntelligenceIndicator].
     * @param name Threat intelligence indicator name field.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Threat intelligence information object.
     */
    public suspend fun getThreatIntelligenceIndicator(
        name: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetThreatIntelligenceIndicatorResult {
        val argument = GetThreatIntelligenceIndicatorPlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getThreatIntelligenceIndicatorResultToKotlin(getThreatIntelligenceIndicatorPlain(argument.toJava()).await())
    }

    /**
     * @see [getThreatIntelligenceIndicator].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetThreatIntelligenceIndicatorPlainArgs].
     * @return Threat intelligence information object.
     */
    public suspend
    fun getThreatIntelligenceIndicator(argument: suspend GetThreatIntelligenceIndicatorPlainArgsBuilder.() -> Unit):
        GetThreatIntelligenceIndicatorResult {
        val builder = GetThreatIntelligenceIndicatorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getThreatIntelligenceIndicatorResultToKotlin(getThreatIntelligenceIndicatorPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a setting.
     * Azure REST API version: 2023-06-01-preview.
     * @param argument null
     * @return Settings with single toggle.
     */
    public suspend fun getUeba(argument: GetUebaPlainArgs): GetUebaResult =
        getUebaResultToKotlin(getUebaPlain(argument.toJava()).await())

    /**
     * @see [getUeba].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param settingsName The setting name. Supports - Anomalies, EyesOn, EntityAnalytics, Ueba
     * @param workspaceName The name of the workspace.
     * @return Settings with single toggle.
     */
    public suspend fun getUeba(
        resourceGroupName: String,
        settingsName: String,
        workspaceName: String,
    ): GetUebaResult {
        val argument = GetUebaPlainArgs(
            resourceGroupName = resourceGroupName,
            settingsName = settingsName,
            workspaceName = workspaceName,
        )
        return getUebaResultToKotlin(getUebaPlain(argument.toJava()).await())
    }

    /**
     * @see [getUeba].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetUebaPlainArgs].
     * @return Settings with single toggle.
     */
    public suspend fun getUeba(argument: suspend GetUebaPlainArgsBuilder.() -> Unit): GetUebaResult {
        val builder = GetUebaPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUebaResultToKotlin(getUebaPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a watchlist, without its watchlist items.
     * Azure REST API version: 2023-02-01.
     * Other available API versions: 2019-01-01-preview, 2021-03-01-preview, 2021-04-01, 2021-10-01-preview, 2022-01-01-preview, 2023-06-01-preview, 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-11-01, 2023-12-01-preview.
     * @param argument null
     * @return Represents a Watchlist in Azure Security Insights.
     */
    public suspend fun getWatchlist(argument: GetWatchlistPlainArgs): GetWatchlistResult =
        getWatchlistResultToKotlin(getWatchlistPlain(argument.toJava()).await())

    /**
     * @see [getWatchlist].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param watchlistAlias The watchlist alias
     * @param workspaceName The name of the workspace.
     * @return Represents a Watchlist in Azure Security Insights.
     */
    public suspend fun getWatchlist(
        resourceGroupName: String,
        watchlistAlias: String,
        workspaceName: String,
    ): GetWatchlistResult {
        val argument = GetWatchlistPlainArgs(
            resourceGroupName = resourceGroupName,
            watchlistAlias = watchlistAlias,
            workspaceName = workspaceName,
        )
        return getWatchlistResultToKotlin(getWatchlistPlain(argument.toJava()).await())
    }

    /**
     * @see [getWatchlist].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetWatchlistPlainArgs].
     * @return Represents a Watchlist in Azure Security Insights.
     */
    public suspend fun getWatchlist(argument: suspend GetWatchlistPlainArgsBuilder.() -> Unit):
        GetWatchlistResult {
        val builder = GetWatchlistPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWatchlistResultToKotlin(getWatchlistPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a watchlist item.
     * Azure REST API version: 2023-02-01.
     * Other available API versions: 2021-04-01, 2023-06-01-preview, 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-11-01, 2023-12-01-preview.
     * @param argument null
     * @return Represents a Watchlist Item in Azure Security Insights.
     */
    public suspend fun getWatchlistItem(argument: GetWatchlistItemPlainArgs): GetWatchlistItemResult =
        getWatchlistItemResultToKotlin(getWatchlistItemPlain(argument.toJava()).await())

    /**
     * @see [getWatchlistItem].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param watchlistAlias The watchlist alias
     * @param watchlistItemId The watchlist item id (GUID)
     * @param workspaceName The name of the workspace.
     * @return Represents a Watchlist Item in Azure Security Insights.
     */
    public suspend fun getWatchlistItem(
        resourceGroupName: String,
        watchlistAlias: String,
        watchlistItemId: String,
        workspaceName: String,
    ): GetWatchlistItemResult {
        val argument = GetWatchlistItemPlainArgs(
            resourceGroupName = resourceGroupName,
            watchlistAlias = watchlistAlias,
            watchlistItemId = watchlistItemId,
            workspaceName = workspaceName,
        )
        return getWatchlistItemResultToKotlin(getWatchlistItemPlain(argument.toJava()).await())
    }

    /**
     * @see [getWatchlistItem].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetWatchlistItemPlainArgs].
     * @return Represents a Watchlist Item in Azure Security Insights.
     */
    public suspend
    fun getWatchlistItem(argument: suspend GetWatchlistItemPlainArgsBuilder.() -> Unit):
        GetWatchlistItemResult {
        val builder = GetWatchlistItemPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWatchlistItemResultToKotlin(getWatchlistItemPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a workspace manager assignment
     * Azure REST API version: 2023-06-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-12-01-preview.
     * @param argument null
     * @return The workspace manager assignment
     */
    public suspend
    fun getWorkspaceManagerAssignment(argument: GetWorkspaceManagerAssignmentPlainArgs):
        GetWorkspaceManagerAssignmentResult =
        getWorkspaceManagerAssignmentResultToKotlin(getWorkspaceManagerAssignmentPlain(argument.toJava()).await())

    /**
     * @see [getWorkspaceManagerAssignment].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceManagerAssignmentName The name of the workspace manager assignment
     * @param workspaceName The name of the workspace.
     * @return The workspace manager assignment
     */
    public suspend fun getWorkspaceManagerAssignment(
        resourceGroupName: String,
        workspaceManagerAssignmentName: String,
        workspaceName: String,
    ): GetWorkspaceManagerAssignmentResult {
        val argument = GetWorkspaceManagerAssignmentPlainArgs(
            resourceGroupName = resourceGroupName,
            workspaceManagerAssignmentName = workspaceManagerAssignmentName,
            workspaceName = workspaceName,
        )
        return getWorkspaceManagerAssignmentResultToKotlin(getWorkspaceManagerAssignmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspaceManagerAssignment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetWorkspaceManagerAssignmentPlainArgs].
     * @return The workspace manager assignment
     */
    public suspend
    fun getWorkspaceManagerAssignment(argument: suspend GetWorkspaceManagerAssignmentPlainArgsBuilder.() -> Unit):
        GetWorkspaceManagerAssignmentResult {
        val builder = GetWorkspaceManagerAssignmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceManagerAssignmentResultToKotlin(getWorkspaceManagerAssignmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a workspace manager configuration
     * Azure REST API version: 2023-06-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-12-01-preview.
     * @param argument null
     * @return The workspace manager configuration
     */
    public suspend
    fun getWorkspaceManagerConfiguration(argument: GetWorkspaceManagerConfigurationPlainArgs):
        GetWorkspaceManagerConfigurationResult =
        getWorkspaceManagerConfigurationResultToKotlin(getWorkspaceManagerConfigurationPlain(argument.toJava()).await())

    /**
     * @see [getWorkspaceManagerConfiguration].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceManagerConfigurationName The name of the workspace manager configuration
     * @param workspaceName The name of the workspace.
     * @return The workspace manager configuration
     */
    public suspend fun getWorkspaceManagerConfiguration(
        resourceGroupName: String,
        workspaceManagerConfigurationName: String,
        workspaceName: String,
    ): GetWorkspaceManagerConfigurationResult {
        val argument = GetWorkspaceManagerConfigurationPlainArgs(
            resourceGroupName = resourceGroupName,
            workspaceManagerConfigurationName = workspaceManagerConfigurationName,
            workspaceName = workspaceName,
        )
        return getWorkspaceManagerConfigurationResultToKotlin(getWorkspaceManagerConfigurationPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspaceManagerConfiguration].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetWorkspaceManagerConfigurationPlainArgs].
     * @return The workspace manager configuration
     */
    public suspend
    fun getWorkspaceManagerConfiguration(argument: suspend GetWorkspaceManagerConfigurationPlainArgsBuilder.() -> Unit):
        GetWorkspaceManagerConfigurationResult {
        val builder = GetWorkspaceManagerConfigurationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceManagerConfigurationResultToKotlin(getWorkspaceManagerConfigurationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a workspace manager group
     * Azure REST API version: 2023-06-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-12-01-preview.
     * @param argument null
     * @return The workspace manager group
     */
    public suspend fun getWorkspaceManagerGroup(argument: GetWorkspaceManagerGroupPlainArgs):
        GetWorkspaceManagerGroupResult =
        getWorkspaceManagerGroupResultToKotlin(getWorkspaceManagerGroupPlain(argument.toJava()).await())

    /**
     * @see [getWorkspaceManagerGroup].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceManagerGroupName The name of the workspace manager group
     * @param workspaceName The name of the workspace.
     * @return The workspace manager group
     */
    public suspend fun getWorkspaceManagerGroup(
        resourceGroupName: String,
        workspaceManagerGroupName: String,
        workspaceName: String,
    ): GetWorkspaceManagerGroupResult {
        val argument = GetWorkspaceManagerGroupPlainArgs(
            resourceGroupName = resourceGroupName,
            workspaceManagerGroupName = workspaceManagerGroupName,
            workspaceName = workspaceName,
        )
        return getWorkspaceManagerGroupResultToKotlin(getWorkspaceManagerGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspaceManagerGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetWorkspaceManagerGroupPlainArgs].
     * @return The workspace manager group
     */
    public suspend
    fun getWorkspaceManagerGroup(argument: suspend GetWorkspaceManagerGroupPlainArgsBuilder.() -> Unit):
        GetWorkspaceManagerGroupResult {
        val builder = GetWorkspaceManagerGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceManagerGroupResultToKotlin(getWorkspaceManagerGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a workspace manager member
     * Azure REST API version: 2023-06-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-12-01-preview.
     * @param argument null
     * @return The workspace manager member
     */
    public suspend fun getWorkspaceManagerMember(argument: GetWorkspaceManagerMemberPlainArgs):
        GetWorkspaceManagerMemberResult =
        getWorkspaceManagerMemberResultToKotlin(getWorkspaceManagerMemberPlain(argument.toJava()).await())

    /**
     * @see [getWorkspaceManagerMember].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceManagerMemberName The name of the workspace manager member
     * @param workspaceName The name of the workspace.
     * @return The workspace manager member
     */
    public suspend fun getWorkspaceManagerMember(
        resourceGroupName: String,
        workspaceManagerMemberName: String,
        workspaceName: String,
    ): GetWorkspaceManagerMemberResult {
        val argument = GetWorkspaceManagerMemberPlainArgs(
            resourceGroupName = resourceGroupName,
            workspaceManagerMemberName = workspaceManagerMemberName,
            workspaceName = workspaceName,
        )
        return getWorkspaceManagerMemberResultToKotlin(getWorkspaceManagerMemberPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspaceManagerMember].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;GetWorkspaceManagerMemberPlainArgs].
     * @return The workspace manager member
     */
    public suspend
    fun getWorkspaceManagerMember(argument: suspend GetWorkspaceManagerMemberPlainArgsBuilder.() -> Unit):
        GetWorkspaceManagerMemberResult {
        val builder = GetWorkspaceManagerMemberPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceManagerMemberResultToKotlin(getWorkspaceManagerMemberPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a list of repositories metadata.
     * Azure REST API version: 2023-06-01-preview.
     * Other available API versions: 2021-03-01-preview, 2021-09-01-preview, 2021-10-01-preview, 2022-01-01-preview, 2022-04-01-preview, 2022-05-01-preview, 2022-06-01-preview, 2022-07-01-preview, 2022-08-01-preview, 2022-09-01-preview, 2022-10-01-preview, 2022-11-01-preview, 2022-12-01-preview, 2023-02-01-preview, 2023-03-01-preview, 2023-04-01-preview, 2023-05-01-preview, 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-11-01, 2023-12-01-preview.
     * @param argument null
     * @return List all the source controls.
     */
    public suspend
    fun listSourceControlRepositories(argument: ListSourceControlRepositoriesPlainArgs):
        ListSourceControlRepositoriesResult =
        listSourceControlRepositoriesResultToKotlin(listSourceControlRepositoriesPlain(argument.toJava()).await())

    /**
     * @see [listSourceControlRepositories].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return List all the source controls.
     */
    public suspend fun listSourceControlRepositories(
        resourceGroupName: String,
        workspaceName: String,
    ): ListSourceControlRepositoriesResult {
        val argument = ListSourceControlRepositoriesPlainArgs(
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return listSourceControlRepositoriesResultToKotlin(listSourceControlRepositoriesPlain(argument.toJava()).await())
    }

    /**
     * @see [listSourceControlRepositories].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;securityinsights&#46;kotlin&#46;inputs&#46;ListSourceControlRepositoriesPlainArgs].
     * @return List all the source controls.
     */
    public suspend
    fun listSourceControlRepositories(argument: suspend ListSourceControlRepositoriesPlainArgsBuilder.() -> Unit):
        ListSourceControlRepositoriesResult {
        val builder = ListSourceControlRepositoriesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listSourceControlRepositoriesResultToKotlin(listSourceControlRepositoriesPlain(builtArgument.toJava()).await())
    }
}
