@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SentinelOnboardingState].
 */
@PulumiTagMarker
public class SentinelOnboardingStateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SentinelOnboardingStateArgs = SentinelOnboardingStateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SentinelOnboardingStateArgsBuilder.() -> Unit) {
        val builder = SentinelOnboardingStateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SentinelOnboardingState {
        val builtJavaResource =
            com.pulumi.azurenative.securityinsights.SentinelOnboardingState(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SentinelOnboardingState(builtJavaResource)
    }
}

/**
 * Sentinel onboarding state
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * Other available API versions: 2021-03-01-preview, 2023-06-01-preview, 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-11-01, 2023-12-01-preview.
 * ## Example Usage
 * ### Create Sentinel onboarding state
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sentinelOnboardingState = new AzureNative.SecurityInsights.SentinelOnboardingState("sentinelOnboardingState", new()
 *     {
 *         CustomerManagedKey = false,
 *         ResourceGroupName = "myRg",
 *         SentinelOnboardingStateName = "default",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewSentinelOnboardingState(ctx, "sentinelOnboardingState", &securityinsights.SentinelOnboardingStateArgs{
 * 			CustomerManagedKey:          pulumi.Bool(false),
 * 			ResourceGroupName:           pulumi.String("myRg"),
 * 			SentinelOnboardingStateName: pulumi.String("default"),
 * 			WorkspaceName:               pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.SentinelOnboardingState;
 * import com.pulumi.azurenative.securityinsights.SentinelOnboardingStateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sentinelOnboardingState = new SentinelOnboardingState("sentinelOnboardingState", SentinelOnboardingStateArgs.builder()
 *             .customerManagedKey(false)
 *             .resourceGroupName("myRg")
 *             .sentinelOnboardingStateName("default")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:SentinelOnboardingState default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/onboardingStates/{sentinelOnboardingStateName}
 * ```
 */
public class SentinelOnboardingState internal constructor(
    override val javaResource: com.pulumi.azurenative.securityinsights.SentinelOnboardingState,
) : KotlinCustomResource(javaResource, SentinelOnboardingStateMapper) {
    /**
     * Flag that indicates the status of the CMK setting
     */
    public val customerManagedKey: Output<Boolean>?
        get() = javaResource.customerManagedKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Etag of the azure resource
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SentinelOnboardingStateMapper : ResourceMapper<SentinelOnboardingState> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.securityinsights.SentinelOnboardingState::class == javaResource::class

    override fun map(javaResource: Resource): SentinelOnboardingState =
        SentinelOnboardingState(
            javaResource as
                com.pulumi.azurenative.securityinsights.SentinelOnboardingState,
        )
}

/**
 * @see [SentinelOnboardingState].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SentinelOnboardingState].
 */
public suspend fun sentinelOnboardingState(
    name: String,
    block: suspend SentinelOnboardingStateResourceBuilder.() -> Unit,
): SentinelOnboardingState {
    val builder = SentinelOnboardingStateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SentinelOnboardingState].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sentinelOnboardingState(name: String): SentinelOnboardingState {
    val builder = SentinelOnboardingStateResourceBuilder()
    builder.name(name)
    return builder.build()
}
