@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.SourceControlArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.enums.ContentType
import com.pulumi.azurenative.securityinsights.kotlin.enums.RepoType
import com.pulumi.azurenative.securityinsights.kotlin.enums.Version
import com.pulumi.azurenative.securityinsights.kotlin.inputs.DeploymentInfoArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.DeploymentInfoArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.RepositoryArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.RepositoryArgsBuilder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.RepositoryResourceInfoArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.RepositoryResourceInfoArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Represents a SourceControl in Azure Security Insights.
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * Other available API versions: 2021-03-01-preview.
 * ## Example Usage
 * ### Creates a source control.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sourceControl = new AzureNative.SecurityInsights.SourceControl("sourceControl", new()
 *     {
 *         ContentTypes = new[]
 *         {
 *             "AnalyticRules",
 *             "Workbook",
 *         },
 *         Description = "This is a source control",
 *         DisplayName = "My Source Control",
 *         RepoType = "Github",
 *         Repository = new AzureNative.SecurityInsights.Inputs.RepositoryArgs
 *         {
 *             Branch = "master",
 *             DisplayUrl = "https://github.com/user/repo",
 *             PathMapping = new[]
 *             {
 *                 new AzureNative.SecurityInsights.Inputs.ContentPathMapArgs
 *                 {
 *                     ContentType = "AnalyticRules",
 *                     Path = "path/to/rules",
 *                 },
 *                 new AzureNative.SecurityInsights.Inputs.ContentPathMapArgs
 *                 {
 *                     ContentType = "Workbook",
 *                     Path = "path/to/workbooks",
 *                 },
 *             },
 *             Url = "https://github.com/user/repo",
 *         },
 *         ResourceGroupName = "myRg",
 *         SourceControlId = "789e0c1f-4a3d-43ad-809c-e713b677b04a",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewSourceControl(ctx, "sourceControl", &securityinsights.SourceControlArgs{
 * 			ContentTypes: pulumi.StringArray{
 * 				pulumi.String("AnalyticRules"),
 * 				pulumi.String("Workbook"),
 * 			},
 * 			Description: pulumi.String("This is a source control"),
 * 			DisplayName: pulumi.String("My Source Control"),
 * 			RepoType:    pulumi.String("Github"),
 * 			Repository: securityinsights.RepositoryResponse{
 * 				Branch:     pulumi.String("master"),
 * 				DisplayUrl: pulumi.String("https://github.com/user/repo"),
 * 				PathMapping: securityinsights.ContentPathMapArray{
 * 					&securityinsights.ContentPathMapArgs{
 * 						ContentType: pulumi.String("AnalyticRules"),
 * 						Path:        pulumi.String("path/to/rules"),
 * 					},
 * 					&securityinsights.ContentPathMapArgs{
 * 						ContentType: pulumi.String("Workbook"),
 * 						Path:        pulumi.String("path/to/workbooks"),
 * 					},
 * 				},
 * 				Url: pulumi.String("https://github.com/user/repo"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myRg"),
 * 			SourceControlId:   pulumi.String("789e0c1f-4a3d-43ad-809c-e713b677b04a"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.SourceControl;
 * import com.pulumi.azurenative.securityinsights.SourceControlArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sourceControl = new SourceControl("sourceControl", SourceControlArgs.builder()
 *             .contentTypes(
 *                 "AnalyticRules",
 *                 "Workbook")
 *             .description("This is a source control")
 *             .displayName("My Source Control")
 *             .repoType("Github")
 *             .repository(Map.ofEntries(
 *                 Map.entry("branch", "master"),
 *                 Map.entry("displayUrl", "https://github.com/user/repo"),
 *                 Map.entry("pathMapping",
 *                     Map.ofEntries(
 *                         Map.entry("contentType", "AnalyticRules"),
 *                         Map.entry("path", "path/to/rules")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("contentType", "Workbook"),
 *                         Map.entry("path", "path/to/workbooks")
 *                     )),
 *                 Map.entry("url", "https://github.com/user/repo")
 *             ))
 *             .resourceGroupName("myRg")
 *             .sourceControlId("789e0c1f-4a3d-43ad-809c-e713b677b04a")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:SourceControl 789e0c1f-4a3d-43ad-809c-e713b677b04a /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/sourcecontrols/{sourceControlId}
 * ```
 * @property contentTypes Array of source control content types.
 * @property description A description of the source control
 * @property displayName The display name of the source control
 * @property id The id (a Guid) of the source control
 * @property lastDeploymentInfo Information regarding the latest deployment for the source control.
 * @property repoType The repository type of the source control
 * @property repository Repository metadata.
 * @property repositoryResourceInfo Information regarding the resources created in user's repository.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sourceControlId Source control Id
 * @property version The version number associated with the source control
 * @property workspaceName The name of the workspace.
 */
public data class SourceControlArgs(
    public val contentTypes: Output<List<Either<String, ContentType>>>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val id: Output<String>? = null,
    public val lastDeploymentInfo: Output<DeploymentInfoArgs>? = null,
    public val repoType: Output<Either<String, RepoType>>? = null,
    public val repository: Output<RepositoryArgs>? = null,
    public val repositoryResourceInfo: Output<RepositoryResourceInfoArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sourceControlId: Output<String>? = null,
    public val version: Output<Either<String, Version>>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.SourceControlArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.SourceControlArgs =
        com.pulumi.azurenative.securityinsights.SourceControlArgs.builder()
            .contentTypes(
                contentTypes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0
                        }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .lastDeploymentInfo(
                lastDeploymentInfo?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .repoType(
                repoType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .repository(repository?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .repositoryResourceInfo(
                repositoryResourceInfo?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sourceControlId(sourceControlId?.applyValue({ args0 -> args0 }))
            .version(
                version?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SourceControlArgs].
 */
@PulumiTagMarker
public class SourceControlArgsBuilder internal constructor() {
    private var contentTypes: Output<List<Either<String, ContentType>>>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var id: Output<String>? = null

    private var lastDeploymentInfo: Output<DeploymentInfoArgs>? = null

    private var repoType: Output<Either<String, RepoType>>? = null

    private var repository: Output<RepositoryArgs>? = null

    private var repositoryResourceInfo: Output<RepositoryResourceInfoArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sourceControlId: Output<String>? = null

    private var version: Output<Either<String, Version>>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Array of source control content types.
     */
    @JvmName("oejyjpgogbvedaqe")
    public suspend fun contentTypes(`value`: Output<List<Either<String, ContentType>>>) {
        this.contentTypes = value
    }

    @JvmName("twnjjnrgxwmkdrml")
    public suspend fun contentTypes(vararg values: Output<Either<String, ContentType>>) {
        this.contentTypes = Output.all(values.asList())
    }

    /**
     * @param values Array of source control content types.
     */
    @JvmName("ffnsyyatfvsqxmyo")
    public suspend fun contentTypes(values: List<Output<Either<String, ContentType>>>) {
        this.contentTypes = Output.all(values)
    }

    /**
     * @param value A description of the source control
     */
    @JvmName("kyvbaqrcaflamdsv")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The display name of the source control
     */
    @JvmName("spgclsapbbxwbowx")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The id (a Guid) of the source control
     */
    @JvmName("xwselncmsvjkpuwf")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Information regarding the latest deployment for the source control.
     */
    @JvmName("biwatakientwcuri")
    public suspend fun lastDeploymentInfo(`value`: Output<DeploymentInfoArgs>) {
        this.lastDeploymentInfo = value
    }

    /**
     * @param value The repository type of the source control
     */
    @JvmName("rrwiayhuvhoitljk")
    public suspend fun repoType(`value`: Output<Either<String, RepoType>>) {
        this.repoType = value
    }

    /**
     * @param value Repository metadata.
     */
    @JvmName("nlwjjblhwkntoxac")
    public suspend fun repository(`value`: Output<RepositoryArgs>) {
        this.repository = value
    }

    /**
     * @param value Information regarding the resources created in user's repository.
     */
    @JvmName("sxoijsvbvskkruru")
    public suspend fun repositoryResourceInfo(`value`: Output<RepositoryResourceInfoArgs>) {
        this.repositoryResourceInfo = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vyifwwfncikmebkb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Source control Id
     */
    @JvmName("vlqnxdctyfaemnhu")
    public suspend fun sourceControlId(`value`: Output<String>) {
        this.sourceControlId = value
    }

    /**
     * @param value The version number associated with the source control
     */
    @JvmName("gobvxrykhtilvxcr")
    public suspend fun version(`value`: Output<Either<String, Version>>) {
        this.version = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("iptjkimstschtvpq")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Array of source control content types.
     */
    @JvmName("qqcihdwcioaclpkf")
    public suspend fun contentTypes(`value`: List<Either<String, ContentType>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentTypes = mapped
    }

    /**
     * @param values Array of source control content types.
     */
    @JvmName("thuqfregivsplfsq")
    public suspend fun contentTypes(vararg values: Either<String, ContentType>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentTypes = mapped
    }

    /**
     * @param value A description of the source control
     */
    @JvmName("usttmeuuckydsnvl")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The display name of the source control
     */
    @JvmName("eypiuabcorkmfncm")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The id (a Guid) of the source control
     */
    @JvmName("mafhebhebktabpjj")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Information regarding the latest deployment for the source control.
     */
    @JvmName("lauvnrhtbyasdgsm")
    public suspend fun lastDeploymentInfo(`value`: DeploymentInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastDeploymentInfo = mapped
    }

    /**
     * @param argument Information regarding the latest deployment for the source control.
     */
    @JvmName("ucutfihfikyxewas")
    public suspend fun lastDeploymentInfo(argument: suspend DeploymentInfoArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.lastDeploymentInfo = mapped
    }

    /**
     * @param value The repository type of the source control
     */
    @JvmName("dtnkanpibkflwpxa")
    public suspend fun repoType(`value`: Either<String, RepoType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repoType = mapped
    }

    /**
     * @param value The repository type of the source control
     */
    @JvmName("vckerescjinwllnc")
    public fun repoType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RepoType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repoType = mapped
    }

    /**
     * @param value The repository type of the source control
     */
    @JvmName("skcwqojdnolbpbia")
    public fun repoType(`value`: RepoType) {
        val toBeMapped = Either.ofRight<String, RepoType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repoType = mapped
    }

    /**
     * @param value Repository metadata.
     */
    @JvmName("dgtasuioyfchkohm")
    public suspend fun repository(`value`: RepositoryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repository = mapped
    }

    /**
     * @param argument Repository metadata.
     */
    @JvmName("dldalkknoqyaxqps")
    public suspend fun repository(argument: suspend RepositoryArgsBuilder.() -> Unit) {
        val toBeMapped = RepositoryArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.repository = mapped
    }

    /**
     * @param value Information regarding the resources created in user's repository.
     */
    @JvmName("efougnkwuuafhqtm")
    public suspend fun repositoryResourceInfo(`value`: RepositoryResourceInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repositoryResourceInfo = mapped
    }

    /**
     * @param argument Information regarding the resources created in user's repository.
     */
    @JvmName("xovikgvixfxagyqb")
    public suspend
    fun repositoryResourceInfo(argument: suspend RepositoryResourceInfoArgsBuilder.() -> Unit) {
        val toBeMapped = RepositoryResourceInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.repositoryResourceInfo = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("igmabchuftehkobn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Source control Id
     */
    @JvmName("ekisxcjvavlphbpw")
    public suspend fun sourceControlId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceControlId = mapped
    }

    /**
     * @param value The version number associated with the source control
     */
    @JvmName("cytbnvcgvxrjmkux")
    public suspend fun version(`value`: Either<String, Version>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param value The version number associated with the source control
     */
    @JvmName("eyedfndjfwjitnkq")
    public fun version(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Version>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param value The version number associated with the source control
     */
    @JvmName("gkbetrpruqicioen")
    public fun version(`value`: Version) {
        val toBeMapped = Either.ofRight<String, Version>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("qamffuuvsiblefmc")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): SourceControlArgs = SourceControlArgs(
        contentTypes = contentTypes,
        description = description,
        displayName = displayName,
        id = id,
        lastDeploymentInfo = lastDeploymentInfo,
        repoType = repoType,
        repository = repository,
        repositoryResourceInfo = repositoryResourceInfo,
        resourceGroupName = resourceGroupName,
        sourceControlId = sourceControlId,
        version = version,
        workspaceName = workspaceName,
    )
}
