@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.WorkspaceManagerAssignmentArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.inputs.AssignmentItemArgs
import com.pulumi.azurenative.securityinsights.kotlin.inputs.AssignmentItemArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The workspace manager assignment
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-12-01-preview.
 * ## Example Usage
 * ### Creates or updates a workspace manager assignment.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceManagerAssignment = new AzureNative.SecurityInsights.WorkspaceManagerAssignment("workspaceManagerAssignment", new()
 *     {
 *         Items = new[]
 *         {
 *             new AzureNative.SecurityInsights.Inputs.AssignmentItemArgs
 *             {
 *                 ResourceId = "/subscriptions/d0cfe6b2-9ac0-4464-9919-dccaee2e48c0/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspac-es/myWorkspace/providers/Microsoft.SecurityInsights/alertRules/microsoftSecurityIncidentCreationRuleExampleOne",
 *             },
 *             new AzureNative.SecurityInsights.Inputs.AssignmentItemArgs
 *             {
 *                 ResourceId = "/subscriptions/d0cfe6b2-9ac0-4464-9919-dccaee2e48c0/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspac-es/myWorkspace/providers/Microsoft.SecurityInsights/alertRules/microsoftSecurityIncidentCreationRuleExampleTwo",
 *             },
 *         },
 *         ResourceGroupName = "myRg",
 *         TargetResourceName = "37207a7a-3b8a-438f-a559-c7df400e1b96",
 *         WorkspaceManagerAssignmentName = "47cdc5f5-37c4-47b5-bd5f-83c84b8bdd58",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewWorkspaceManagerAssignment(ctx, "workspaceManagerAssignment", &securityinsights.WorkspaceManagerAssignmentArgs{
 * 			Items: []securityinsights.AssignmentItemArgs{
 * 				{
 * 					ResourceId: pulumi.String("/subscriptions/d0cfe6b2-9ac0-4464-9919-dccaee2e48c0/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspac-es/myWorkspace/providers/Microsoft.SecurityInsights/alertRules/microsoftSecurityIncidentCreationRuleExampleOne"),
 * 				},
 * 				{
 * 					ResourceId: pulumi.String("/subscriptions/d0cfe6b2-9ac0-4464-9919-dccaee2e48c0/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspac-es/myWorkspace/providers/Microsoft.SecurityInsights/alertRules/microsoftSecurityIncidentCreationRuleExampleTwo"),
 * 				},
 * 			},
 * 			ResourceGroupName:              pulumi.String("myRg"),
 * 			TargetResourceName:             pulumi.String("37207a7a-3b8a-438f-a559-c7df400e1b96"),
 * 			WorkspaceManagerAssignmentName: pulumi.String("47cdc5f5-37c4-47b5-bd5f-83c84b8bdd58"),
 * 			WorkspaceName:                  pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.WorkspaceManagerAssignment;
 * import com.pulumi.azurenative.securityinsights.WorkspaceManagerAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceManagerAssignment = new WorkspaceManagerAssignment("workspaceManagerAssignment", WorkspaceManagerAssignmentArgs.builder()
 *             .items(
 *                 Map.of("resourceId", "/subscriptions/d0cfe6b2-9ac0-4464-9919-dccaee2e48c0/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspac-es/myWorkspace/providers/Microsoft.SecurityInsights/alertRules/microsoftSecurityIncidentCreationRuleExampleOne"),
 *                 Map.of("resourceId", "/subscriptions/d0cfe6b2-9ac0-4464-9919-dccaee2e48c0/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspac-es/myWorkspace/providers/Microsoft.SecurityInsights/alertRules/microsoftSecurityIncidentCreationRuleExampleTwo"))
 *             .resourceGroupName("myRg")
 *             .targetResourceName("37207a7a-3b8a-438f-a559-c7df400e1b96")
 *             .workspaceManagerAssignmentName("47cdc5f5-37c4-47b5-bd5f-83c84b8bdd58")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:WorkspaceManagerAssignment 47cdc5f5-37c4-47b5-bd5f-83c84b8bdd58 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/workspaceManagerAssignments/{workspaceManagerAssignmentName}
 * ```
 * @property items List of resources included in this workspace manager assignment
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property targetResourceName The resource name of the workspace manager group targeted by the workspace manager assignment
 * @property workspaceManagerAssignmentName The name of the workspace manager assignment
 * @property workspaceName The name of the workspace.
 */
public data class WorkspaceManagerAssignmentArgs(
    public val items: Output<List<AssignmentItemArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val targetResourceName: Output<String>? = null,
    public val workspaceManagerAssignmentName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.WorkspaceManagerAssignmentArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.WorkspaceManagerAssignmentArgs =
        com.pulumi.azurenative.securityinsights.WorkspaceManagerAssignmentArgs.builder()
            .items(items?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .targetResourceName(targetResourceName?.applyValue({ args0 -> args0 }))
            .workspaceManagerAssignmentName(workspaceManagerAssignmentName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceManagerAssignmentArgs].
 */
@PulumiTagMarker
public class WorkspaceManagerAssignmentArgsBuilder internal constructor() {
    private var items: Output<List<AssignmentItemArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var targetResourceName: Output<String>? = null

    private var workspaceManagerAssignmentName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value List of resources included in this workspace manager assignment
     */
    @JvmName("akxrvpfpmgbcidrl")
    public suspend fun items(`value`: Output<List<AssignmentItemArgs>>) {
        this.items = value
    }

    @JvmName("auxmcsijfchgyypg")
    public suspend fun items(vararg values: Output<AssignmentItemArgs>) {
        this.items = Output.all(values.asList())
    }

    /**
     * @param values List of resources included in this workspace manager assignment
     */
    @JvmName("efclpbelyeyygmsh")
    public suspend fun items(values: List<Output<AssignmentItemArgs>>) {
        this.items = Output.all(values)
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dyooeuqqxjhcryea")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The resource name of the workspace manager group targeted by the workspace manager assignment
     */
    @JvmName("otujqfaaqrxaiwyu")
    public suspend fun targetResourceName(`value`: Output<String>) {
        this.targetResourceName = value
    }

    /**
     * @param value The name of the workspace manager assignment
     */
    @JvmName("ugqvafmhjoxtffac")
    public suspend fun workspaceManagerAssignmentName(`value`: Output<String>) {
        this.workspaceManagerAssignmentName = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("yndykqasundsebut")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value List of resources included in this workspace manager assignment
     */
    @JvmName("cigmbyacjvnkenyk")
    public suspend fun items(`value`: List<AssignmentItemArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.items = mapped
    }

    /**
     * @param argument List of resources included in this workspace manager assignment
     */
    @JvmName("vdqaamlgnugbehan")
    public suspend fun items(argument: List<suspend AssignmentItemArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AssignmentItemArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.items = mapped
    }

    /**
     * @param argument List of resources included in this workspace manager assignment
     */
    @JvmName("anhlppnqnoqodcnp")
    public suspend fun items(vararg argument: suspend AssignmentItemArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AssignmentItemArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.items = mapped
    }

    /**
     * @param argument List of resources included in this workspace manager assignment
     */
    @JvmName("olxwefyxjrtjigxb")
    public suspend fun items(argument: suspend AssignmentItemArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AssignmentItemArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.items = mapped
    }

    /**
     * @param values List of resources included in this workspace manager assignment
     */
    @JvmName("bcggnyykknjeucca")
    public suspend fun items(vararg values: AssignmentItemArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.items = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vphchpaysilrubwn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The resource name of the workspace manager group targeted by the workspace manager assignment
     */
    @JvmName("xcvsqbisjwccwprm")
    public suspend fun targetResourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetResourceName = mapped
    }

    /**
     * @param value The name of the workspace manager assignment
     */
    @JvmName("snadukcreswnjpoj")
    public suspend fun workspaceManagerAssignmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceManagerAssignmentName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("gmcpewbxyamioton")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): WorkspaceManagerAssignmentArgs = WorkspaceManagerAssignmentArgs(
        items = items,
        resourceGroupName = resourceGroupName,
        targetResourceName = targetResourceName,
        workspaceManagerAssignmentName = workspaceManagerAssignmentName,
        workspaceName = workspaceName,
    )
}
