@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin

import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WorkspaceManagerMember].
 */
@PulumiTagMarker
public class WorkspaceManagerMemberResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkspaceManagerMemberArgs = WorkspaceManagerMemberArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkspaceManagerMemberArgsBuilder.() -> Unit) {
        val builder = WorkspaceManagerMemberArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): WorkspaceManagerMember {
        val builtJavaResource =
            com.pulumi.azurenative.securityinsights.WorkspaceManagerMember(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WorkspaceManagerMember(builtJavaResource)
    }
}

/**
 * The workspace manager member
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-08-01-preview, 2023-09-01-preview, 2023-10-01-preview, 2023-12-01-preview.
 * ## Example Usage
 * ### Create or Update a workspace manager member
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceManagerMember = new AzureNative.SecurityInsights.WorkspaceManagerMember("workspaceManagerMember", new()
 *     {
 *         ResourceGroupName = "myRg",
 *         TargetWorkspaceResourceId = "/subscriptions/7aef9d48-814f-45ad-b644-b0343316e174/resourceGroups/otherRg/providers/Microsoft.OperationalInsights/workspaces/Example_Workspace",
 *         TargetWorkspaceTenantId = "f676d436-8d16-42db-81b7-ab578e110ccd",
 *         WorkspaceManagerMemberName = "afbd324f-6c48-459c-8710-8d1e1cd03812",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/securityinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityinsights.NewWorkspaceManagerMember(ctx, "workspaceManagerMember", &securityinsights.WorkspaceManagerMemberArgs{
 * 			ResourceGroupName:          pulumi.String("myRg"),
 * 			TargetWorkspaceResourceId:  pulumi.String("/subscriptions/7aef9d48-814f-45ad-b644-b0343316e174/resourceGroups/otherRg/providers/Microsoft.OperationalInsights/workspaces/Example_Workspace"),
 * 			TargetWorkspaceTenantId:    pulumi.String("f676d436-8d16-42db-81b7-ab578e110ccd"),
 * 			WorkspaceManagerMemberName: pulumi.String("afbd324f-6c48-459c-8710-8d1e1cd03812"),
 * 			WorkspaceName:              pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.securityinsights.WorkspaceManagerMember;
 * import com.pulumi.azurenative.securityinsights.WorkspaceManagerMemberArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceManagerMember = new WorkspaceManagerMember("workspaceManagerMember", WorkspaceManagerMemberArgs.builder()
 *             .resourceGroupName("myRg")
 *             .targetWorkspaceResourceId("/subscriptions/7aef9d48-814f-45ad-b644-b0343316e174/resourceGroups/otherRg/providers/Microsoft.OperationalInsights/workspaces/Example_Workspace")
 *             .targetWorkspaceTenantId("f676d436-8d16-42db-81b7-ab578e110ccd")
 *             .workspaceManagerMemberName("afbd324f-6c48-459c-8710-8d1e1cd03812")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:securityinsights:WorkspaceManagerMember afbd324f-6c48-459c-8710-8d1e1cd03812 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/workspaceManagerMembers/{workspaceManagerMemberName}
 * ```
 */
public class WorkspaceManagerMember internal constructor(
    override val javaResource: com.pulumi.azurenative.securityinsights.WorkspaceManagerMember,
) : KotlinCustomResource(javaResource, WorkspaceManagerMemberMapper) {
    /**
     * Resource Etag.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Fully qualified resource ID of the target Sentinel workspace joining the given Sentinel workspace manager
     */
    public val targetWorkspaceResourceId: Output<String>
        get() = javaResource.targetWorkspaceResourceId().applyValue({ args0 -> args0 })

    /**
     * Tenant id of the target Sentinel workspace joining the given Sentinel workspace manager
     */
    public val targetWorkspaceTenantId: Output<String>
        get() = javaResource.targetWorkspaceTenantId().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WorkspaceManagerMemberMapper : ResourceMapper<WorkspaceManagerMember> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.securityinsights.WorkspaceManagerMember::class == javaResource::class

    override fun map(javaResource: Resource): WorkspaceManagerMember =
        WorkspaceManagerMember(
            javaResource as
                com.pulumi.azurenative.securityinsights.WorkspaceManagerMember,
        )
}

/**
 * @see [WorkspaceManagerMember].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WorkspaceManagerMember].
 */
public suspend fun workspaceManagerMember(
    name: String,
    block: suspend WorkspaceManagerMemberResourceBuilder.() -> Unit,
): WorkspaceManagerMember {
    val builder = WorkspaceManagerMemberResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WorkspaceManagerMember].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workspaceManagerMember(name: String): WorkspaceManagerMember {
    val builder = WorkspaceManagerMemberResourceBuilder()
    builder.name(name)
    return builder.build()
}
