@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The content type of this file.
 */
public enum class FileImportContentType(
    public val javaValue: com.pulumi.azurenative.securityinsights.enums.FileImportContentType,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.enums.FileImportContentType> {
    /**
     * File containing records with the core fields of an indicator, plus the observables to construct the STIX pattern.
     */
    BasicIndicator(com.pulumi.azurenative.securityinsights.enums.FileImportContentType.BasicIndicator),

    /**
     * File containing STIX indicators.
     */
    StixIndicator(com.pulumi.azurenative.securityinsights.enums.FileImportContentType.StixIndicator),

    /**
     * File containing other records.
     */
    Unspecified(com.pulumi.azurenative.securityinsights.enums.FileImportContentType.Unspecified),
    ;

    override fun toJava(): com.pulumi.azurenative.securityinsights.enums.FileImportContentType =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.enums.FileImportContentType):
            FileImportContentType = FileImportContentType.values().first { it.javaValue == javaType }
    }
}
