@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The severity of the incident
 */
public enum class IncidentSeverity(
    public val javaValue: com.pulumi.azurenative.securityinsights.enums.IncidentSeverity,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.enums.IncidentSeverity> {
    /**
     * High severity
     */
    High(com.pulumi.azurenative.securityinsights.enums.IncidentSeverity.High),

    /**
     * Medium severity
     */
    Medium(com.pulumi.azurenative.securityinsights.enums.IncidentSeverity.Medium),

    /**
     * Low severity
     */
    Low(com.pulumi.azurenative.securityinsights.enums.IncidentSeverity.Low),

    /**
     * Informational severity
     */
    Informational(com.pulumi.azurenative.securityinsights.enums.IncidentSeverity.Informational),
    ;

    override fun toJava(): com.pulumi.azurenative.securityinsights.enums.IncidentSeverity = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.enums.IncidentSeverity):
            IncidentSeverity = IncidentSeverity.values().first { it.javaValue == javaType }
    }
}
