@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The status of the incident
 */
public enum class IncidentStatus(
    public val javaValue: com.pulumi.azurenative.securityinsights.enums.IncidentStatus,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.enums.IncidentStatus> {
    /**
     * An active incident which isn't being handled currently
     */
    New(com.pulumi.azurenative.securityinsights.enums.IncidentStatus.New),

    /**
     * An active incident which is being handled
     */
    Active(com.pulumi.azurenative.securityinsights.enums.IncidentStatus.Active),

    /**
     * A non-active incident
     */
    Closed(com.pulumi.azurenative.securityinsights.enums.IncidentStatus.Closed),
    ;

    override fun toJava(): com.pulumi.azurenative.securityinsights.enums.IncidentStatus = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.enums.IncidentStatus):
            IncidentStatus = IncidentStatus.values().first { it.javaValue == javaType }
    }
}
