@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Grouping matching method. When method is Selected at least one of groupByEntities, groupByAlertDetails, groupByCustomDetails must be provided and not empty.
 */
public enum class MatchingMethod(
    public val javaValue: com.pulumi.azurenative.securityinsights.enums.MatchingMethod,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.enums.MatchingMethod> {
    /**
     * Grouping alerts into a single incident if all the entities match
     */
    AllEntities(com.pulumi.azurenative.securityinsights.enums.MatchingMethod.AllEntities),

    /**
     * Grouping any alerts triggered by this rule into a single incident
     */
    AnyAlert(com.pulumi.azurenative.securityinsights.enums.MatchingMethod.AnyAlert),

    /**
     * Grouping alerts into a single incident if the selected entities, custom details and alert details match
     */
    Selected(com.pulumi.azurenative.securityinsights.enums.MatchingMethod.Selected),
    ;

    override fun toJava(): com.pulumi.azurenative.securityinsights.enums.MatchingMethod = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.enums.MatchingMethod):
            MatchingMethod = MatchingMethod.values().first { it.javaValue == javaType }
    }
}
