@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The current mode of the workspace manager configuration
 */
public enum class Mode(
    public val javaValue: com.pulumi.azurenative.securityinsights.enums.Mode,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.enums.Mode> {
    /**
     * The workspace manager configuration is enabled
     */
    Enabled(com.pulumi.azurenative.securityinsights.enums.Mode.Enabled),

    /**
     * The workspace manager configuration is disabled
     */
    Disabled(com.pulumi.azurenative.securityinsights.enums.Mode.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.securityinsights.enums.Mode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.enums.Mode): Mode =
            Mode.values().first { it.javaValue == javaType }
    }
}
