@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The anomaly SecurityMLAnalyticsSettings status
 */
public enum class SettingsStatus(
    public val javaValue: com.pulumi.azurenative.securityinsights.enums.SettingsStatus,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.enums.SettingsStatus> {
    /**
     * Anomaly settings status in Production mode
     */
    Production(com.pulumi.azurenative.securityinsights.enums.SettingsStatus.Production),

    /**
     * Anomaly settings status in Flighting mode
     */
    Flighting(com.pulumi.azurenative.securityinsights.enums.SettingsStatus.Flighting),
    ;

    override fun toJava(): com.pulumi.azurenative.securityinsights.enums.SettingsStatus = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.enums.SettingsStatus):
            SettingsStatus = SettingsStatus.values().first { it.javaValue == javaType }
    }
}
