@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.AutomationRulePropertyArrayChangedValuesConditionArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.enums.AutomationRulePropertyArrayChangedConditionSupportedArrayType
import com.pulumi.azurenative.securityinsights.kotlin.enums.AutomationRulePropertyArrayChangedConditionSupportedChangeType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property arrayType
 * @property changeType
 */
public data class AutomationRulePropertyArrayChangedValuesConditionArgs(
    public val arrayType:
    Output<Either<String, AutomationRulePropertyArrayChangedConditionSupportedArrayType>>? = null,
    public val changeType:
    Output<Either<String, AutomationRulePropertyArrayChangedConditionSupportedChangeType>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.AutomationRulePropertyArrayChangedValuesConditionArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityinsights.inputs.AutomationRulePropertyArrayChangedValuesConditionArgs =
        com.pulumi.azurenative.securityinsights.inputs.AutomationRulePropertyArrayChangedValuesConditionArgs.builder()
            .arrayType(
                arrayType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .changeType(
                changeType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [AutomationRulePropertyArrayChangedValuesConditionArgs].
 */
@PulumiTagMarker
public class AutomationRulePropertyArrayChangedValuesConditionArgsBuilder internal constructor() {
    private var arrayType:
        Output<Either<String, AutomationRulePropertyArrayChangedConditionSupportedArrayType>>? = null

    private var changeType:
        Output<Either<String, AutomationRulePropertyArrayChangedConditionSupportedChangeType>>? = null

    /**
     * @param value
     */
    @JvmName("rvssoujxymxjoubt")
    public suspend
    fun arrayType(`value`: Output<Either<String, AutomationRulePropertyArrayChangedConditionSupportedArrayType>>) {
        this.arrayType = value
    }

    /**
     * @param value
     */
    @JvmName("yslfynoeyehnsihj")
    public suspend
    fun changeType(`value`: Output<Either<String, AutomationRulePropertyArrayChangedConditionSupportedChangeType>>) {
        this.changeType = value
    }

    /**
     * @param value
     */
    @JvmName("knwodgbnhwihjtqs")
    public suspend
    fun arrayType(`value`: Either<String, AutomationRulePropertyArrayChangedConditionSupportedArrayType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arrayType = mapped
    }

    /**
     * @param value
     */
    @JvmName("bvkgsplpvypcrwmn")
    public fun arrayType(`value`: String) {
        val toBeMapped = Either.ofLeft<String,
            AutomationRulePropertyArrayChangedConditionSupportedArrayType,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.arrayType = mapped
    }

    /**
     * @param value
     */
    @JvmName("bocrupocduqaexur")
    public fun arrayType(`value`: AutomationRulePropertyArrayChangedConditionSupportedArrayType) {
        val toBeMapped = Either.ofRight<String,
            AutomationRulePropertyArrayChangedConditionSupportedArrayType,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.arrayType = mapped
    }

    /**
     * @param value
     */
    @JvmName("apujvfewmshpgeyh")
    public suspend
    fun changeType(`value`: Either<String, AutomationRulePropertyArrayChangedConditionSupportedChangeType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.changeType = mapped
    }

    /**
     * @param value
     */
    @JvmName("gxhkhwqmvutriotu")
    public fun changeType(`value`: String) {
        val toBeMapped = Either.ofLeft<String,
            AutomationRulePropertyArrayChangedConditionSupportedChangeType,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.changeType = mapped
    }

    /**
     * @param value
     */
    @JvmName("cetcppcwogvncped")
    public fun changeType(`value`: AutomationRulePropertyArrayChangedConditionSupportedChangeType) {
        val toBeMapped = Either.ofRight<String,
            AutomationRulePropertyArrayChangedConditionSupportedChangeType,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.changeType = mapped
    }

    internal fun build(): AutomationRulePropertyArrayChangedValuesConditionArgs =
        AutomationRulePropertyArrayChangedValuesConditionArgs(
            arrayType = arrayType,
            changeType = changeType,
        )
}
