@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.AwsCloudTrailDataConnectorDataTypesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The available data types for Amazon Web Services CloudTrail data connector.
 * @property logs Logs data type.
 */
public data class AwsCloudTrailDataConnectorDataTypesArgs(
    public val logs: Output<AwsCloudTrailDataConnectorDataTypesLogsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.AwsCloudTrailDataConnectorDataTypesArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityinsights.inputs.AwsCloudTrailDataConnectorDataTypesArgs =
        com.pulumi.azurenative.securityinsights.inputs.AwsCloudTrailDataConnectorDataTypesArgs.builder()
            .logs(logs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AwsCloudTrailDataConnectorDataTypesArgs].
 */
@PulumiTagMarker
public class AwsCloudTrailDataConnectorDataTypesArgsBuilder internal constructor() {
    private var logs: Output<AwsCloudTrailDataConnectorDataTypesLogsArgs>? = null

    /**
     * @param value Logs data type.
     */
    @JvmName("occgvbxinjgqxefa")
    public suspend fun logs(`value`: Output<AwsCloudTrailDataConnectorDataTypesLogsArgs>) {
        this.logs = value
    }

    /**
     * @param value Logs data type.
     */
    @JvmName("uoubresvtidehtio")
    public suspend fun logs(`value`: AwsCloudTrailDataConnectorDataTypesLogsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logs = mapped
    }

    /**
     * @param argument Logs data type.
     */
    @JvmName("cahcilmxftcmnqvt")
    public suspend
    fun logs(argument: suspend AwsCloudTrailDataConnectorDataTypesLogsArgsBuilder.() -> Unit) {
        val toBeMapped = AwsCloudTrailDataConnectorDataTypesLogsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.logs = mapped
    }

    internal fun build(): AwsCloudTrailDataConnectorDataTypesArgs =
        AwsCloudTrailDataConnectorDataTypesArgs(
            logs = logs,
        )
}
