@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.ContentPathMapArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.enums.ContentType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The mapping of content type to a repo path.
 * @property contentType Content type.
 * @property path The path to the content.
 */
public data class ContentPathMapArgs(
    public val contentType: Output<Either<String, ContentType>>? = null,
    public val path: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.ContentPathMapArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.ContentPathMapArgs =
        com.pulumi.azurenative.securityinsights.inputs.ContentPathMapArgs.builder()
            .contentType(
                contentType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .path(path?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContentPathMapArgs].
 */
@PulumiTagMarker
public class ContentPathMapArgsBuilder internal constructor() {
    private var contentType: Output<Either<String, ContentType>>? = null

    private var path: Output<String>? = null

    /**
     * @param value Content type.
     */
    @JvmName("bssyeaygjocgoril")
    public suspend fun contentType(`value`: Output<Either<String, ContentType>>) {
        this.contentType = value
    }

    /**
     * @param value The path to the content.
     */
    @JvmName("qntaetqlrmrqleke")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value Content type.
     */
    @JvmName("bbkvkbgmkwmwcfhb")
    public suspend fun contentType(`value`: Either<String, ContentType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value Content type.
     */
    @JvmName("wgsberqhdpkfctqn")
    public fun contentType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ContentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value Content type.
     */
    @JvmName("afmxvcxawjjwxopd")
    public fun contentType(`value`: ContentType) {
        val toBeMapped = Either.ofRight<String, ContentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value The path to the content.
     */
    @JvmName("konkeqvwwmjncpod")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    internal fun build(): ContentPathMapArgs = ContentPathMapArgs(
        contentType = contentType,
        path = path,
    )
}
