@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.CustomPermissionDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Custom permissions required for the connector.
 * @property description Gets or sets the custom permissions description.
 * @property name Gets or sets the custom permissions name.
 */
public data class CustomPermissionDetailsArgs(
    public val description: Output<String>,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.CustomPermissionDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.CustomPermissionDetailsArgs =
        com.pulumi.azurenative.securityinsights.inputs.CustomPermissionDetailsArgs.builder()
            .description(description.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomPermissionDetailsArgs].
 */
@PulumiTagMarker
public class CustomPermissionDetailsArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Gets or sets the custom permissions description.
     */
    @JvmName("lqgncuxgpvidktcm")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Gets or sets the custom permissions name.
     */
    @JvmName("xgaysarinfynxqyq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Gets or sets the custom permissions description.
     */
    @JvmName("pqyxxdhkntffqfhh")
    public suspend fun description(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Gets or sets the custom permissions name.
     */
    @JvmName("ecjifuotdckprofj")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): CustomPermissionDetailsArgs = CustomPermissionDetailsArgs(
        description = description ?: throw PulumiNullFieldException("description"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
