@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.EntityMappingArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.enums.EntityMappingType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Single entity mapping for the alert rule
 * @property entityType The V3 type of the mapped entity
 * @property fieldMappings array of field mappings for the given entity mapping
 */
public data class EntityMappingArgs(
    public val entityType: Output<Either<String, EntityMappingType>>? = null,
    public val fieldMappings: Output<List<FieldMappingArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.EntityMappingArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.EntityMappingArgs =
        com.pulumi.azurenative.securityinsights.inputs.EntityMappingArgs.builder()
            .entityType(
                entityType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .fieldMappings(
                fieldMappings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [EntityMappingArgs].
 */
@PulumiTagMarker
public class EntityMappingArgsBuilder internal constructor() {
    private var entityType: Output<Either<String, EntityMappingType>>? = null

    private var fieldMappings: Output<List<FieldMappingArgs>>? = null

    /**
     * @param value The V3 type of the mapped entity
     */
    @JvmName("awvdqbvwopkieosm")
    public suspend fun entityType(`value`: Output<Either<String, EntityMappingType>>) {
        this.entityType = value
    }

    /**
     * @param value array of field mappings for the given entity mapping
     */
    @JvmName("dqrbpnqslpiaqwlw")
    public suspend fun fieldMappings(`value`: Output<List<FieldMappingArgs>>) {
        this.fieldMappings = value
    }

    @JvmName("rsempffspmlevguo")
    public suspend fun fieldMappings(vararg values: Output<FieldMappingArgs>) {
        this.fieldMappings = Output.all(values.asList())
    }

    /**
     * @param values array of field mappings for the given entity mapping
     */
    @JvmName("ukhtlmewgwmyejkt")
    public suspend fun fieldMappings(values: List<Output<FieldMappingArgs>>) {
        this.fieldMappings = Output.all(values)
    }

    /**
     * @param value The V3 type of the mapped entity
     */
    @JvmName("resyrjceojnhjoll")
    public suspend fun entityType(`value`: Either<String, EntityMappingType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entityType = mapped
    }

    /**
     * @param value The V3 type of the mapped entity
     */
    @JvmName("fjdvnpyymmqouwsw")
    public fun entityType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EntityMappingType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.entityType = mapped
    }

    /**
     * @param value The V3 type of the mapped entity
     */
    @JvmName("xiaaewtysymuktqe")
    public fun entityType(`value`: EntityMappingType) {
        val toBeMapped = Either.ofRight<String, EntityMappingType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.entityType = mapped
    }

    /**
     * @param value array of field mappings for the given entity mapping
     */
    @JvmName("vpmodwtjweuidwvi")
    public suspend fun fieldMappings(`value`: List<FieldMappingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fieldMappings = mapped
    }

    /**
     * @param argument array of field mappings for the given entity mapping
     */
    @JvmName("umlufmjjunulcwfj")
    public suspend fun fieldMappings(argument: List<suspend FieldMappingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FieldMappingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.fieldMappings = mapped
    }

    /**
     * @param argument array of field mappings for the given entity mapping
     */
    @JvmName("ctbwwkhtdpvspxbk")
    public suspend fun fieldMappings(vararg argument: suspend FieldMappingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FieldMappingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.fieldMappings = mapped
    }

    /**
     * @param argument array of field mappings for the given entity mapping
     */
    @JvmName("ujjrogfpvonqdgwx")
    public suspend fun fieldMappings(argument: suspend FieldMappingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(FieldMappingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.fieldMappings = mapped
    }

    /**
     * @param values array of field mappings for the given entity mapping
     */
    @JvmName("eegpenbtcwwxenth")
    public suspend fun fieldMappings(vararg values: FieldMappingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fieldMappings = mapped
    }

    internal fun build(): EntityMappingArgs = EntityMappingArgs(
        entityType = entityType,
        fieldMappings = fieldMappings,
    )
}
