@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.FieldMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A single field mapping of the mapped entity
 * @property columnName the column name to be mapped to the identifier
 * @property identifier the V3 identifier of the entity
 */
public data class FieldMappingArgs(
    public val columnName: Output<String>? = null,
    public val identifier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.FieldMappingArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.FieldMappingArgs =
        com.pulumi.azurenative.securityinsights.inputs.FieldMappingArgs.builder()
            .columnName(columnName?.applyValue({ args0 -> args0 }))
            .identifier(identifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FieldMappingArgs].
 */
@PulumiTagMarker
public class FieldMappingArgsBuilder internal constructor() {
    private var columnName: Output<String>? = null

    private var identifier: Output<String>? = null

    /**
     * @param value the column name to be mapped to the identifier
     */
    @JvmName("iphpifkroibnppmq")
    public suspend fun columnName(`value`: Output<String>) {
        this.columnName = value
    }

    /**
     * @param value the V3 identifier of the entity
     */
    @JvmName("irhqxuxqyfbouxjl")
    public suspend fun identifier(`value`: Output<String>) {
        this.identifier = value
    }

    /**
     * @param value the column name to be mapped to the identifier
     */
    @JvmName("rowoyqhyvvyxdquy")
    public suspend fun columnName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.columnName = mapped
    }

    /**
     * @param value the V3 identifier of the entity
     */
    @JvmName("prapxfqicxrqobsf")
    public suspend fun identifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identifier = mapped
    }

    internal fun build(): FieldMappingArgs = FieldMappingArgs(
        columnName = columnName,
        identifier = identifier,
    )
}
