@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.GetAnomalySecurityMLAnalyticsSettingsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property settingsResourceName Security ML Analytics Settings resource name
 * @property workspaceName The name of the workspace.
 */
public data class GetAnomalySecurityMLAnalyticsSettingsPlainArgs(
    public val resourceGroupName: String,
    public val settingsResourceName: String,
    public val workspaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.GetAnomalySecurityMLAnalyticsSettingsPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.securityinsights.inputs.GetAnomalySecurityMLAnalyticsSettingsPlainArgs =
        com.pulumi.azurenative.securityinsights.inputs.GetAnomalySecurityMLAnalyticsSettingsPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .settingsResourceName(settingsResourceName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAnomalySecurityMLAnalyticsSettingsPlainArgs].
 */
@PulumiTagMarker
public class GetAnomalySecurityMLAnalyticsSettingsPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var settingsResourceName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hkoaaqirhgdcqprc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Security ML Analytics Settings resource name
     */
    @JvmName("byotvyccspqhptbr")
    public suspend fun settingsResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.settingsResourceName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("vixoavgixlghrcnk")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetAnomalySecurityMLAnalyticsSettingsPlainArgs =
        GetAnomalySecurityMLAnalyticsSettingsPlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            settingsResourceName = settingsResourceName ?: throw
                PulumiNullFieldException("settingsResourceName"),
            workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
        )
}
