@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.GetEntityAnalyticsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property settingsName The setting name. Supports - Anomalies, EyesOn, EntityAnalytics, Ueba
 * @property workspaceName The name of the workspace.
 */
public data class GetEntityAnalyticsPlainArgs(
    public val resourceGroupName: String,
    public val settingsName: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.GetEntityAnalyticsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.GetEntityAnalyticsPlainArgs =
        com.pulumi.azurenative.securityinsights.inputs.GetEntityAnalyticsPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .settingsName(settingsName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEntityAnalyticsPlainArgs].
 */
@PulumiTagMarker
public class GetEntityAnalyticsPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var settingsName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sihjpiidrmuqqfgh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The setting name. Supports - Anomalies, EyesOn, EntityAnalytics, Ueba
     */
    @JvmName("acluvchdaxwglmeo")
    public suspend fun settingsName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.settingsName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("mihhhvkpbwbnfguf")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetEntityAnalyticsPlainArgs = GetEntityAnalyticsPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        settingsName = settingsName ?: throw PulumiNullFieldException("settingsName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
