@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.GetHuntRelationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property huntId The hunt id (GUID)
 * @property huntRelationId The hunt relation id (GUID)
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName The name of the workspace.
 */
public data class GetHuntRelationPlainArgs(
    public val huntId: String,
    public val huntRelationId: String,
    public val resourceGroupName: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.GetHuntRelationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.GetHuntRelationPlainArgs =
        com.pulumi.azurenative.securityinsights.inputs.GetHuntRelationPlainArgs.builder()
            .huntId(huntId.let({ args0 -> args0 }))
            .huntRelationId(huntRelationId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetHuntRelationPlainArgs].
 */
@PulumiTagMarker
public class GetHuntRelationPlainArgsBuilder internal constructor() {
    private var huntId: String? = null

    private var huntRelationId: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The hunt id (GUID)
     */
    @JvmName("famlixinaqrbxtpf")
    public suspend fun huntId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.huntId = mapped
    }

    /**
     * @param value The hunt relation id (GUID)
     */
    @JvmName("sqkcuatksrdxweja")
    public suspend fun huntRelationId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.huntRelationId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yfxyvwqjmtjuhlsc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("lnvqavrywxxxxqlo")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetHuntRelationPlainArgs = GetHuntRelationPlainArgs(
        huntId = huntId ?: throw PulumiNullFieldException("huntId"),
        huntRelationId = huntRelationId ?: throw PulumiNullFieldException("huntRelationId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
