@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.GetIncidentCommentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property incidentCommentId Incident comment ID
 * @property incidentId Incident ID
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName The name of the workspace.
 */
public data class GetIncidentCommentPlainArgs(
    public val incidentCommentId: String,
    public val incidentId: String,
    public val resourceGroupName: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.GetIncidentCommentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.GetIncidentCommentPlainArgs =
        com.pulumi.azurenative.securityinsights.inputs.GetIncidentCommentPlainArgs.builder()
            .incidentCommentId(incidentCommentId.let({ args0 -> args0 }))
            .incidentId(incidentId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIncidentCommentPlainArgs].
 */
@PulumiTagMarker
public class GetIncidentCommentPlainArgsBuilder internal constructor() {
    private var incidentCommentId: String? = null

    private var incidentId: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value Incident comment ID
     */
    @JvmName("vjfjcboahnutpghw")
    public suspend fun incidentCommentId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.incidentCommentId = mapped
    }

    /**
     * @param value Incident ID
     */
    @JvmName("gwtnkjxdbsjksjdg")
    public suspend fun incidentId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.incidentId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vwfrlopnsyttskwu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("jaojhgvcukwfofua")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetIncidentCommentPlainArgs = GetIncidentCommentPlainArgs(
        incidentCommentId = incidentCommentId ?: throw PulumiNullFieldException("incidentCommentId"),
        incidentId = incidentId ?: throw PulumiNullFieldException("incidentId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
